/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.config.migrate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lopymine.patpat.PatPat;
import net.lopymine.patpat.client.config.resourcepack.ListMode;
import net.lopymine.patpat.common.migrate.AbstractConfigMigrateHandler;
import net.lopymine.patpat.server.config.PatPatServerConfig;
import net.lopymine.patpat.server.config.list.PatPatServerPlayerListConfig;

public class PatPatServerConfigMigrateVersion0
extends AbstractConfigMigrateHandler {
    private static final String MIGRATE_FILE_NAME = "patpat.json5";
    private static final String MIGRATE_VERSION = "0";
    private PatPatServerConfig config;
    private PatPatServerPlayerListConfig listConfig;

    public PatPatServerConfigMigrateVersion0() {
        super(MIGRATE_FILE_NAME, MIGRATE_VERSION, PatPat.LOGGER);
    }

    @Override
    public boolean needToMigrateFile() {
        try {
            File migrateFile = this.getMigrateFile().toFile();
            JsonObject object = (JsonObject)GSON.fromJson(new JsonReader((Reader)new FileReader(migrateFile)), JsonObject.class);
            return !object.has("version");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean migrateFile() {
        File migrateFile = this.getMigrateFile().toFile();
        Configs configs = this.transform(migrateFile);
        if (configs == null) {
            return false;
        }
        if (this.isShouldSave()) {
            configs.saveAndReload();
        }
        return true;
    }

    public Configs transform(File file) {
        Configs configs = null;
        AtomicBoolean success = new AtomicBoolean(true);
        try (FileReader reader = new FileReader(file);){
            JsonObject rootObj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String listModeStr = rootObj.get("listMode").getAsString();
            PatPatServerConfig config = this.config == null ? PatPatServerConfig.getNewInstance().get() : this.config;
            config.setListMode(ListMode.getByIdOrDefault(listModeStr, ListMode.DISABLED));
            PatPatServerPlayerListConfig playerListConfig = this.listConfig == null ? new PatPatServerPlayerListConfig() : this.listConfig;
            Map<UUID, String> map = playerListConfig.getValues();
            HashMap oldConfigMap = new HashMap();
            JsonObject jsonObject = rootObj.getAsJsonObject("list");
            jsonObject.entrySet().forEach(entry -> {
                try {
                    String uuid = (String)entry.getKey();
                    String nickname = ((JsonElement)entry.getValue()).getAsString();
                    String uuidString = new StringBuilder(uuid).insert(8, "-").insert(12, "-").insert(16, "-").insert(20, "-").toString();
                    oldConfigMap.put(UUID.fromString(uuidString), nickname);
                }
                catch (IllegalArgumentException e) {
                    PatPat.LOGGER.error("Line '%s' cannot parse uuid".formatted(entry), e);
                    success.set(false);
                }
            });
            map.clear();
            map.putAll(oldConfigMap);
            if (success.get()) {
                configs = new Configs(config, playerListConfig);
            }
        }
        catch (IOException e) {
            PatPat.LOGGER.error("Failed to read patpat.json5", e);
            return null;
        }
        return configs;
    }

    public void setConfig(PatPatServerConfig config) {
        this.config = config;
    }

    public void setListConfig(PatPatServerPlayerListConfig listConfig) {
        this.listConfig = listConfig;
    }

    public record Configs(PatPatServerConfig config, PatPatServerPlayerListConfig playerListConfig) {
        public void saveAndReload() {
            this.config.save();
            PatPatServerConfig.reload();
            this.playerListConfig.saveAsync();
            PatPatServerPlayerListConfig.getInstance().reload();
        }
    }
}

