/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.ratelimit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.lopymine.patpat.common.config.time.Time;
import net.lopymine.patpat.extension.PlayerExtension;
import net.lopymine.patpat.server.config.PatPatServerConfig;
import net.lopymine.patpat.server.config.sub.PatPatServerRateLimitConfig;
import net.lopymine.patpat.server.ratelimit.PatPatServerRateLimitTask;
import net.minecraft.class_3222;

public class PatPatServerRateLimitManager {
    private static Timer timer;
    private static final Map<UUID, Integer> uuidToPat;

    private PatPatServerRateLimitManager() {
        throw new IllegalStateException("Manager class");
    }

    public static int getAvailablePats(UUID uuid) {
        return uuidToPat.getOrDefault(uuid, PatPatServerConfig.getInstance().getRateLimitConfig().getTokenLimit());
    }

    public static boolean canPat(class_3222 player) {
        PatPatServerRateLimitConfig config = PatPatServerConfig.getInstance().getRateLimitConfig();
        if (!config.isEnabled()) {
            return true;
        }
        if (PlayerExtension.hasPermission(player, config.getPermissionBypass())) {
            return true;
        }
        UUID uuid = player.method_5667();
        int availablePats = uuidToPat.getOrDefault(uuid, config.getTokenLimit()) - 1;
        if (availablePats < 0) {
            return false;
        }
        uuidToPat.put(uuid, availablePats);
        return true;
    }

    public static void addPats(int token) {
        int tokenLimit = PatPatServerConfig.getInstance().getRateLimitConfig().getTokenLimit();
        Iterator<Map.Entry<UUID, Integer>> it = uuidToPat.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Integer> entry = it.next();
            int value = entry.getValue() + token;
            if (value > tokenLimit) {
                it.remove();
                continue;
            }
            uuidToPat.put(entry.getKey(), value);
        }
    }

    public static void runTask() {
        if (timer != null) {
            return;
        }
        PatPatServerRateLimitConfig config = PatPatServerConfig.getInstance().getRateLimitConfig();
        if (!config.isEnabled()) {
            return;
        }
        Time configInterval = config.getTokenIncrementInterval();
        long period = (long)(configInterval.getValue() * configInterval.getUnit().getMultiplier()) * 1000L;
        timer = new Timer("patpat/PatPatServerRateLimitTask");
        timer.scheduleAtFixedRate((TimerTask)new PatPatServerRateLimitTask(), 0L, period);
    }

    public static void stopTask() {
        if (timer != null) {
            timer.cancel();
        }
        timer = null;
    }

    public static void reloadTask() {
        PatPatServerRateLimitManager.stopTask();
        PatPatServerRateLimitManager.runTask();
    }

    static {
        uuidToPat = new HashMap<UUID, Integer>();
    }
}

