/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.resourcepack;

import java.util.Random;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.resourcepack.SoundConfig;
import net.lopymine.patpat.entity.PatEntity;
import net.lopymine.patpat.utils.IdentifierUtils;
import net.lopymine.patpat.utils.SoundUtils;
import net.lopymine.patpat.utils.VersionedThings;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_638;

public class PatPatClientSoundManager {
    public static final PatLogger LOGGER = PatPatClient.LOGGER.extend("SoundManager");
    private static class_3414 patPatSoundEvent;
    private static class_3414 lopiSoundEvent;

    private PatPatClientSoundManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void register() {
        lopiSoundEvent = PatPatClientSoundManager.getLopiSoundEvent();
        patPatSoundEvent = PatPatClientSoundManager.getPatPatSoundEvent();
    }

    public static class_3414 getLopiSoundEvent() {
        if (lopiSoundEvent == null) {
            lopiSoundEvent = PatPatClientSoundManager.registerModSound("lopi");
        }
        return lopiSoundEvent;
    }

    public static class_3414 getPatPatSoundEvent() {
        if (patPatSoundEvent == null) {
            patPatSoundEvent = PatPatClientSoundManager.registerModSound("patpat");
        }
        return patPatSoundEvent;
    }

    private static class_3414 registerModSound(String id) {
        return (class_3414)class_2378.method_10230(VersionedThings.SOUND_EVENT, (class_2960)IdentifierUtils.modId(id), (Object)SoundUtils.getSoundEvent(id));
    }

    public static void playSound(PatEntity whoPatted, class_1657 pattedEntity, double volume) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        SoundConfig soundConfig = whoPatted.getAnimation().getSoundConfig();
        if (soundConfig == null) {
            LOGGER.debug("Failed to find sound config in animation: {}", whoPatted.getAnimation());
            return;
        }
        LOGGER.debug("Playing sound from config {}, whoPatted: {}, pattedEntity: {}", soundConfig.toString(), whoPatted.toString(), pattedEntity.toString());
        class_3414 soundEvent = soundConfig.getSound();
        world.method_8396(pattedEntity, whoPatted.getEntity().method_24515(), soundEvent, class_3419.field_15248, soundConfig.getVolume() * (float)volume, class_3532.method_15344((Random)world.field_9229, (float)soundConfig.getMinPitch(), (float)soundConfig.getMaxPitch()));
    }
}

