/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.command.list;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.lopymine.patpat.client.command.argument.PlayerInfoArgumentType;
import net.lopymine.patpat.client.config.list.PatPatClientPlayerListConfig;
import net.lopymine.patpat.common.command.list.PatPatCommonListChangeCommand;
import net.lopymine.patpat.extension.ClientCommandExtension;
import net.lopymine.patpat.utils.ClientNetworkUtils;
import net.minecraft.class_2172;

public class PatPatClientListChangeCommand {
    private static final String PLAYER_ARGUMENT_NAME = "player";

    private PatPatClientListChangeCommand() {
        throw new IllegalStateException("Command class");
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> getAdd() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)PLAYER_ARGUMENT_NAME, (ArgumentType)PlayerInfoArgumentType.player()).suggests((context, builder) -> class_2172.method_9265((Iterable)((FabricClientCommandSource)context.getSource()).method_9262(), (SuggestionsBuilder)builder)).executes(context -> PatPatClientListChangeCommand.onListChange((CommandContext<FabricClientCommandSource>)context, true)));
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> getRemove() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)PLAYER_ARGUMENT_NAME, (ArgumentType)PlayerInfoArgumentType.player()).suggests((context, builder) -> class_2172.method_9265(ClientNetworkUtils.getOnlinePlayersFromUuids(((FabricClientCommandSource)context.getSource()).getClient().method_1562()), (SuggestionsBuilder)builder)).executes(context -> PatPatClientListChangeCommand.onListChange((CommandContext<FabricClientCommandSource>)context, false)));
    }

    private static int onListChange(CommandContext<FabricClientCommandSource> context, boolean add) {
        PatPatClientPlayerListConfig config = PatPatClientPlayerListConfig.getInstance();
        Map<UUID, String> map = config.getValues();
        PlayerInfoArgumentType.PlayerInfo playerInfo = PlayerInfoArgumentType.getPlayerInfo(PLAYER_ARGUMENT_NAME, context);
        UUID uuid = playerInfo.uuid();
        String name = playerInfo.nickname();
        PatPatCommonListChangeCommand.changeList(add, map, uuid, name, component -> ClientCommandExtension.sendMsg(context, component));
        config.saveAsync();
        return 1;
    }
}

