/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.manager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.PatPatClientConfig;
import net.lopymine.patpat.client.config.list.PatPatClientIgnoreMobListConfig;
import net.lopymine.patpat.client.config.resourcepack.CustomAnimationSettingsConfig;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.lopymine.patpat.client.keybinding.PatPatClientKeybindingManager;
import net.lopymine.patpat.client.render.PatPatClientRenderer;
import net.lopymine.patpat.entity.PatEntity;
import net.lopymine.patpat.extension.EntityExtension;
import net.lopymine.patpat.utils.ProfilerUtils;
import net.lopymine.patpat.utils.VersionedThings;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import net.minecraft.class_9817;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatPatClientManager {
    private static final Map<UUID, PatEntity> PAT_ENTITIES = new HashMap<UUID, PatEntity>();
    public static final PatLogger LOGGER = PatPatClient.LOGGER.extend("PatManager");
    private static int patCooldown = 0;

    private PatPatClientManager() {
        throw new IllegalStateException("Manager class");
    }

    @Nullable
    public static PatEntity getPatEntity(@NotNull class_1309 entity) {
        return PAT_ENTITIES.get(entity.method_5667());
    }

    public static void tickEntities() {
        PAT_ENTITIES.forEach((uuid, patEntity) -> patEntity.tick());
    }

    public static void removePatEntity(@NotNull class_1309 entity) {
        PAT_ENTITIES.remove(entity.method_5667());
    }

    public static void removePatEntity(@NotNull PatEntity patEntity) {
        class_1309 entity = patEntity.getEntity();
        if (entity != null) {
            PatPatClientManager.removePatEntity(entity);
        }
    }

    public static PatEntity pat(@NotNull class_1309 entity, @NotNull PlayerConfig whoPatted) {
        LOGGER.debug("{} just patted {}", whoPatted.getName(), entity.method_5477().getString());
        UUID uuid = entity.method_5667();
        PatEntity patEntity = PAT_ENTITIES.get(uuid);
        if (patEntity == null) {
            patEntity = new PatEntity(entity, whoPatted);
            PAT_ENTITIES.put(uuid, patEntity);
        } else {
            patEntity.resetAnimation();
        }
        return patEntity;
    }

    public static boolean expired(PatEntity patEntity, float tickDelta) {
        CustomAnimationSettingsConfig animationConfig = patEntity.getAnimation();
        int duration = animationConfig.getDuration();
        return patEntity.getProgress(tickDelta) > (float)duration;
    }

    public static float getAnimationProgress(PatEntity patEntity, float tickDelta) {
        CustomAnimationSettingsConfig animationConfig = patEntity.getAnimation();
        int duration = animationConfig.getDuration();
        float animationProgress = patEntity.getProgress(tickDelta) / (float)duration;
        animationProgress = (float)(1.0 - Math.pow(1.0f - animationProgress, 2.0));
        int totalFrames = animationConfig.getFrameConfig().totalFrames();
        int frame = class_3532.method_15340((int)((int)Math.floor((float)totalFrames * animationProgress)), (int)0, (int)(totalFrames - 1));
        patEntity.setCurrentFrame(frame);
        float range = PatPatClientConfig.getInstance().getVisualConfig().getPatWeight() / patEntity.getEntity().method_17682();
        return (float)((double)(1.0f - range) + (double)range * (1.0 - Math.sin((double)animationProgress * Math.PI)));
    }

    public static void clearPatEntities() {
        PAT_ENTITIES.clear();
    }

    public static void requestPat() {
        PatPatClientConfig config = PatPatClientConfig.getInstance();
        if (!config.getMainConfig().isModEnabled()) {
            return;
        }
        if (!PatPatClientKeybindingManager.getPatKeybinding().method_1434()) {
            return;
        }
        if (patCooldown != 0) {
            LOGGER.debug("Pat rejected: Cooldown", new Object[0]);
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            LOGGER.debug("Pat rejected: Player is null", new Object[0]);
            return;
        }
        if (player.method_29504()) {
            LOGGER.debug("Pat rejected: Player is dead", new Object[0]);
            return;
        }
        class_1309 pattedEntity = PatPatClientManager.getPatEntityFromHitResult();
        if (pattedEntity == null) {
            LOGGER.debug("Pat rejected: Patted entity is null", new Object[0]);
            return;
        }
        PatPatClientRenderer.registerClientPacket(new PatPatClientRenderer.PatPacket(pattedEntity, PlayerConfig.currentSession(), player, false));
        patCooldown = 4;
    }

    public static boolean canPat() {
        PatPatClientConfig config = PatPatClientConfig.getInstance();
        if (!config.getMainConfig().isModEnabled()) {
            return false;
        }
        if (!PatPatClientKeybindingManager.getPatKeybinding().method_1434()) {
            return false;
        }
        return PatPatClientManager.getPatEntityFromHitResult() != null;
    }

    @Nullable
    public static class_1309 getPatEntityFromHitResult() {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null || minecraft.field_1687 == null || player.method_29504()) {
            return null;
        }
        if (!player.method_6047().method_7960()) {
            LOGGER.debug("Pat rejected: Main hand is not empty", new Object[0]);
            return null;
        }
        class_1297 cameraEntity = minecraft.method_1560();
        if (cameraEntity == null) {
            LOGGER.debug("Pat rejected: Camera entity is null", new Object[0]);
            return null;
        }
        ProfilerUtils.push("patpat$pick");
        double blockInteractionRange = player.method_55754();
        double entityInteractionRange = player.method_55755();
        float tickDelta = minecraft.method_60646().method_60637(false);
        EntityExtension.mark(cameraEntity, true);
        class_239 result = minecraft.field_1773.method_56153(cameraEntity, blockInteractionRange, entityInteractionRange, tickDelta);
        EntityExtension.mark(cameraEntity, false);
        ProfilerUtils.pop();
        if (!(result instanceof class_3966)) {
            LOGGER.debug("Pat rejected: No entity in crosshair", new Object[0]);
            return null;
        }
        class_3966 hitResult = (class_3966)result;
        if (PatPatClientManager.hasActiveLeash((class_1657)player)) {
            LOGGER.debug("Pat rejected: Player has lead", new Object[0]);
            return null;
        }
        class_1297 class_12972 = hitResult.method_17782();
        if (!(class_12972 instanceof class_1309)) {
            LOGGER.debug("Pat rejected: Entity is not LivingEntity", new Object[0]);
            return null;
        }
        class_1309 pattedEntity = (class_1309)class_12972;
        if (pattedEntity.method_5767()) {
            LOGGER.debug("Pat rejected: Patted entity is invisible", new Object[0]);
            return null;
        }
        if (PatPatClientIgnoreMobListConfig.getInstance().isIgnored(pattedEntity.method_5864())) {
            LOGGER.debug("Pat rejected: Entity type in IgnoreMobList", new Object[0]);
            return null;
        }
        return pattedEntity;
    }

    private static boolean hasActiveLeash(class_1657 player) {
        double d = 32.0;
        class_238 aABB = VersionedThings.getAABBFromPosition(player.method_30950(0.0f), d, d, d);
        for (class_1297 entity : VersionedThings.getLevel((class_1297)player).method_18467(class_1297.class, aABB)) {
            class_9817 leashable;
            if (!(entity instanceof class_9817) || (leashable = (class_9817)entity).method_60952() != player) continue;
            return true;
        }
        return false;
    }

    @Generated
    public static void setPatCooldown(int patCooldown) {
        PatPatClientManager.patCooldown = patCooldown;
    }

    @Generated
    public static int getPatCooldown() {
        return patCooldown;
    }
}

