/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.command.list;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.lopymine.patpat.client.config.resourcepack.ListMode;
import net.lopymine.patpat.extension.CommandExtension;
import net.lopymine.patpat.server.config.PatPatServerConfig;
import net.lopymine.patpat.utils.CommandText;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class PatPatServerListSetModeCommand {
    private PatPatServerListSetModeCommand() {
        throw new IllegalStateException("Command class");
    }

    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(context -> CommandExtension.hasPatPatPermission(context, "list.set"))).then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(List.of("WHITELIST", "BLACKLIST", "DISABLED"), (SuggestionsBuilder)builder)).executes(PatPatServerListSetModeCommand::setListMode));
    }

    public static int setListMode(CommandContext<class_2168> context) {
        boolean success;
        String modeId = StringArgumentType.getString(context, (String)"mode");
        PatPatServerConfig config = PatPatServerConfig.getInstance();
        ListMode listMode = ListMode.getById(modeId);
        if (config.getListMode() == listMode) {
            class_5250 text = CommandText.goldenArgs("list.set.already", listMode == null ? "null" : listMode.getText()).finish();
            CommandExtension.sendMsg(context, (class_2561)text);
            return 0;
        }
        boolean bl = success = listMode != null;
        if (success) {
            config.setListMode(listMode);
            config.saveAsync();
        }
        String result = success ? "success" : "failed";
        String key = String.format("list.set.%s", result);
        String arg = success ? listMode.getText() : modeId;
        class_5250 text = CommandText.goldenArgs(key, arg).finish();
        CommandExtension.sendMsg(context, (class_2561)text);
        return success ? 1 : 0;
    }
}

