/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import lombok.Generated;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.client.config.sub.PatPatClientFunConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientMainConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientMultiplayerConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientProximityPacketsConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientResourcePacksConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientSoundsConfig;
import net.lopymine.patpat.client.config.sub.PatPatClientVisualConfig;
import net.lopymine.patpat.common.Version;
import net.lopymine.patpat.common.config.PatPatConfigManager;
import net.lopymine.patpat.utils.CodecUtils;
import net.lopymine.patpat.utils.ConfigUtils;

public class PatPatClientConfig {
    public static final Codec<PatPatClientConfig> CODEC = RecordCodecBuilder.create(inst -> inst.group(CodecUtils.option("version", Version.CLIENT_CONFIG_VERSION, Version.CODEC, PatPatClientConfig::getVersion), CodecUtils.option("main", PatPatClientMainConfig.getNewInstance(), PatPatClientMainConfig.CODEC, PatPatClientConfig::getMainConfig), CodecUtils.option("resourcePacks", PatPatClientResourcePacksConfig.getNewInstance(), PatPatClientResourcePacksConfig.CODEC, PatPatClientConfig::getResourcePacksConfig), CodecUtils.option("sounds", PatPatClientSoundsConfig.getNewInstance(), PatPatClientSoundsConfig.CODEC, PatPatClientConfig::getSoundsConfig), CodecUtils.option("visual", PatPatClientVisualConfig.getNewInstance(), PatPatClientVisualConfig.CODEC, PatPatClientConfig::getVisualConfig), CodecUtils.option("multiplayer", PatPatClientMultiplayerConfig.getNewInstance(), PatPatClientMultiplayerConfig.CODEC, PatPatClientConfig::getMultiPlayerConfig), CodecUtils.option("proximityPackets", PatPatClientProximityPacketsConfig.getNewInstance(), PatPatClientProximityPacketsConfig.CODEC, PatPatClientConfig::getProximityPacketsConfig), CodecUtils.option("fun", PatPatClientFunConfig.getNewInstance(), PatPatClientFunConfig.CODEC, PatPatClientConfig::getFunConfig)).apply((Applicative)inst, PatPatClientConfig::new));
    private static final PatLogger LOGGER = PatPatClient.LOGGER.extend("Config");
    private static final File CONFIG_FILE = PatPatConfigManager.CONFIG_PATH.resolve("patpat-client.json5").toFile();
    private static PatPatClientConfig instance;
    private Version version;
    private PatPatClientMainConfig mainConfig;
    private PatPatClientResourcePacksConfig resourcePacksConfig;
    private PatPatClientSoundsConfig soundsConfig;
    private PatPatClientVisualConfig visualConfig;
    private PatPatClientMultiplayerConfig multiPlayerConfig;
    private PatPatClientProximityPacketsConfig proximityPacketsConfig;
    private PatPatClientFunConfig funConfig;

    public static PatPatClientConfig getInstance() {
        return instance == null ? PatPatClientConfig.reload() : instance;
    }

    public static PatPatClientConfig reload() {
        instance = PatPatClientConfig.read();
        return instance;
    }

    public static Supplier<PatPatClientConfig> getNewInstance() {
        return () -> CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static PatPatClientConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    @Generated
    public PatPatClientMainConfig getMainConfig() {
        return this.mainConfig;
    }

    @Generated
    public PatPatClientResourcePacksConfig getResourcePacksConfig() {
        return this.resourcePacksConfig;
    }

    @Generated
    public PatPatClientSoundsConfig getSoundsConfig() {
        return this.soundsConfig;
    }

    @Generated
    public PatPatClientVisualConfig getVisualConfig() {
        return this.visualConfig;
    }

    @Generated
    public PatPatClientMultiplayerConfig getMultiPlayerConfig() {
        return this.multiPlayerConfig;
    }

    @Generated
    public PatPatClientProximityPacketsConfig getProximityPacketsConfig() {
        return this.proximityPacketsConfig;
    }

    @Generated
    public PatPatClientFunConfig getFunConfig() {
        return this.funConfig;
    }

    @Generated
    public PatPatClientConfig(Version version, PatPatClientMainConfig mainConfig, PatPatClientResourcePacksConfig resourcePacksConfig, PatPatClientSoundsConfig soundsConfig, PatPatClientVisualConfig visualConfig, PatPatClientMultiplayerConfig multiPlayerConfig, PatPatClientProximityPacketsConfig proximityPacketsConfig, PatPatClientFunConfig funConfig) {
        this.version = version;
        this.mainConfig = mainConfig;
        this.resourcePacksConfig = resourcePacksConfig;
        this.soundsConfig = soundsConfig;
        this.visualConfig = visualConfig;
        this.multiPlayerConfig = multiPlayerConfig;
        this.proximityPacketsConfig = proximityPacketsConfig;
        this.funConfig = funConfig;
    }

    @Generated
    public void setVersion(Version version) {
        this.version = version;
    }
}

