/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.entity;

import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import net.lopymine.patpat.client.config.resourcepack.CustomAnimationSettingsConfig;
import net.lopymine.patpat.client.config.resourcepack.PlayerConfig;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8921;

public class PatEntity {
    private final class_1309 entity;
    private final CustomAnimationSettingsConfig animation;
    private int currentFrame;
    private int tickProgress;

    public PatEntity(class_1309 entity, PlayerConfig whoPatted) {
        this.entity = entity;
        this.animation = CustomAnimationSettingsConfig.of(entity, whoPatted);
        this.currentFrame = 0;
        this.tickProgress = -1;
    }

    public void resetAnimation() {
        this.currentFrame = 0;
        this.tickProgress = -1;
    }

    public void tick() {
        ++this.tickProgress;
        if (this.tickProgress == Integer.MAX_VALUE) {
            this.tickProgress = 0;
        }
    }

    public float getProgress(float tickDelta) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return 0.0f;
        }
        class_8921 tickManager = world.method_54719();
        float tickMillis = tickManager.method_54748() > 20.0f ? 2500.0f / tickManager.method_54749() : 50.0f;
        float v = (float)Math.max(this.tickProgress, 0) * tickMillis;
        float v1 = tickManager.method_54754() ? 0.0f : tickDelta * tickMillis;
        return v + v1;
    }

    public boolean is(class_1309 entity) {
        return this.is(entity.method_5667());
    }

    private boolean is(UUID uuid) {
        return this.entity.method_5667().equals(uuid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatEntity patEntity = (PatEntity)o;
        return this.is(patEntity.getEntity());
    }

    public int hashCode() {
        return Objects.hash(this.entity.method_5667());
    }

    public String toString() {
        return "PatEntity{entity=" + this.entity.toString() + ", animation=" + this.animation.toString() + ", currentFrame=" + this.currentFrame + ", tickProgress=" + this.tickProgress + "}";
    }

    @Generated
    public class_1309 getEntity() {
        return this.entity;
    }

    @Generated
    public CustomAnimationSettingsConfig getAnimation() {
        return this.animation;
    }

    @Generated
    public int getCurrentFrame() {
        return this.currentFrame;
    }

    @Generated
    public int getTickProgress() {
        return this.tickProgress;
    }

    @Generated
    public void setCurrentFrame(int currentFrame) {
        this.currentFrame = currentFrame;
    }
}

