/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.modmenu.bridge;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.LongFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.LongSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.util.List;
import net.lopymine.patpat.modmenu.PatConfig;
import net.lopymine.patpat.modmenu.common.PatCategory;
import net.lopymine.patpat.modmenu.common.PatDescription;
import net.lopymine.patpat.modmenu.common.PatElement;
import net.lopymine.patpat.modmenu.common.PatGroup;
import net.lopymine.patpat.modmenu.common.image.AbstractPatImage;
import net.lopymine.patpat.modmenu.common.image.PatImage;
import net.lopymine.patpat.modmenu.common.image.PatRenderer;
import net.lopymine.patpat.modmenu.common.option.AbstractPatOption;
import net.lopymine.patpat.modmenu.common.option.BooleanOption;
import net.lopymine.patpat.modmenu.common.option.EnumOption;
import net.lopymine.patpat.modmenu.common.option.NumberOption;
import net.lopymine.patpat.modmenu.common.option.PatListOption;
import net.lopymine.patpat.modmenu.common.option.PatOption;
import net.lopymine.patpat.modmenu.common.option.SliderNumberOption;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class YACLBridge {
    private YACLBridge() {
        throw new IllegalStateException("Bridge class");
    }

    public static class_437 getScreen(@Nullable class_437 parent) {
        PatConfig patConfig = PatConfig.generate();
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder();
        builder.title(patConfig.getTitle()).save(patConfig.getOnSave());
        for (PatCategory category : patConfig.getCategories()) {
            builder.category(YACLBridge.getCategory(category));
        }
        return builder.build().generateScreen(parent);
    }

    private static ConfigCategory getCategory(PatCategory category) {
        ConfigCategory.Builder builder = ConfigCategory.createBuilder();
        builder.name(category.getName());
        class_2561 description = category.getDescription();
        if (description != null) {
            builder.tooltip(new class_2561[]{description});
        }
        for (PatElement element : category.getElements()) {
            if (element instanceof PatGroup) {
                PatGroup group = (PatGroup)element;
                builder.group(YACLBridge.getGroup(group));
                group.getOptions().forEach(option -> {
                    if (option instanceof PatListOption) {
                        PatListOption patListOption = (PatListOption)option;
                        builder.option(YACLBridge.getOption(patListOption));
                    }
                });
                continue;
            }
            if (!(element instanceof AbstractPatOption)) continue;
            AbstractPatOption option2 = (AbstractPatOption)element;
            builder.option(YACLBridge.getOption(option2));
        }
        return builder.build();
    }

    private static OptionGroup getGroup(PatGroup group) {
        OptionGroup.Builder builder = OptionGroup.createBuilder();
        builder.name(group.getName());
        builder.collapsed(group.isCollapsed());
        PatDescription description = group.getDescription();
        if (description != null) {
            builder.description(YACLBridge.getDescription(description));
        }
        for (AbstractPatOption<?> option : group.getOptions()) {
            if (option instanceof PatListOption) continue;
            builder.option(YACLBridge.getOption(option));
        }
        return builder.build();
    }

    private static <T> Option<T> getOption(AbstractPatOption<T> abstractOption) {
        if (abstractOption instanceof PatListOption) {
            PatListOption listOption = (PatListOption)abstractOption;
            return YACLBridge.getListOption(listOption);
        }
        PatOption option = (PatOption)abstractOption;
        Option.Builder builder = Option.createBuilder();
        builder.name(option.getName());
        PatDescription description = option.getDescription();
        if (description != null) {
            builder.description(YACLBridge.getDescription(option.getDescription()));
        }
        builder.binding(option.getDefaultValue(), option.getGetter(), option.getSetter());
        if (option instanceof SliderNumberOption) {
            SliderNumberOption sliderNumberOption = (SliderNumberOption)option;
            YACLBridge.addSliderNumberOption(builder, sliderNumberOption);
        } else if (option instanceof NumberOption) {
            NumberOption numberOption = (NumberOption)option;
            YACLBridge.addNumberOption(builder, numberOption);
        } else if (option instanceof BooleanOption) {
            builder.controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true));
        } else if (option instanceof EnumOption) {
            EnumOption enumOption = (EnumOption)option;
            builder.controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(enumOption.getEnumClass()).formatValue(o -> enumOption.getEnumNameProvider().apply(o)));
        } else {
            throw new IllegalArgumentException("Unsupported Option type: " + String.valueOf(option));
        }
        return builder.build();
    }

    private static <T> void addSliderNumberOption(Option.Builder<T> builder, SliderNumberOption<?> sliderNumberOption) {
        builder.controller(opt -> {
            Class<?> type = sliderNumberOption.getType();
            if (type == Float.class) {
                SliderNumberOption sliderFloatOption = sliderNumberOption;
                return ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)((Float)sliderFloatOption.getMin()), (Number)((Float)sliderFloatOption.getMax()))).step((Number)((Float)sliderFloatOption.getStep()));
            }
            if (type == Long.class) {
                SliderNumberOption sliderLongOption = sliderNumberOption;
                return ((LongSliderControllerBuilder)LongSliderControllerBuilder.create((Option)opt).range((Number)((Long)sliderLongOption.getMin()), (Number)((Long)sliderLongOption.getMax()))).step((Number)((Long)sliderLongOption.getStep()));
            }
            if (type == Double.class) {
                SliderNumberOption sliderDoubleOption = sliderNumberOption;
                return ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)((Double)sliderDoubleOption.getMin()), (Number)((Double)sliderDoubleOption.getMax()))).step((Number)((Double)sliderDoubleOption.getStep()));
            }
            if (type == Integer.class) {
                SliderNumberOption sliderIntegerOption = sliderNumberOption;
                return ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)((Integer)sliderIntegerOption.getMin()), (Number)((Integer)sliderIntegerOption.getMax()))).step((Number)((Integer)sliderIntegerOption.getStep()));
            }
            throw new IllegalArgumentException("Unsupported SliderNumberOption type: " + String.valueOf(type));
        });
    }

    private static <T> void addNumberOption(Option.Builder<T> builder, NumberOption<?> numberOption) {
        builder.controller(opt -> {
            Class<?> type = numberOption.getType();
            if (type == Float.class) {
                NumberOption floatOption = numberOption;
                return FloatFieldControllerBuilder.create((Option)opt).range((Number)((Float)floatOption.getMin()), (Number)((Float)floatOption.getMax()));
            }
            if (type == Long.class) {
                NumberOption longOption = numberOption;
                return LongFieldControllerBuilder.create((Option)opt).range((Number)((Long)longOption.getMin()), (Number)((Long)longOption.getMax()));
            }
            if (type == Double.class) {
                NumberOption doubleOption = numberOption;
                return DoubleFieldControllerBuilder.create((Option)opt).range((Number)((Double)doubleOption.getMin()), (Number)((Double)doubleOption.getMax()));
            }
            if (type == Integer.class) {
                NumberOption integerOption = numberOption;
                return IntegerFieldControllerBuilder.create((Option)opt).range((Number)((Integer)integerOption.getMin()), (Number)((Integer)integerOption.getMax()));
            }
            throw new IllegalArgumentException("Unsupported NumberOption type: " + String.valueOf(type));
        });
    }

    private static <T> ListOption<T> getListOption(PatListOption<T> option) {
        ListOption.Builder builder = ListOption.createBuilder();
        builder.name(option.getName());
        PatDescription description = option.getDescription();
        if (description != null) {
            builder.description(YACLBridge.getDescription(option.getDescription()));
        }
        builder.initial(option.getInitial());
        builder.binding((List)option.getDefaultValue(), option.getGetter(), option.getSetter());
        builder.minimumNumberOfEntries(option.getMinEntries()).maximumNumberOfEntries(option.getMaxEntries());
        Class<?> type = option.getType();
        if (type == String.class) {
            return builder.controller(opt -> StringControllerBuilder.create((Option)opt)).build();
        }
        throw new IllegalArgumentException("Unsupported ListOption type: " + String.valueOf(type));
    }

    private static OptionDescription getDescription(PatDescription description) {
        OptionDescription.Builder builder;
        block8: {
            AbstractPatImage abstractImage;
            block7: {
                builder = OptionDescription.createBuilder();
                builder.text(new class_2561[]{description.getText()});
                abstractImage = description.getImage();
                if (abstractImage == null) {
                    return builder.build();
                }
                if (!(abstractImage instanceof PatImage)) break block7;
                PatImage image = (PatImage)abstractImage;
                switch (image.getType()) {
                    case WEBP: {
                        builder.webpImage(image.getResource());
                        break block8;
                    }
                    case IMAGE: {
                        builder.image(image.getResource(), image.getWidth(), image.getHeight());
                        break block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type for PatImage: " + String.valueOf((Object)image.getType()));
                    }
                }
            }
            if (abstractImage instanceof PatRenderer) {
                final PatRenderer renderer = (PatRenderer)abstractImage;
                builder.customImage(new ImageRenderer(){

                    public int render(class_332 graphics, int x, int y, int renderWidth, float delta) {
                        return renderer.getMethod().render(graphics, x, y, renderWidth, delta);
                    }

                    public void close() {
                    }
                });
            } else {
                throw new IllegalStateException("Value is not image: " + String.valueOf(abstractImage));
            }
        }
        return builder.build();
    }
}

