/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.modmenu.bridge;

import java.util.List;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntSliderBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongSliderBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringListBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.lopymine.patpat.modmenu.PatConfig;
import net.lopymine.patpat.modmenu.common.PatCategory;
import net.lopymine.patpat.modmenu.common.PatDescription;
import net.lopymine.patpat.modmenu.common.PatElement;
import net.lopymine.patpat.modmenu.common.PatGroup;
import net.lopymine.patpat.modmenu.common.option.AbstractPatOption;
import net.lopymine.patpat.modmenu.common.option.BooleanOption;
import net.lopymine.patpat.modmenu.common.option.EnumOption;
import net.lopymine.patpat.modmenu.common.option.NumberOption;
import net.lopymine.patpat.modmenu.common.option.PatListOption;
import net.lopymine.patpat.modmenu.common.option.SliderNumberOption;
import net.lopymine.patpat.utils.ModMenuUtils;
import net.lopymine.patpat.utils.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothConfigBridge {
    public static final Function<Boolean, class_2561> ENABLED_OR_DISABLED_FORMATTER = ModMenuUtils.getEnabledOrDisabledFormatterColored();

    private ClothConfigBridge() {
        throw new IllegalStateException("Bridge class");
    }

    public static class_437 getScreen(@Nullable class_437 parent) {
        PatConfig patConfig = PatConfig.generate();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(patConfig.getTitle()).setSavingRunnable(patConfig.getOnSave());
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        for (PatCategory category : patConfig.getCategories()) {
            ConfigCategory configCategory = builder.getOrCreateCategory(category.getName());
            ClothConfigBridge.addCategory(category, configCategory, entryBuilder);
        }
        return builder.build();
    }

    private static void addCategory(PatCategory category, ConfigCategory configCategory, ConfigEntryBuilder entryBuilder) {
        class_2561 description = category.getDescription();
        if (description != null) {
            configCategory.setDescription(new class_5348[]{description});
        }
        for (PatElement element : category.getElements()) {
            if (element instanceof PatGroup) {
                PatGroup group = (PatGroup)element;
                configCategory.addEntry((AbstractConfigListEntry)ClothConfigBridge.getGroup(group, entryBuilder));
                continue;
            }
            if (!(element instanceof AbstractPatOption)) continue;
            AbstractPatOption option = (AbstractPatOption)element;
            configCategory.addEntry(ClothConfigBridge.getOption(option, entryBuilder));
        }
    }

    private static SubCategoryListEntry getGroup(PatGroup group, ConfigEntryBuilder entryBuilder) {
        SubCategoryBuilder subCategoryBuilder = entryBuilder.startSubCategory(group.getName());
        PatDescription description = group.getDescription();
        if (description != null) {
            subCategoryBuilder.setTooltip(new class_2561[]{description.getText()});
        }
        subCategoryBuilder.setExpanded(!group.isCollapsed());
        for (AbstractPatOption<?> option : group.getOptions()) {
            subCategoryBuilder.add(ClothConfigBridge.getOption(option, entryBuilder));
        }
        return subCategoryBuilder.build();
    }

    private static AbstractConfigListEntry<?> getOption(AbstractPatOption<?> option, ConfigEntryBuilder entryBuilder) {
        if (option instanceof PatListOption) {
            PatListOption listOption = (PatListOption)option;
            return ClothConfigBridge.getListOption(listOption, entryBuilder);
        }
        PatDescription description = option.getDescription();
        if (option instanceof SliderNumberOption) {
            SliderNumberOption sliderNumberOption = (SliderNumberOption)option;
            Class<?> type = sliderNumberOption.getType();
            if (type == Integer.class) {
                SliderNumberOption sliderIntegerOption = sliderNumberOption;
                IntSliderBuilder sliderBuilder = ((IntSliderBuilder)entryBuilder.startIntSlider(option.getName(), ((Integer)sliderIntegerOption.getGetter().get()).intValue(), ((Integer)sliderIntegerOption.getMin()).intValue(), ((Integer)sliderIntegerOption.getMax()).intValue()).setDefaultValue((Object)((Integer)sliderIntegerOption.getDefaultValue()))).setSaveConsumer(sliderIntegerOption.getSetter());
                if (description != null) {
                    sliderBuilder.setTooltip(new class_2561[]{description.getText()});
                }
                return sliderBuilder.build();
            }
            if (type == Long.class) {
                SliderNumberOption sliderLongOption = sliderNumberOption;
                LongSliderBuilder sliderBuilder = ((LongSliderBuilder)entryBuilder.startLongSlider(option.getName(), ((Long)sliderLongOption.getGetter().get()).longValue(), ((Long)sliderLongOption.getMin()).longValue(), ((Long)sliderLongOption.getMax()).longValue()).setDefaultValue((Object)((Long)sliderLongOption.getDefaultValue()))).setSaveConsumer(sliderLongOption.getSetter());
                if (description != null) {
                    sliderBuilder.setTooltip(new class_2561[]{description.getText()});
                }
                return sliderBuilder.build();
            }
            if (type == Float.class) {
                SliderNumberOption floatNumberOption = sliderNumberOption;
                FloatFieldBuilder fieldBuilder = ((FloatFieldBuilder)((FloatFieldBuilder)((FloatFieldBuilder)entryBuilder.startFloatField(option.getName(), ((Float)floatNumberOption.getGetter().get()).floatValue()).setMin((Object)((Float)floatNumberOption.getMin()))).setMax((Object)((Float)floatNumberOption.getMax()))).setDefaultValue((Object)((Float)floatNumberOption.getDefaultValue()))).setSaveConsumer(floatNumberOption.getSetter());
                if (description != null) {
                    fieldBuilder.setTooltip(new class_2561[]{description.getText()});
                }
                return fieldBuilder.build();
            }
            throw new IllegalArgumentException("Unsupported SliderNumberOption type: " + String.valueOf(type));
        }
        if (option instanceof NumberOption) {
            NumberOption numberOption = (NumberOption)option;
            Class<?> type = numberOption.getType();
            if (type == Float.class) {
                NumberOption floatNumberOption = numberOption;
                FloatFieldBuilder fieldBuilder = ((FloatFieldBuilder)((FloatFieldBuilder)((FloatFieldBuilder)entryBuilder.startFloatField(option.getName(), ((Float)floatNumberOption.getGetter().get()).floatValue()).setMin((Object)((Float)floatNumberOption.getMin()))).setMax((Object)((Float)floatNumberOption.getMax()))).setDefaultValue((Object)((Float)floatNumberOption.getDefaultValue()))).setSaveConsumer(floatNumberOption.getSetter());
                if (description != null) {
                    fieldBuilder.setTooltip(new class_2561[]{description.getText()});
                }
                return fieldBuilder.build();
            }
            if (type == Double.class) {
                NumberOption doubleNumberOption = numberOption;
                DoubleFieldBuilder fieldBuilder = ((DoubleFieldBuilder)((DoubleFieldBuilder)((DoubleFieldBuilder)entryBuilder.startDoubleField(option.getName(), ((Double)doubleNumberOption.getGetter().get()).doubleValue()).setMin((Object)((Double)doubleNumberOption.getMin()))).setMax((Object)((Double)doubleNumberOption.getMax()))).setDefaultValue((Object)((Double)doubleNumberOption.getDefaultValue()))).setSaveConsumer(doubleNumberOption.getSetter());
                if (description != null) {
                    fieldBuilder.setTooltip(new class_2561[]{description.getText()});
                }
                return fieldBuilder.build();
            }
            if (type == Integer.class) {
                NumberOption integerNumberOption = numberOption;
                IntFieldBuilder fieldBuilder = ((IntFieldBuilder)((IntFieldBuilder)((IntFieldBuilder)entryBuilder.startIntField(option.getName(), ((Integer)integerNumberOption.getGetter().get()).intValue()).setMin((Object)((Integer)integerNumberOption.getMin()))).setMax((Object)((Integer)integerNumberOption.getMax()))).setDefaultValue((Object)((Integer)integerNumberOption.getDefaultValue()))).setSaveConsumer(integerNumberOption.getSetter());
                if (description != null) {
                    fieldBuilder.setTooltip(new class_2561[]{description.getText()});
                }
                return fieldBuilder.build();
            }
            if (type == Long.class) {
                NumberOption longNumberOption = numberOption;
                LongFieldBuilder fieldBuilder = ((LongFieldBuilder)((LongFieldBuilder)((LongFieldBuilder)entryBuilder.startLongField(option.getName(), ((Long)longNumberOption.getGetter().get()).longValue()).setMin((Object)((Long)longNumberOption.getMin()))).setMax((Object)((Long)longNumberOption.getMax()))).setDefaultValue((Object)((Long)longNumberOption.getDefaultValue()))).setSaveConsumer(longNumberOption.getSetter());
                if (description != null) {
                    fieldBuilder.setTooltip(new class_2561[]{description.getText()});
                }
                return fieldBuilder.build();
            }
            throw new IllegalArgumentException("Unsupported NumberOption type: " + String.valueOf(type));
        }
        if (option instanceof BooleanOption) {
            BooleanOption booleanOption = (BooleanOption)option;
            BooleanToggleBuilder toggleBuilder = ((BooleanToggleBuilder)entryBuilder.startBooleanToggle(option.getName(), ((Boolean)booleanOption.getGetter().get()).booleanValue()).setDefaultValue((Object)((Boolean)booleanOption.getDefaultValue()))).setYesNoTextSupplier(ENABLED_OR_DISABLED_FORMATTER).setSaveConsumer(booleanOption.getSetter());
            if (description != null) {
                toggleBuilder.setTooltip(new class_2561[]{description.getText()});
            }
            return toggleBuilder.build();
        }
        if (option instanceof EnumOption) {
            EnumOption enumOption = (EnumOption)option;
            return ClothConfigBridge.getEnumListEntry(option, entryBuilder, enumOption, description);
        }
        throw new IllegalStateException("Unexpected PatOption: " + String.valueOf(option));
    }

    @NotNull
    private static <T extends Enum<T>> EnumListEntry<T> getEnumListEntry(AbstractPatOption<?> option, ConfigEntryBuilder entryBuilder, EnumOption<T> enumOption, PatDescription description) {
        EnumSelectorBuilder enumBuilder = entryBuilder.startEnumSelector(option.getName(), enumOption.getEnumClass(), (Enum)enumOption.getGetter().get()).setEnumNameProvider(e -> {
            if (enumOption.getEnumClass().isInstance(e)) {
                class_2561 apply = enumOption.getEnumNameProvider().apply((Enum)e);
                return apply;
            }
            return TextUtils.of("Unknown Enum Value");
        }).setDefaultValue((Enum)enumOption.getDefaultValue()).setSaveConsumer(enumOption.getSetter());
        if (description != null) {
            enumBuilder.setTooltip(new class_2561[]{description.getText()});
        }
        return enumBuilder.build();
    }

    private static AbstractConfigListEntry<?> getListOption(PatListOption<?> option, ConfigEntryBuilder entryBuilder) {
        PatDescription description = option.getDescription();
        Class<?> type = option.getType();
        if (type == String.class) {
            PatListOption<?> stringOption = option;
            StringListBuilder stringList = entryBuilder.startStrList(option.getName(), (List)stringOption.getGetter().get()).setDefaultValue((List)stringOption.getDefaultValue()).setSaveConsumer(stringOption.getSetter());
            if (description != null) {
                stringList.setTooltip(new class_2561[]{description.getText()});
            }
            return stringList.build();
        }
        throw new IllegalStateException("Unexpected PatListOption: " + String.valueOf(option));
    }
}

