/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.server.packet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.lopymine.patpat.PatLogger;
import net.lopymine.patpat.PatPat;
import net.lopymine.patpat.common.Version;
import net.lopymine.patpat.packet.PatPacket;
import net.lopymine.patpat.packet.c2s.HelloPatPatServerC2SPacket;
import net.lopymine.patpat.packet.c2s.PatEntityC2SPacket;
import net.lopymine.patpat.packet.c2s.PatEntityC2SPacketV2;
import net.lopymine.patpat.packet.s2c.PatEntityS2CPacket;
import net.lopymine.patpat.packet.s2c.PatEntityS2CPacketV2;
import net.lopymine.patpat.server.packet.PatPatServerNetworkManager;
import net.lopymine.patpat.server.ratelimit.PatPatServerListManager;
import net.lopymine.patpat.server.ratelimit.PatPatServerRateLimitManager;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_638;

public class PatPatServerPacketManager {
    public static final PatLogger LOGGER = PatPat.LOGGER.extend("PacketManager");
    public static final Map<UUID, Version> PLAYER_VERSIONS = new HashMap<UUID, Version>();
    private static final List<Predicate<class_3222>> PACKET_TESTS = new ArrayList<Predicate<class_3222>>();

    private PatPatServerPacketManager() {
        throw new IllegalStateException("Manager class");
    }

    public static void register() {
        PACKET_TESTS.clear();
        PACKET_TESTS.add(PatPatServerListManager::canPat);
        PACKET_TESTS.add(PatPatServerRateLimitManager::canPat);
        PatPatServerPacketManager.registerPackets();
        PatPatServerNetworkManager.registerReceiver(PatEntityC2SPacket.TYPE, PatPatServerPacketManager::handlePacket);
        PatPatServerNetworkManager.registerReceiver(PatEntityC2SPacketV2.TYPE, PatPatServerPacketManager::handlePacket);
        PatPatServerNetworkManager.registerReceiver(HelloPatPatServerC2SPacket.TYPE, PatPatServerPacketManager::handleHelloPacket);
    }

    private static void handleHelloPacket(class_3222 sender, HelloPatPatServerC2SPacket packet) {
        LOGGER.debug("Received hello packet from {}!", sender.method_5477().getString());
        Version version = packet.getVersion();
        if (version.isInvalid()) {
            LOGGER.error("Received invalid client version in hello packet from {}!", sender.method_5477().getString());
            PLAYER_VERSIONS.put(sender.method_5667(), Version.PACKET_V2_VERSION);
            return;
        }
        LOGGER.debug("Player PatPat Version: {}", version);
        PLAYER_VERSIONS.put(sender.method_5667(), version);
    }

    public static void handlePacket(class_3222 sender, PatPacket<class_3218, ?> packet) {
        LOGGER.debug("Received pat packet from {}", sender.method_5477().getString());
        for (Predicate<class_3222> packetTest : PACKET_TESTS) {
            if (packetTest.test(sender)) continue;
            return;
        }
        class_3218 serverWorld = (class_3218)sender.field_6002;
        class_1297 entity = packet.getPattedEntity(serverWorld);
        if (!(entity instanceof class_1309)) {
            return;
        }
        if (entity.method_5767()) {
            LOGGER.warn("Received packet from client, {} patted {}, but patted entity is invisible! This shouldn't happens because it should be checked at the client-side! Ignoring packet", sender.method_5477(), entity.method_5477());
            return;
        }
        class_1923 chunkPos = entity.method_31476();
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_1923)chunkPos)) {
            if (player.equals((Object)sender)) continue;
            LOGGER.debug("Sending pat packet to {} from {}", player.method_5477().getString(), sender.method_5477().getString());
            PatPatServerNetworkManager.sendPacketToPlayer(player, PatPatServerPacketManager.getPatPacket(entity, (class_1297)player));
        }
    }

    private static void registerPackets() {
    }

    public static PatPacket<class_638, ?> getPatPacket(class_1297 pattedEntity, class_1297 whoPattedEntity) {
        if (PLAYER_VERSIONS.get(whoPattedEntity.method_5667()).isGreaterOrEqualThan(Version.PACKET_V2_VERSION)) {
            LOGGER.debug("Getting pat packet... Using V2 version", new Object[0]);
            return new PatEntityS2CPacketV2(pattedEntity, whoPattedEntity);
        }
        LOGGER.debug("Getting pat packet... Using V1 version", new Object[0]);
        return new PatEntityS2CPacket(pattedEntity, whoPattedEntity);
    }
}

