/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.misc.javaprogargoverride;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public abstract class Util {
    public static ArrayList<String> separateArgs(String src, Collection<Character> delimiters, Character escapeChar, Map<Character, Boolean> quotes) throws IllegalArgumentException {
        if (delimiters.isEmpty()) {
            throw new IllegalArgumentException("at least one delimiter required");
        }
        ArrayList<String> RES = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        Character quote = null;
        int index = 0;
        int mostRecentQuoteIndex = 0;
        boolean delimited = true;
        for (char i : src.toCharArray()) {
            if (escaped) {
                sb.append(i);
                escaped = false;
            } else if (escapeChar != null && i == escapeChar.charValue()) {
                if (quote == null || quotes.get(quote).booleanValue()) {
                    escaped = true;
                    delimited = false;
                } else {
                    sb.append(i);
                }
            } else if (quote == null && quotes.containsKey(Character.valueOf(i))) {
                quote = Character.valueOf(i);
                mostRecentQuoteIndex = index;
                delimited = false;
            } else if (quote != null && i == quote.charValue()) {
                quote = null;
            } else if (delimiters.contains(Character.valueOf(i)) && quote == null) {
                if (!delimited) {
                    RES.add(sb.toString());
                    sb = new StringBuilder();
                }
                delimited = true;
            } else {
                sb.append(i);
                delimited = false;
            }
            ++index;
        }
        if (quote != null) {
            throw new IllegalArgumentException("quote at index " + mostRecentQuoteIndex + " not closed");
        }
        if (escapeChar != null && src.charAt(src.length() - 1) == escapeChar.charValue()) {
            throw new IllegalArgumentException("unexpected escape at the end");
        }
        if (!delimited) {
            RES.add(sb.toString());
        }
        return RES;
    }
}

