/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.client.renderers.layers;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class ChaosElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("enigmaticaddons", "textures/item/3d/chaos_elytra.png");
    private final ElytraModel<T> elytraModel;

    public ChaosElytraLayer(RenderLayerParent<T, M> layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.elytraModel = new ElytraModel(modelSet.m_171103_(ModelLayers.f_171141_));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = SuperAddonHandler.getChaosElytra(livingEntity);
        if (SuperpositionHandler.hasCurio(livingEntity, (Item)EnigmaticAddonItems.CHAOS_ELYTRA)) {
            AtomicBoolean flag = new AtomicBoolean(false);
            CuriosApi.getCuriosInventory(livingEntity).ifPresent(handler -> handler.findFirstCurio(itemStack -> itemStack.m_150930_((Item)EnigmaticAddonItems.CHAOS_ELYTRA)).ifPresent(curio -> {
                if (!curio.slotContext().visible()) {
                    flag.set(true);
                }
            }));
            if (flag.get()) {
                return;
            }
        }
        if (stack != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 0.125);
            this.m_117386_().m_102624_(this.elytraModel);
            this.elytraModel.m_6973_(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)TEXTURE), (boolean)false, (boolean)stack.m_41793_());
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            float alpha = 1.0f;
            this.elytraModel.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, alpha);
            poseStack.m_85849_();
        }
    }
}

