/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.client.screens;

import auviotre.enigmatic.addon.contents.gui.ArtificialFlowerMenu;
import auviotre.enigmatic.addon.contents.items.ArtificialFlower;
import auviotre.enigmatic.addon.handlers.CompatHandler;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ArtificialFlowerScreen
extends AbstractContainerScreen<ArtificialFlowerMenu> {
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.##"), format -> format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final ResourceLocation INVENTORY = new ResourceLocation("enigmaticaddons", "textures/gui/artificial_flower_gui.png");
    private final MobEffect[] effectsLegacy = new MobEffect[]{null, null};
    private final TextureAtlasSprite[] effectSpritesLegacy = new TextureAtlasSprite[]{null, null};

    public ArtificialFlowerScreen(ArtificialFlowerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    public static Component getComponent(Pair<Attribute, AttributeModifier> attribute) {
        MutableComponent name = Component.m_237115_((String)((Attribute)attribute.getFirst()).m_22087_());
        AttributeModifier attributemodifier = (AttributeModifier)attribute.getSecond();
        double amount = attributemodifier.m_22218_();
        if (attributemodifier.m_22217_() != AttributeModifier.Operation.ADDITION) {
            amount *= 100.0;
        }
        if (amount > 0.0) {
            return Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(amount), name}).m_130940_(ChatFormatting.GREEN);
        }
        if (amount < 0.0) {
            return Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(amount *= -1.0), name}).m_130940_(ChatFormatting.RED);
        }
        return Component.m_237119_();
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        double dy;
        double dx;
        int id;
        int x0 = (this.f_96543_ - this.f_97726_) / 2;
        int y0 = (this.f_96544_ - this.f_97727_) / 2;
        for (id = 0; id < 3; ++id) {
            dx = mouseX - (double)(x0 + 53);
            dy = mouseY - (double)(y0 + 14 + 20 * id);
            if (!(dx >= 0.0) || !(dy >= 0.0) || !(dx < 10.0) || !(dy < 10.0) || !((ArtificialFlowerMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, id)) continue;
            this.f_96541_.f_91072_.m_105208_(((ArtificialFlowerMenu)this.f_97732_).f_38840_, id);
            return true;
        }
        if ((double)x0 + 16.0 <= mouseX && mouseX <= 33.0 + (double)x0 && (double)y0 + 49.0 <= mouseY && mouseY <= 55.0 + (double)y0 && ((ArtificialFlowerMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, 3)) {
            this.f_96541_.f_91072_.m_105208_(((ArtificialFlowerMenu)this.f_97732_).f_38840_, 3);
            return true;
        }
        for (id = 4; id < 6; ++id) {
            dx = mouseX - (double)(x0 + 139);
            dy = mouseY - (double)(y0 + 16 + 26 * (id - 4));
            if (!(dx >= 0.0) || !(dy >= 0.0) || !(dx < 20.0) || !(dy < 20.0) || !((ArtificialFlowerMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, id)) continue;
            this.f_96541_.f_91072_.m_105208_(((ArtificialFlowerMenu)this.f_97732_).f_38840_, id);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        int id;
        super.m_280072_(graphics, mouseX, mouseY);
        int x0 = (this.f_96543_ - this.f_97726_) / 2;
        int y0 = (this.f_96544_ - this.f_97727_) / 2;
        ItemStack flower = ArtificialFlower.Helper.getFlowerStack(((ArtificialFlowerMenu)this.f_97732_).player, false);
        for (id = 0; id < 3; ++id) {
            int dx = mouseX - (x0 + 53);
            int dy = mouseY - (y0 + 14 + 20 * id);
            if (!((double)dx >= 0.0) || !((double)dy >= 0.0) || !((double)dx < 10.0) || !((double)dy < 10.0)) continue;
            Pair<Attribute, AttributeModifier> attribute = ArtificialFlower.Helper.getAttribute(flower, id + 1);
            if (attribute != null) {
                graphics.m_280218_(INVENTORY, x0 + 54, y0 + id * 20 + 15, 176, 8, 8, 8);
                ArrayList<Component> components = new ArrayList<Component>();
                components.add(ArtificialFlowerScreen.getComponent(attribute));
                if (ModList.get().isLoaded("jade") && attribute != null) {
                    new CompatHandler().addModNameFromJade(components, ForgeRegistries.ATTRIBUTES.getKey((Object)((Attribute)attribute.getFirst())));
                }
                graphics.m_280666_(this.f_96547_, components, mouseX, mouseY + 5);
                continue;
            }
            graphics.m_280218_(INVENTORY, x0 + 54, y0 + id * 20 + 15, 176, 16, 8, 8);
        }
        if ((double)x0 + 16.0 <= (double)mouseX && (double)mouseX <= 33.0 + (double)x0 && (double)y0 + 49.0 <= (double)mouseY && (double)mouseY <= 55.0 + (double)y0) {
            int cost = ((ArtificialFlowerMenu)this.f_97732_).costMode == 0 ? 2 : (((ArtificialFlowerMenu)this.f_97732_).costMode == 1 ? 4 : 8);
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237110_((String)"gui.enigmaticaddons.artificial_flower_cost", (Object[])new Object[]{cost}).m_130940_(ChatFormatting.GOLD), mouseX, mouseY + 5);
        }
        for (id = 0; id < 2; ++id) {
            MutableComponent name;
            int suffix;
            double dx = mouseX - (x0 + 139);
            double dy = mouseY - (y0 + 16 + 26 * id);
            if (!(dx >= 0.0) || !(dy >= 0.0) || !(dx < 20.0) || !(dy < 20.0)) continue;
            MobEffect effect = ArtificialFlower.Helper.getEffect(flower, id);
            if (effect == null) {
                suffix = 0;
                name = Component.m_237115_((String)"tooltip.enigmaticaddons.artificialFlowerNone");
            } else {
                suffix = ((ArtificialFlowerMenu)this.f_97732_).hasRing() ? 1 : 0;
                name = Component.m_237115_((String)effect.m_19481_()).m_130940_(effect.m_19486_() ? ChatFormatting.GREEN : ChatFormatting.RED);
            }
            MutableComponent immunity = Component.m_237110_((String)"gui.enigmaticaddons.artificial_flower_immunity", (Object[])new Object[]{name});
            MutableComponent providing = Component.m_237110_((String)("gui.enigmaticaddons.artificial_flower_provide" + suffix), (Object[])new Object[]{name});
            ArrayList<Component> components = new ArrayList<Component>();
            components.add((Component)(id == 0 ? providing : immunity));
            if (ModList.get().isLoaded("jade") && effect != null) {
                new CompatHandler().addModNameFromJade(components, ForgeRegistries.MOB_EFFECTS.getKey((Object)effect));
            }
            graphics.m_280666_(this.f_96547_, components, mouseX, mouseY + 5);
        }
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int id;
        int x0 = (this.f_96543_ - this.f_97726_) / 2;
        int y0 = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(INVENTORY, x0, y0, 0, 0, this.f_97726_, this.f_97727_);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.enigmaticaddons.artificial_flower_attribute").m_130940_(ChatFormatting.WHITE), x0 + 10, y0 + 5, 10);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.enigmaticaddons.artificial_flower_effect").m_130940_(ChatFormatting.WHITE), x0 + 100, y0 + 5, 10);
        if (((ArtificialFlowerMenu)this.f_97732_).valid(0)) {
            graphics.m_280218_(INVENTORY, x0 + 36, y0 + 15, 192, 0, 16, 48);
        }
        if (((ArtificialFlowerMenu)this.f_97732_).valid(1)) {
            graphics.m_280218_(INVENTORY, x0 + 112, y0 + 22, 176, 48, 25, 8);
            graphics.m_280218_(INVENTORY, x0 + 112, y0 + 49, 176, 56, 25, 8);
        }
        if (((ArtificialFlowerMenu)this.f_97732_).hasRing()) {
            graphics.m_280218_(INVENTORY, x0 + 68, y0 + 19, 176, 64, 37, 32);
        }
        graphics.m_280218_(INVENTORY, x0 + 17 + ((ArtificialFlowerMenu)this.f_97732_).costMode * 6, y0 + 49, 176, 32, 4, 7);
        ItemStack flower = ArtificialFlower.Helper.getFlowerStack(((ArtificialFlowerMenu)this.f_97732_).player, true);
        int dy = 15;
        for (id = 1; id <= 3; ++id) {
            if (ArtificialFlower.Helper.getAttribute(flower, id) != null) {
                graphics.m_280218_(INVENTORY, x0 + 54, y0 + dy, 176, 0, 8, 8);
            }
            dy += 20;
        }
        dy = 17;
        for (id = 0; id < 2; ++id) {
            if (ArtificialFlower.Helper.getEffect(flower, id) != null) {
                if (this.effectsLegacy[id] == null || this.effectsLegacy[id] != ArtificialFlower.Helper.getEffect(flower, id)) {
                    this.effectsLegacy[id] = ArtificialFlower.Helper.getEffect(flower, id);
                    this.effectSpritesLegacy[id] = Minecraft.m_91087_().m_91306_().m_118732_(this.effectsLegacy[id]);
                }
                graphics.m_280159_(x0 + 140, y0 + dy, 0, 18, 18, this.effectSpritesLegacy[id]);
            }
            dy += 26;
        }
    }
}

