/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.entities;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEntities;
import auviotre.enigmatic.addon.registries.EnigmaticAddonParticles;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class AbyssProjectile
extends Projectile {
    private static final EntityDataAccessor<Float> ID_DAMAGE = SynchedEntityData.m_135353_(AbyssProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int fireTime = 0;
    @Nullable
    private UUID targetUUID;
    @Nullable
    private Entity cachedTarget;

    public AbyssProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.m_20242_(true);
    }

    public AbyssProjectile(Level world, LivingEntity owner) {
        this(EnigmaticAddonEntities.ABYSS_PROJECTILE, world);
        this.m_5602_((Entity)owner);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void setDamage(float v) {
        this.f_19804_.m_135381_(ID_DAMAGE, (Object)Float.valueOf(v));
    }

    public void checkTarget() {
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        List livingEntities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(24.0), LivingEntity::m_6084_);
        for (LivingEntity entity : livingEntities) {
            if (entity instanceof ArmorStand || entity == null || owner == entity || entity.m_7307_(owner)) continue;
            this.setTarget((Entity)entity);
            break;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (this.fireTime > 200 || owner == null) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            Vec3 movement = this.m_20184_();
            Entity cachedTarget = this.getCachedTarget();
            if (cachedTarget != null && cachedTarget.m_6084_()) {
                Vec3 target = new Vec3(cachedTarget.m_20185_(), cachedTarget.m_20227_(0.5), cachedTarget.m_20189_());
                Vec3 delta = target.m_82546_(this.m_20182_());
                if (delta.m_82553_() < 24.0) {
                    delta = delta.m_82541_().m_82490_(0.56).m_82549_(movement);
                    movement = delta.m_82490_((double)0.9f);
                } else {
                    this.checkTarget();
                }
                this.m_20256_(movement);
                double d4 = movement.m_165924_();
                this.m_146922_((float)(Mth.m_14136_((double)(-movement.f_82479_), (double)(-movement.f_82481_)) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)movement.f_82480_, (double)d4) * 57.2957763671875));
            } else {
                this.checkTarget();
            }
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
            this.m_6034_(this.m_20185_() + movement.f_82479_, this.m_20186_() + movement.f_82480_, this.m_20189_() + movement.f_82481_);
            ++this.fireTime;
        } else {
            Vec3 movement = this.m_20184_();
            for (int i = 1; i < 3; ++i) {
                double x = this.m_20208_(0.5) - movement.f_82479_ * (double)i / 3.0;
                double y = this.m_20187_() - movement.f_82480_ * (double)i / 3.0;
                double z = this.m_20262_(0.5) - movement.f_82481_ * (double)i / 3.0;
                this.m_9236_().m_7106_((ParticleOptions)EnigmaticAddonParticles.ABYSS_CHAOS, x, y, z, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    protected boolean m_5603_(Entity entity) {
        return !this.m_150171_(entity) && super.m_5603_(entity);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Entity target = hitResult.m_82443_();
            if (target == this.m_19749_()) {
                return;
            }
            int level = target.getPersistentData().m_128451_("AnnihilationPoint");
            float damage = ((Float)this.f_19804_.m_135370_(ID_DAMAGE)).floatValue() * 0.25f;
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                damage += living.m_21233_() * 0.02f * (float)level;
            }
            target.m_6469_(SuperAddonHandler.damageSource(target, EnigmaticAddonDamageTypes.ABYSS, (Entity)this, this.m_19749_()), damage);
            target.f_19802_ = 0;
            Vec3 mv = this.m_20184_().m_82490_(0.5);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + mv.f_82479_, this.m_20186_() + mv.f_82480_, this.m_20189_() + mv.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)EnigmaticAddonParticles.ABYSS_CHAOS, this.m_20185_(), this.m_20186_(), this.m_20189_(), 12, 0.5, 0.5, 0.5, 0.02);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 12, 0.5, 0.5, 0.5, 0.02);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
        }
    }

    public void setTarget(@Nullable Entity entity) {
        if (entity != null) {
            this.targetUUID = entity.m_20148_();
            this.cachedTarget = entity;
        }
    }

    @Nullable
    public Entity getCachedTarget() {
        Level level;
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return this.cachedTarget;
        }
        if (this.targetUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.cachedTarget = server.m_8791_(this.targetUUID);
            return this.cachedTarget;
        }
        return null;
    }

    public void m_7380_(CompoundTag tag) {
        if (this.targetUUID != null) {
            tag.m_128362_("TargetUUID", this.targetUUID);
        }
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("TargetUUID")) {
            this.targetUUID = tag.m_128342_("TargetUUID");
            this.cachedTarget = null;
        }
    }
}

