/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.entities;

import auviotre.enigmatic.addon.contents.entities.AbstractSpear;
import auviotre.enigmatic.addon.contents.items.EvilDagger;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEntities;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownEvilDagger
extends AbstractSpear {
    public int inGroundTick;
    private int curseAmount = 0;

    public ThrownEvilDagger(EntityType<? extends ThrownEvilDagger> type, Level world) {
        super(type, world, (Item)EnigmaticAddonItems.EVIL_DAGGER);
        this.m_36781_(this.m_36789_() / 2.0);
    }

    public ThrownEvilDagger(LivingEntity entity, Level world) {
        super(EnigmaticAddonEntities.EVIL_DAGGER, entity, world, (Item)EnigmaticAddonItems.EVIL_DAGGER);
        this.m_36781_(this.m_36789_() / 2.0);
    }

    public ThrownEvilDagger(Level world, double x, double y, double z) {
        super(EnigmaticAddonEntities.EVIL_DAGGER, x, y, z, world, (Item)EnigmaticAddonItems.EVIL_DAGGER);
        this.m_36781_(this.m_36789_() / 2.0);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        Entity entity = hitResult.m_82443_();
        if (entity == this.m_19749_()) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity owner;
            Entity entity2;
            LivingEntity living = (LivingEntity)entity;
            if (!living.m_9236_().f_46443_ && (this.m_19749_() == null || (entity2 = this.m_19749_()) instanceof LivingEntity && (owner = (LivingEntity)entity2).m_6779_(living))) {
                int percent = (int)(living.m_21223_() * 100.0f / living.m_21233_());
                int threshold = living.getPersistentData().m_128451_("EvilCurseThreshold");
                threshold = threshold == 0 ? percent - EvilDagger.curseDamageRatio.getValue().asPercentage() - this.curseAmount : threshold - 1 - this.curseAmount / 2;
                living.getPersistentData().m_128405_("EvilCurseThreshold", Math.max(threshold, 1));
                living.f_19802_ = 0;
            }
        }
    }

    public void setCurseAmount(int curseAmount) {
        this.curseAmount = curseAmount;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            Vec3 vec3 = this.m_20184_();
            double dx = vec3.f_82479_;
            double dy = vec3.f_82480_;
            double dz = vec3.f_82481_;
            double length = vec3.m_82553_() * 1.2;
            int i = 0;
            while ((double)i < length) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20208_(0.0) + dx * (double)i / length, this.m_20187_() + dy * (double)i / length, this.m_20262_(0.0) + dz * (double)i / length, -dx * 0.1, -dy * 0.1, -dz * 0.1);
                ++i;
            }
        }
        if (this.f_36703_) {
            ++this.inGroundTick;
        } else {
            this.m_20256_(this.m_20184_().m_82490_(1.1));
        }
        if (this.f_19797_ > 20 && this.m_20068_()) {
            this.m_20242_(false);
        }
        if (this.inGroundTick == 2 || this.f_19797_ == 36) {
            for (int counter = 0; counter < 16 && this.m_9236_().f_46443_; ++counter) {
                double theta = Math.random() * 2.0 * Math.PI;
                double phi = (Math.random() - 0.5) * Math.PI;
                double dx = Math.cos(theta) * Math.cos(phi) * 0.08;
                double dy = Math.sin(phi) * 0.08;
                double dz = Math.sin(theta) * Math.cos(phi) * 0.08;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_(), this.m_20186_(), this.m_20189_(), dx, dy, dz);
            }
        } else if (this.inGroundTick > 2 || this.f_19797_ > 36) {
            this.m_146870_();
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }
}

