/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.entities.goal;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class CrossbowBlazeAttackGoal<T extends Monster & CrossbowAttackMob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public CrossbowBlazeAttackGoal(T mob, double modifier, float radius) {
        this.mob = mob;
        this.speedModifier = modifier;
        this.attackRadiusSqr = radius * radius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack stack) {
        ListTag listtag;
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("ChargedProjectiles", 9) && (listtag = compoundtag.m_128437_("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag tag = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)tag));
            }
        }
        return list;
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingCrossbow() && SuperAddonHandler.isCurseBoosted(this.mob);
    }

    private boolean isHoldingCrossbow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((CrossbowAttackMob)this.mob).m_6136_(false);
            CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            boolean flag2;
            boolean seen;
            boolean sighted = this.mob.m_21574_().m_148306_((Entity)target);
            boolean bl = seen = this.seeTime > 0;
            if (sighted != seen) {
                this.seeTime = 0;
            }
            this.seeTime = sighted ? ++this.seeTime : --this.seeTime;
            double distance = this.mob.m_20280_((Entity)target);
            boolean bl2 = flag2 = (distance > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.mob.m_21573_().m_5624_((Entity)target, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
                }
            } else {
                this.updatePathDelay = 0;
                this.mob.m_21573_().m_26573_();
            }
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED) {
                if (!flag2) {
                    this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((CrossbowAttackMob)this.mob).m_6136_(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                if (!this.mob.m_6117_()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if (this.mob.m_21252_() >= CrossbowItem.m_40939_((ItemStack)this.mob.m_21211_())) {
                    this.mob.m_21253_();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 5 + this.mob.m_217043_().m_188503_(15);
                    ((CrossbowAttackMob)this.mob).m_6136_(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                if (--this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && sighted) {
                if (this.mob.m_217043_().m_188503_(5) == 0) {
                    this.attackDelay = 10 + this.mob.m_217043_().m_188503_(4);
                    this.crossbowState = CrossbowState.CHARGED;
                    this.preformFakeAttack(target);
                } else {
                    ItemStack itemInHand = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    this.crossbowState = CrossbowState.UNCHARGED;
                    CrossbowItem.m_40884_((ItemStack)itemInHand, (boolean)false);
                    if (this.mob.m_217043_().m_188503_(6) == 0) {
                        this.mob.m_21008_(InteractionHand.OFF_HAND, this.getFirework());
                    }
                    ((RangedAttackMob)this.mob).m_6504_(target, 1.0f);
                }
            }
        }
    }

    private ItemStack getFirework() {
        ItemStack firework = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag tag = firework.m_41698_("Fireworks");
        ListTag listTag = new ListTag();
        ItemStack star = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag explosion = star.m_41698_("Explosion");
        explosion.m_128344_("Type", (byte)FireworkRocketItem.Shape.BURST.m_41236_());
        explosion.m_128379_("Flicker", true);
        ArrayList colorList = Lists.newArrayList();
        List<Item> dyes = List.of(Items.f_42498_, Items.f_42535_, Items.f_42490_, Items.f_42491_, Items.f_42495_);
        for (Item dye : dyes) {
            colorList.add(((DyeItem)dye).m_41089_().m_41070_());
        }
        explosion.m_128408_("Colors", (List)colorList);
        CompoundTag starTag = star.m_41737_("Explosion");
        for (int i = 0; i < 2; ++i) {
            listTag.add((Object)starTag);
        }
        tag.m_128344_("Flight", (byte)1);
        tag.m_128365_("Explosions", (Tag)listTag);
        return firework;
    }

    private void preformFakeAttack(LivingEntity target) {
        Arrow projectile;
        InteractionHand hand = ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem);
        List<ItemStack> chargedProjectiles = CrossbowBlazeAttackGoal.getChargedProjectiles(this.mob.m_21120_(hand));
        if (chargedProjectiles.isEmpty()) {
            return;
        }
        ItemStack itemStack = chargedProjectiles.get(0);
        if (itemStack.m_150930_(Items.f_42688_)) {
            projectile = new FireworkRocketEntity(this.mob.m_9236_(), itemStack, this.mob, this.mob.m_20185_(), this.mob.m_20188_() - (double)0.15f, this.mob.m_20189_(), true);
        } else {
            projectile = new Arrow(this.mob.m_9236_(), this.mob);
            projectile.m_36878_(itemStack);
            projectile.m_36767_((byte)1);
        }
        double dx = target.m_20185_() - this.mob.m_20185_();
        double dy = target.m_20227_(0.3333) - projectile.m_20186_();
        double dz = target.m_20189_() - this.mob.m_20189_();
        double d3 = Math.sqrt(dx * dx + dz * dz);
        projectile.m_6686_(dx, dy + d3 * 0.2, dz, 1.8f, (float)(18 - this.mob.m_9236_().m_46791_().m_19028_() * 4));
        this.mob.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (this.mob.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.mob.m_9236_().m_7967_((Entity)projectile);
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

