/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.contents.entities.DragonBreathArrow;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICreativeTabMember;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DragonBow
extends BowItem
implements Vanishable,
ICreativeTabMember {
    public static Omniconfig.PerhapsParameter ownerResistance;
    public static Omniconfig.IntParameter maxPotionAmount;

    public DragonBow() {
        super(ItemBase.getDefaultProperties().m_41497_(Rarity.EPIC).m_41487_(1).m_41503_(1024));
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("DragonBreathBow");
        ownerResistance = builder.comment("The Damage Resistance to your own dragon breath damage. Defined as percentage.").max(100.0).getPerhaps("OwnerResistance", 60);
        maxPotionAmount = builder.comment("The max amount of potion effect you can apply on the arrow.").max(10.0).min(1.0).getInt("MaxPotionAmount", 4);
        builder.popPrefix();
    }

    public static float m_40661_(int tick) {
        float f = (float)tick / 32.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    public static void resetEffect(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128473_("CustomPotionEffects");
    }

    public static void addEffect(ItemStack stack, MobEffectInstance effect) {
        CompoundTag compoundTag = stack.m_41784_();
        ArrayList<MobEffectInstance> effects = PotionUtils.m_43573_((CompoundTag)compoundTag);
        int length = effects.toArray().length;
        if (length < maxPotionAmount.getValue()) {
            effects.add(effect);
        } else {
            ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
            for (int i = 1; i < length; ++i) {
                newEffects.add((MobEffectInstance)effects.get(i));
            }
            newEffects.add(effect);
            effects = newEffects;
        }
        if (!effects.isEmpty()) {
            ListTag listTag = new ListTag();
            for (MobEffectInstance effectInstance : effects) {
                listTag.add((Object)effectInstance.m_19555_(new CompoundTag()));
            }
            compoundTag.m_128365_("CustomPotionEffects", (Tag)listTag);
        }
    }

    public CreativeModeTab getCreativeTab() {
        return EnigmaticTabs.MAIN;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        List effects = PotionUtils.m_43571_((ItemStack)stack);
        if (effects.isEmpty()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.dragonBow");
        } else {
            PotionUtils.m_43555_((ItemStack)stack, list, (float)0.2f);
        }
        if (stack.m_41793_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int time) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int i = this.m_8105_(stack) - time;
            float f = DragonBow.m_40661_(i);
            if (f >= 0.1f) {
                stack.m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
                if (!world.f_46443_) {
                    List effects = PotionUtils.m_43571_((ItemStack)stack);
                    int multi = stack.getEnchantmentLevel(Enchantments.f_44959_) > 0 ? 1 : 0;
                    int punch = stack.getEnchantmentLevel(Enchantments.f_44989_);
                    int power = stack.getEnchantmentLevel(Enchantments.f_44988_);
                    for (int index = -multi; index < 1 + multi; ++index) {
                        DragonBreathArrow arrow = new DragonBreathArrow((LivingEntity)player, world);
                        arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.6f, 1.0f);
                        arrow.m_20256_(arrow.m_20184_().m_82490_(0.95).m_82520_(0.0, 0.135 * (double)index, 0.0));
                        if (!effects.isEmpty()) {
                            for (MobEffectInstance effect : effects) {
                                arrow.addEffect(effect);
                            }
                        }
                        if (power > 0) {
                            arrow.m_36781_(arrow.m_36789_() + (double)power * 0.8);
                        }
                        if (punch > 0) {
                            arrow.m_36735_(punch);
                        }
                        world.m_7967_((Entity)arrow);
                    }
                }
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 2.5f / (user.m_217043_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public Predicate<ItemStack> m_6437_() {
        return itemStack -> false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(Items.f_42411_.m_7968_(), enchantment) && enchantment != Enchantments.f_44952_ && enchantment != Enchantments.f_44990_ || enchantment == Enchantments.f_44959_;
    }
}

