/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class QuartzRing
extends ItemBaseCurio {
    public static Omniconfig.DoubleParameter defaultArmorBonus;
    public static Omniconfig.PerhapsParameter magicResistance;
    public List<ResourceKey<DamageType>> resistanccList = new ArrayList<ResourceKey<DamageType>>();

    public QuartzRing() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.UNCOMMON));
        this.resistanccList.add((ResourceKey<DamageType>)DamageTypes.f_268515_);
        this.resistanccList.add((ResourceKey<DamageType>)DamageTypes.f_268493_);
        this.resistanccList.add((ResourceKey<DamageType>)DamageTypes.f_268482_);
        this.resistanccList.add((ResourceKey<DamageType>)DamageTypes.f_268530_);
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("MagicQuartzRing");
        defaultArmorBonus = builder.comment("Default amount of armor provided by Magic Quartz Ring.").max(256.0).getDouble("DefaultArmor", 2.0);
        magicResistance = builder.comment("Resistance to magic damage provided by Magic Quartz Ring. Defined as percentage.").max(100.0).getPerhaps("MagicResistance", 30);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        this.addAttributes(list, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addAttributes(List<Component> list, ItemStack stack) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedFormattedString(list, (String)"curios.modifiers.ring", (ChatFormatting)ChatFormatting.GOLD);
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.magic_resistance", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + magicResistance + "%"});
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.armor", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + defaultArmorBonus});
        double luck = 1.5;
        if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.hasItem((Player)Minecraft.m_91087_().f_91074_, (Item)EnigmaticAddonItems.ARTIFICIAL_FLOWER)) {
            luck *= 2.0;
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.luck", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + luck});
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Player player;
        HashMultimap attributes = HashMultimap.create();
        double luck = 1.5;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && SuperpositionHandler.hasItem((Player)(player = (Player)livingEntity), (Item)EnigmaticAddonItems.ARTIFICIAL_FLOWER)) {
            luck *= 2.0;
        }
        attributes.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(UUID.fromString("3b312dce-5f84-c7e5-fa4b-8021a74c3d96"), "Armor bonus", defaultArmorBonus.getValue(), AttributeModifier.Operation.ADDITION));
        attributes.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.fromString("233c2c66-ef0c-4036-8101-6540abc9bf47"), "Luck Bonus", luck, AttributeModifier.Operation.ADDITION));
        return attributes;
    }
}

