/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.api.items.IBlessed;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.SlotContext;

public class ThunderScroll
extends ItemBaseCurio
implements ICursed,
IBlessed {
    public ThunderScroll() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static float modify(LivingEntity target, float damage) {
        double value;
        if (target.m_21204_().m_22171_(Attributes.f_22284_) && (value = target.m_21051_(Attributes.f_22284_).m_22135_()) > 0.0) {
            double factor = 1.0 - Math.min(0.0375 * value, 0.75);
            damage = (float)((double)damage / Math.sqrt(factor));
        }
        return damage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.thunderScroll1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.thunderScroll2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.thunderScroll3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.thunderScroll4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.thunderScroll5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.thunderScroll6");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        if (super.canEquip(context, stack)) {
            Player player;
            LivingEntity entity = context.entity();
            return entity instanceof Player && SuperAddonHandler.isOKOne(player = (Player)entity);
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLightningHit(LivingDamageEvent event) {
        Entity directEntity = event.getSource().m_7640_();
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getEntity(), (Item)this) && event.getSource().m_269533_(DamageTypeTags.f_268725_)) {
            if (directEntity != null && directEntity.m_19880_().contains("HarmlessThunder")) {
                event.setCanceled(true);
                return;
            }
            event.setAmount(event.getAmount() * 0.5f);
            event.getEntity().getPersistentData().m_128379_("ThunderScrollLightningPass", true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onDealt(LivingDamageEvent event) {
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getEntity(), (Item)this) && event.getSource().m_269533_(DamageTypeTags.f_268725_) && event.getEntity().getPersistentData().m_128471_("ThunderScrollLightningPass")) {
            event.getEntity().getPersistentData().m_128473_("ThunderScrollLightningPass");
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLightningHit(LivingHurtEvent event) {
        Entity directEntity = event.getSource().m_7640_();
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getEntity(), (Item)this) && event.getSource().m_269533_(DamageTypeTags.f_268725_)) {
            if (directEntity != null && directEntity.m_19880_().contains("HarmlessThunder")) {
                event.setCanceled(true);
                return;
            }
            event.getEntity().getPersistentData().m_128379_("ThunderScrollLightningPass", true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onDealt(LivingHurtEvent event) {
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getEntity(), (Item)this) && event.getSource().m_269533_(DamageTypeTags.f_268725_) && event.getEntity().getPersistentData().m_128471_("ThunderScrollLightningPass")) {
            event.getEntity().getPersistentData().m_128473_("ThunderScrollLightningPass");
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLightningStrike(EntityStruckByLightningEvent event) {
        ItemEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof ItemEntity && (entity = (ItemEntity)entity2).m_32055_().m_150930_((Item)EnigmaticItems.ABYSSAL_HEART)) {
            entity.getPersistentData().m_128379_("Anni", true);
        }
        if (event.getLightning().m_19880_().contains("HarmlessThunder")) {
            if (event.getEntity() instanceof ItemEntity) {
                event.setCanceled(true);
            } else {
                LivingEntity entity3;
                Entity entity4 = event.getEntity();
                if (entity4 instanceof LivingEntity && SuperpositionHandler.hasCurio((LivingEntity)(entity3 = (LivingEntity)entity4), (Item)this)) {
                    event.setCanceled(true);
                }
            }
        } else {
            entity2 = event.getEntity();
            if (entity2 instanceof LivingEntity && SuperpositionHandler.hasCurio((LivingEntity)(entity = (LivingEntity)entity2), (Item)this)) {
                entity.getPersistentData().m_128379_("ThunderScrollPass", true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onLightningDealt(EntityStruckByLightningEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && SuperpositionHandler.hasCurio((LivingEntity)(entity = (LivingEntity)entity2), (Item)this) && event.getEntity().getPersistentData().m_128471_("ThunderScrollPass")) {
            event.getEntity().getPersistentData().m_128473_("ThunderScrollPass");
            event.setCanceled(false);
        }
    }
}

