/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.contents.entities.UltimatePotionEntity;
import auviotre.enigmatic.addon.helpers.PotionAddonHelper;
import auviotre.enigmatic.addon.registries.EnigmaticAddonPotions;
import com.aizistral.enigmaticlegacy.api.items.IAdvancedPotionItem;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.helpers.PotionHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.objects.AdvancedPotion;
import com.aizistral.enigmaticlegacy.registries.EnigmaticPotions;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class UltimatePotionAddon
extends ItemBase
implements IAdvancedPotionItem {
    public IAdvancedPotionItem.PotionType potionType;

    public UltimatePotionAddon(Rarity rarity, IAdvancedPotionItem.PotionType type) {
        super(ItemBase.getDefaultProperties().m_41497_(rarity).m_41487_(1));
        this.potionType = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return this.potionType == IAdvancedPotionItem.PotionType.ULTIMATE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_().m_41777_();
        PotionHelper.setAdvancedPotion((ItemStack)stack, (AdvancedPotion)EnigmaticPotions.EMPTY_POTION);
        return stack.m_41777_();
    }

    public String m_5671_(ItemStack stack) {
        String id = this.m_5524_();
        return id + ".effect." + PotionAddonHelper.getAdvancedPotion(stack).getId();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        SuperpositionHandler.addPotionTooltip(PotionAddonHelper.getEffects(stack), (ItemStack)stack, list, (float)1.0f);
    }

    public CreativeModeTab getCreativeTab() {
        return EnigmaticTabs.POTIONS;
    }

    public List<ItemStack> getCreativeTabStacks() {
        ImmutableList.Builder items = ImmutableList.builder();
        Iterator<AdvancedPotion> iterator = this.potionType == IAdvancedPotionItem.PotionType.COMMON ? EnigmaticAddonPotions.COMMON_POTIONS.iterator() : EnigmaticAddonPotions.ULTIMATE_POTIONS.iterator();
        while (iterator.hasNext()) {
            AdvancedPotion potion = iterator.next();
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemNBTHelper.setString((ItemStack)stack, (String)"EnigmaticPotion", (String)potion.getId());
            items.add((Object)stack);
        }
        return items.build();
    }

    public IAdvancedPotionItem.PotionType getPotionType() {
        return this.potionType;
    }

    public static class Lingering
    extends UltimatePotionAddon {
        public Lingering(Rarity rarity, IAdvancedPotionItem.PotionType type) {
            super(rarity, type);
        }

        public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
            ItemStack itemstack = playerIn.m_21120_(handIn);
            ItemStack thrown = playerIn.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack.m_41620_(1);
            worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12091_, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            if (!worldIn.f_46443_) {
                UltimatePotionEntity potionEntity = new UltimatePotionEntity(worldIn, (LivingEntity)playerIn);
                potionEntity.m_37446_(thrown);
                potionEntity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), -20.0f, 0.5f, 1.0f);
                potionEntity.m_5602_((Entity)playerIn);
                worldIn.m_7967_((Entity)potionEntity);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
    }

    public static class Splash
    extends UltimatePotionAddon {
        public Splash(Rarity rarity, IAdvancedPotionItem.PotionType type) {
            super(rarity, type);
        }

        public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
            ItemStack itemstack = playerIn.m_21120_(handIn);
            ItemStack thrown = playerIn.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack.m_41620_(1);
            worldIn.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12091_, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            if (!worldIn.f_46443_) {
                UltimatePotionEntity potionEntity = new UltimatePotionEntity(worldIn, (LivingEntity)playerIn);
                potionEntity.m_37446_(thrown);
                potionEntity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), -20.0f, 0.5f, 1.0f);
                potionEntity.m_5602_((Entity)playerIn);
                worldIn.m_7967_((Entity)potionEntity);
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
    }

    public static class Base
    extends UltimatePotionAddon {
        public Base(Rarity rarity, IAdvancedPotionItem.PotionType type) {
            super(rarity, type);
        }

        public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
            Player player = entityLiving instanceof Player ? (Player)entityLiving : null;
            List<MobEffectInstance> effectList = PotionAddonHelper.getEffects(stack);
            if (player == null || !player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
            }
            if (!worldIn.f_46443_) {
                for (MobEffectInstance effect : effectList) {
                    if (effect.m_19544_().m_8093_()) {
                        effect.m_19544_().m_19461_((Entity)player, (Entity)player, entityLiving, effect.m_19564_(), 1.0);
                        continue;
                    }
                    entityLiving.m_7292_(new MobEffectInstance(effect));
                }
            }
            if (player != null) {
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            if (player == null || !player.m_150110_().f_35937_) {
                if (stack.m_41619_()) {
                    return new ItemStack((ItemLike)Items.f_42590_);
                }
                if (player != null) {
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
                }
            }
            return stack;
        }

        public int m_8105_(ItemStack stack) {
            return 32;
        }

        public UseAnim m_6164_(ItemStack stack) {
            return UseAnim.DRINK;
        }

        public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
        }
    }
}

