/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.packets.clients;

import auviotre.enigmatic.addon.client.particles.StarDustParticle;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.items.AstralBreaker;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketStarParticles {
    private final double x;
    private final double y;
    private final double z;
    private final int amount;
    private final int mode;

    public PacketStarParticles(double x, double y, double z, int number, int mode) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.amount = number;
        this.mode = mode;
    }

    public static void encode(PacketStarParticles msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        buf.writeInt(msg.amount);
        buf.writeInt(msg.mode);
    }

    public static PacketStarParticles decode(FriendlyByteBuf buf) {
        return new PacketStarParticles(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readInt(), buf.readInt());
    }

    public static void handle(PacketStarParticles msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            block7: {
                int amount;
                LocalPlayer player;
                block6: {
                    player = Minecraft.m_91087_().f_91074_;
                    amount = (int)((float)msg.amount * SuperpositionHandler.getParticleMultiplier());
                    if (msg.mode != 1 || !AstralBreaker.flameParticlesToggle.getValue()) break block6;
                    float modifier = switch ((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()) {
                        case ParticleStatus.MINIMAL -> 0.1f;
                        case ParticleStatus.DECREASED -> 0.25f;
                        default -> 0.35f;
                    };
                    amount = (int)((float)msg.amount * modifier);
                    for (int counter = 0; counter <= amount; ++counter) {
                        player.m_9236_().m_6493_(StarDustParticle.get(player.m_217043_()), true, msg.x + (Math.random() - 0.5), msg.y + (Math.random() - 0.5), msg.z + (Math.random() - 0.5), (Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.1, (Math.random() - 0.5) * 0.1);
                    }
                    break block7;
                }
                if (msg.mode != 0) break block7;
                for (int counter = 0; counter < amount; ++counter) {
                    double theta = Math.random() * 2.0 * Math.PI;
                    double phi = (Math.random() - 0.5) * Math.PI;
                    double dx = Math.cos(theta) * Math.cos(phi) * 0.75;
                    double dy = Math.sin(phi) * 0.75;
                    double dz = Math.sin(theta) * Math.cos(phi) * 0.75;
                    player.m_9236_().m_7106_(StarDustParticle.get(player.m_217043_()), msg.x, msg.y, msg.z, dx, dy, dz);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

