/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.packets.server;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class PacketEmptyLeftClick {
    private final boolean clicked;

    public PacketEmptyLeftClick(boolean clicked) {
        this.clicked = clicked;
    }

    public static void encode(PacketEmptyLeftClick msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.clicked);
    }

    @NotNull
    public static PacketEmptyLeftClick decode(FriendlyByteBuf buf) {
        return new PacketEmptyLeftClick(buf.readBoolean());
    }

    public static void handle(PacketEmptyLeftClick msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer servPlayer = ((NetworkEvent.Context)context.get()).getSender();
            float base = (float)(0.5 * servPlayer.m_21133_(Attributes.f_22281_));
            float damage = EnchantmentHelper.m_44821_((LivingEntity)servPlayer) * base;
            double delX = -Mth.m_14031_((float)(servPlayer.m_146908_() * ((float)Math.PI / 180)));
            double delY = Mth.m_14089_((float)(servPlayer.m_146908_() * ((float)Math.PI / 180)));
            AABB sweepHitBox = servPlayer.m_21120_(InteractionHand.MAIN_HAND).getSweepHitBox((Player)servPlayer, (Entity)servPlayer);
            Iterator iterator = servPlayer.m_9236_().m_45976_(LivingEntity.class, sweepHitBox.m_82386_(delX, 0.0, delY)).iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                LivingEntity livingentity = (LivingEntity)iterator.next();
                double entityReachSq = Mth.m_144952_((double)servPlayer.getEntityReach());
                if (livingentity == servPlayer || servPlayer.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(servPlayer.m_20280_((Entity)livingentity) < entityReachSq)) continue;
                livingentity.m_147240_(0.4, -delX, -delY);
                livingentity.m_6469_(servPlayer.m_269291_().m_269075_((Player)servPlayer), damage);
            }
            servPlayer.m_9236_().m_6263_(null, servPlayer.m_20185_(), servPlayer.m_20186_(), servPlayer.m_20189_(), SoundEvents.f_12317_, servPlayer.m_5720_(), 1.0f, 1.0f);
            servPlayer.m_36346_();
            servPlayer.m_36399_(0.1f);
            servPlayer.m_36335_().m_41524_((Item)EnigmaticAddonItems.THUNDER_SCROLL, (int)(16.0 / servPlayer.m_21133_(Attributes.f_22283_)));
        });
        context.get().setPacketHandled(true);
    }
}

