/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.adminutilities.network;

import net.mcreator.adminutilities.AdminUtilitiesMod;
import net.mcreator.adminutilities.procedures.AdventureButtonClickProcedure;
import net.mcreator.adminutilities.procedures.ClearButtonClickProcedure;
import net.mcreator.adminutilities.procedures.ClearEffectButtonClickProcedure;
import net.mcreator.adminutilities.procedures.ClearWeatherButtonClickProcedure;
import net.mcreator.adminutilities.procedures.CommondBlockOutputFalseButtonClickProcedure;
import net.mcreator.adminutilities.procedures.CommondBlockOutputTrueButtonClickProcedure;
import net.mcreator.adminutilities.procedures.CreativeButtonClickProcedure;
import net.mcreator.adminutilities.procedures.DayButtonClickProcedure;
import net.mcreator.adminutilities.procedures.DisableRaidsButtonClickProcedure;
import net.mcreator.adminutilities.procedures.EnableRaidsButtonClickProcedure;
import net.mcreator.adminutilities.procedures.InstantHealthEffectButtonClickProcedure;
import net.mcreator.adminutilities.procedures.InvisibilityEffectButtonClickProcedure;
import net.mcreator.adminutilities.procedures.KeepInventoryFalseButtonClickProcedure;
import net.mcreator.adminutilities.procedures.KeepInventoryTrueButtonClickProcedure;
import net.mcreator.adminutilities.procedures.MobSpawningFalseButtonClickProcedure;
import net.mcreator.adminutilities.procedures.MobSpawningTrueButtonClickProcedure;
import net.mcreator.adminutilities.procedures.NightButtonClickProcedure;
import net.mcreator.adminutilities.procedures.RainyButtonClickProcedure;
import net.mcreator.adminutilities.procedures.SpawnSculkPatchButtonClickProcedure;
import net.mcreator.adminutilities.procedures.SpectatorButtonClickProcedure;
import net.mcreator.adminutilities.procedures.SuperPickaxeButtonClickProcedure;
import net.mcreator.adminutilities.procedures.SuperSwordButtonClickProcedure;
import net.mcreator.adminutilities.procedures.SurvivalButtonClickProcedure;
import net.mcreator.adminutilities.procedures.ThunderButtonClickProcedure;
import net.mcreator.adminutilities.procedures.TickFreezeButtonClickProcedure;
import net.mcreator.adminutilities.procedures.TickUnfreezeButtonClickProcedure;
import net.mcreator.adminutilities.procedures.WardenSpawnFalseButtonClickProcedure;
import net.mcreator.adminutilities.procedures.WardenSpawnTrueButtonClickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record AdminPanelButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AdminPanelButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"admin_utilities", (String)"admin_panel_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AdminPanelButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new AdminPanelButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<AdminPanelButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(AdminPanelButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> AdminPanelButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AdventureButtonClickProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            CreativeButtonClickProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SpectatorButtonClickProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SurvivalButtonClickProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            ClearButtonClickProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            DayButtonClickProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 6) {
            NightButtonClickProcedure.execute((LevelAccessor)world);
        }
        if (buttonID == 7) {
            ThunderButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            RainyButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            ClearWeatherButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 10) {
            ClearEffectButtonClickProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            InvisibilityEffectButtonClickProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            InstantHealthEffectButtonClickProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            KeepInventoryTrueButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 14) {
            KeepInventoryFalseButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 15) {
            MobSpawningTrueButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 16) {
            MobSpawningFalseButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 17) {
            CommondBlockOutputTrueButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 18) {
            CommondBlockOutputFalseButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 19) {
            SuperPickaxeButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 20) {
            EnableRaidsButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 21) {
            DisableRaidsButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 22) {
            SuperSwordButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 23) {
            WardenSpawnTrueButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 24) {
            WardenSpawnFalseButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 25) {
            SpawnSculkPatchButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 26) {
            TickUnfreezeButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 27) {
            TickFreezeButtonClickProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AdminUtilitiesMod.addNetworkMessage(TYPE, STREAM_CODEC, AdminPanelButtonMessage::handleData);
    }
}

