/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.adminutilities.network;

import java.util.function.Supplier;
import net.mcreator.adminutilities.AdminUtilitiesMod;
import net.mcreator.adminutilities.init.AdminUtilitiesModMenus;
import net.mcreator.adminutilities.init.AdminUtilitiesModScreens;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MenuStateUpdateMessage {
    private final int elementType;
    private final String name;
    private final Object elementState;

    public MenuStateUpdateMessage(int elementType, String name, Object elementState) {
        this.elementType = elementType;
        this.name = name;
        this.elementState = elementState;
    }

    public MenuStateUpdateMessage(FriendlyByteBuf buffer) {
        this.elementType = buffer.readInt();
        this.name = buffer.m_130277_();
        Object elementState = null;
        if (this.elementType == 0) {
            elementState = buffer.m_130277_();
        } else if (this.elementType == 1) {
            elementState = buffer.readBoolean();
        }
        this.elementState = elementState;
    }

    public static void buffer(MenuStateUpdateMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.elementType);
        buffer.m_130070_(message.name);
        if (message.elementType == 0) {
            buffer.m_130070_((String)message.elementState);
        } else if (message.elementType == 1) {
            buffer.writeBoolean(((Boolean)message.elementState).booleanValue());
        }
    }

    public static void handler(MenuStateUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        String string;
        Object object;
        if (message.name.length() > 256 || (object = message.elementState) instanceof String && (string = (String)object).length() > 8192) {
            return;
        }
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu menu$temp = context.getSender().f_36096_;
            if (menu$temp instanceof AdminUtilitiesModMenus.MenuAccessor) {
                Screen accessor$temp;
                AdminUtilitiesModMenus.MenuAccessor menu = (AdminUtilitiesModMenus.MenuAccessor)menu$temp;
                menu.getMenuState().put(message.elementType + ":" + message.name, message.elementState);
                if (!context.getDirection().getReceptionSide().isServer() && (accessor$temp = Minecraft.m_91087_().f_91080_) instanceof AdminUtilitiesModScreens.ScreenAccessor) {
                    AdminUtilitiesModScreens.ScreenAccessor accessor = (AdminUtilitiesModScreens.ScreenAccessor)accessor$temp;
                    accessor.updateMenuState(message.elementType, message.name, message.elementState);
                }
            }
        });
        context.setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AdminUtilitiesMod.addNetworkMessage(MenuStateUpdateMessage.class, MenuStateUpdateMessage::buffer, MenuStateUpdateMessage::new, MenuStateUpdateMessage::handler);
    }
}

