/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.client.renderers;

import com.fruityspikes.whaleborne.client.models.AnchorHeadModel;
import com.fruityspikes.whaleborne.client.models.AnchorModel;
import com.fruityspikes.whaleborne.client.renderers.WhaleWidgetRenderer;
import com.fruityspikes.whaleborne.server.entities.AnchorEntity;
import com.fruityspikes.whaleborne.server.entities.WhaleWidgetEntity;
import com.fruityspikes.whaleborne.server.registries.WBEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class AnchorRenderer
extends WhaleWidgetRenderer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("whaleborne", "textures/entity/anchor.png");
    public static final ResourceLocation CHAIN = new ResourceLocation("whaleborne", "textures/entity/chain.png");
    public static final ResourceLocation ANCHOR_HEAD_TEXTURE = new ResourceLocation("whaleborne", "textures/entity/anchor_head.png");
    private final AnchorHeadModel anchorHeadModel;

    public AnchorRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new AnchorModel(context.m_174023_(WBEntityModelLayers.ANCHOR));
        this.anchorHeadModel = new AnchorHeadModel(context.m_174023_(WBEntityModelLayers.ANCHOR_HEAD));
    }

    @Override
    public void render(WhaleWidgetEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        AnchorEntity anchor;
        super.render(entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        if (entity instanceof AnchorEntity && !(anchor = (AnchorEntity)entity).isClosed() && anchor.getHeadPos() != null) {
            this.renderChain(anchor, poseStack, partialTick, buffer, packedLight, true);
            this.renderChain(anchor, poseStack, partialTick, buffer, packedLight, false);
            this.renderAnchorHead(anchor, anchor.getHeadPos(), poseStack, partialTick, buffer, packedLight);
        }
    }

    private void renderAnchorHead(AnchorEntity anchor, BlockPos headPos, PoseStack poseStack, float partialTick, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        Vec3 anchorPos = anchor.m_20182_();
        Vec3 headVec = Vec3.m_82512_((Vec3i)headPos).m_82546_(anchorPos);
        Vec3 tip = new Vec3(anchor.m_20182_().m_82492_((double)anchor.getHeadPos().m_123341_(), (double)anchor.getHeadPos().m_123342_(), (double)anchor.getHeadPos().m_123343_()).m_252839_()).m_82520_(0.0, -2.0, 0.0).m_82542_(-1.0, -1.0, -1.0);
        poseStack.m_85837_(tip.f_82479_, tip.f_82480_ - 0.2, tip.f_82481_);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)ANCHOR_HEAD_TEXTURE));
        this.anchorHeadModel.m_7695_(poseStack, vertexConsumer, packedLight / 2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public void renderChain(AnchorEntity anchor, PoseStack poseStack, float partialTick, MultiBufferSource buffer, int packedLight, boolean left) {
        poseStack.m_85836_();
        PoseStack.Pose pose = poseStack.m_85850_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)CHAIN));
        Vec3 base = Vec3.f_82478_.m_82520_(0.0, 1.0, 0.0);
        Vec3 entityPos = anchor.m_20182_();
        Vec3 tip = new Vec3(entityPos.m_82492_((double)anchor.getHeadPos().m_123341_(), (double)anchor.getHeadPos().m_123342_(), (double)anchor.getHeadPos().m_123343_()).m_252839_()).m_82520_(0.0, -2.0, 0.0).m_82542_(-1.0, -1.0, -1.0);
        Vec3 direction = tip.m_82546_(base);
        Vec3 dirNorm = direction.m_82541_();
        Vec3 up = Math.abs(dirNorm.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 right = dirNorm.m_82537_(up).m_82541_().m_82490_(0.3);
        Vec3 side = dirNorm.m_82537_(right).m_82541_().m_82490_(0.3);
        Vec3 dir = left ? right : side;
        float length = (float)direction.m_82553_();
        builder.m_252986_(pose.m_252922_(), (float)(base.f_82479_ + dir.f_82479_), (float)(base.f_82480_ + dir.f_82480_), (float)(base.f_82481_ + dir.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(left ? 0.0f : 0.5f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(base.f_82479_ - dir.f_82479_), (float)(base.f_82480_ - dir.f_82480_), (float)(base.f_82481_ - dir.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(left ? 0.5f : 1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(tip.f_82479_ - dir.f_82479_), (float)(tip.f_82480_ - dir.f_82480_), (float)(tip.f_82481_ - dir.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(left ? 0.5f : 1.0f, length).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight / 2).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(pose.m_252922_(), (float)(tip.f_82479_ + dir.f_82479_), (float)(tip.f_82480_ + dir.f_82480_), (float)(tip.f_82481_ + dir.f_82481_)).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(left ? 0.0f : 0.5f, length).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight / 2).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    @Override
    public ResourceLocation getTextureLocation(WhaleWidgetEntity whaleWidgetEntity) {
        return TEXTURE;
    }

    public boolean m_5523_(Entity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        AnchorEntity anchor;
        if (livingEntity instanceof AnchorEntity && !(anchor = (AnchorEntity)livingEntity).isClosed() && anchor.getHeadPos() != null) {
            return true;
        }
        return super.m_5523_(livingEntity, camera, camX, camY, camZ);
    }
}

