/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.client.renderers;

import com.fruityspikes.whaleborne.Config;
import com.fruityspikes.whaleborne.client.models.HullbackArmorModel;
import com.fruityspikes.whaleborne.client.models.HullbackModel;
import com.fruityspikes.whaleborne.server.entities.HullbackEntity;
import com.fruityspikes.whaleborne.server.entities.HullbackPartEntity;
import com.fruityspikes.whaleborne.server.registries.WBEntityModelLayers;
import com.fruityspikes.whaleborne.server.registries.WBTagRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class HullbackRenderer<T extends HullbackEntity>
extends MobRenderer<HullbackEntity, HullbackModel<HullbackEntity>> {
    public static final ResourceLocation MOB_TEXTURE = new ResourceLocation("whaleborne", "textures/entity/hullback.png");
    public static final ResourceLocation STEEN_TEXTURE = new ResourceLocation("whaleborne", "textures/entity/steen.png");
    public static final ResourceLocation SADDLE_TEXTURE = new ResourceLocation("whaleborne", "textures/entity/hullback_saddle.png");
    public static final ResourceLocation ARMOR_TEXTURE = new ResourceLocation("whaleborne", "textures/entity/armor/hullback_dark_oak_planks_armor.png");
    public static final ResourceLocation ARMOR_PROGRESS = new ResourceLocation("whaleborne", "textures/entity/hullback_armor_progress.png");
    private final HullbackArmorModel<HullbackEntity> armorModel;

    public HullbackRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new HullbackModel(ctx.m_174023_(WBEntityModelLayers.HULLBACK)), 5.0f);
        this.armorModel = new HullbackArmorModel(ctx.m_174023_(WBEntityModelLayers.HULLBACK_ARMOR));
    }

    public ResourceLocation getArmor(HullbackEntity pEntity) {
        ItemStack armor;
        if (pEntity.getArmorProgress() > 0.0f && (armor = pEntity.getArmor()).m_204117_(WBTagRegistry.HULLBACK_EQUIPPABLE)) {
            ResourceLocation armor_tex = new ResourceLocation("whaleborne", "textures/entity/armor/hullback_" + armor.m_41720_() + "_armor.png");
            Optional tex = Minecraft.m_91087_().m_91098_().m_213713_(armor_tex);
            return tex.isPresent() ? armor_tex : ARMOR_TEXTURE;
        }
        return ARMOR_TEXTURE;
    }

    public void render(HullbackEntity pEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)pEntity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        this.renderPart(pEntity, poseStack, buffer, partialTicks, packedLight, ((HullbackModel)this.f_115290_).getHead(), this.armorModel.getHead(), 0, 5.0f, 5.0f);
        this.renderPart(pEntity, poseStack, buffer, partialTicks, packedLight, ((HullbackModel)this.f_115290_).getBody(), this.armorModel.getBody(), 2, 5.0f, 5.0f);
        this.renderPart(pEntity, poseStack, buffer, partialTicks, packedLight, ((HullbackModel)this.f_115290_).getTail(), null, 3, 2.5f, 2.5f);
        this.renderPart(pEntity, poseStack, buffer, partialTicks, packedLight, ((HullbackModel)this.f_115290_).getFluke(), this.armorModel.getFluke(), 4, 0.6f, 4.0f);
        if (this.f_114476_.m_114377_()) {
            this.renderDebug(pEntity, poseStack, buffer, partialTicks);
        }
    }

    private void renderDebug(HullbackEntity pEntity, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        if (pEntity.seats[0] != null) {
            for (Vec3 seat : pEntity.seats) {
                poseStack.m_85836_();
                poseStack.m_85837_(seat.f_82479_ - pEntity.m_20182_().f_82479_, seat.f_82480_ - pEntity.m_20182_().f_82480_, seat.f_82481_ - pEntity.m_20182_().f_82481_);
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (AABB)new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                poseStack.m_85849_();
            }
        }
    }

    private void renderPart(HullbackEntity pEntity, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, int packedLight, ModelPart part, ModelPart armorPart, int index, float height, float width) {
        boolean flag;
        poseStack.m_85836_();
        Vec3 finalPos = Vec3.f_82478_;
        if (pEntity.getOldPartPos(index) != null) {
            Vec3 pos = pEntity.getPartPos(index);
            Vec3 oldPos = pEntity.getOldPartPos(index);
            finalPos = oldPos.m_165921_(pos, (double)partialTicks);
        }
        part.m_233569_();
        part.m_104227_(0.0f, 0.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_85837_(finalPos.f_82479_ - pEntity.m_20318_((float)partialTicks).f_82479_, -(finalPos.f_82480_ - pEntity.m_20318_((float)partialTicks).f_82480_), -(finalPos.f_82481_ - pEntity.m_20318_((float)partialTicks).f_82481_));
        Quaternionf rotation = new Quaternionf();
        if (pEntity.getOldPartPos(index) != null) {
            float yRot = pEntity.getPartYRot(index);
            float xRot = pEntity.getPartXRot(index);
            float oldYRot = pEntity.getOldPartYRot(index);
            float oldXRot = pEntity.getOldPartXRot(index);
            float deltaYRot = Mth.m_14177_((float)(yRot - oldYRot));
            float interpYRot = oldYRot + deltaYRot * partialTicks;
            float deltaXRot = Mth.m_14177_((float)(xRot - oldXRot));
            float interpXRot = oldXRot + deltaXRot * partialTicks;
            rotation.rotationYXZ(interpYRot * ((float)Math.PI / 180), -interpXRot * ((float)Math.PI / 180), 0.0f);
        }
        poseStack.m_252781_(rotation);
        poseStack.m_252880_(0.0f, -height / 2.0f, -width / 2.0f);
        boolean bl = flag = pEntity.f_20916_ > 0;
        if (armorPart != null && pEntity.getArmorProgress() > 0.0f) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, -1.5f, 0.0f);
            poseStack.m_85841_(1.005f, 1.005f, 1.005f);
            float progress = 1.0f - pEntity.getArmorProgress();
            if (index == 2) {
                this.renderFixedNameTag(pEntity, poseStack, buffer, packedLight);
            }
            if (Config.armorProgress) {
                armorPart.m_104306_(poseStack, buffer.m_6299_(RenderType.m_173235_((ResourceLocation)ARMOR_PROGRESS)), packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, progress);
                armorPart.m_104301_(poseStack, buffer.m_6299_(RenderType.m_110479_((ResourceLocation)this.getArmor(pEntity))), packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag));
            } else {
                armorPart.m_104306_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getArmor(pEntity))), packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
                armorPart.m_104306_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)ARMOR_PROGRESS)), packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, pEntity.getArmorProgress(), pEntity.getArmorProgress(), progress);
            }
            poseStack.m_85849_();
        }
        ItemStack crown = pEntity.getCrown();
        if (index == 0 && !crown.m_41619_()) {
            BlockItem blockItem;
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -4.07, -4.0);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            Item item = crown.m_41720_();
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof SkullBlock) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 0.23);
                Minecraft.m_91087_().m_91291_().m_269128_(crown, ItemDisplayContext.FIXED, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), poseStack, buffer, pEntity.m_9236_(), 0);
                poseStack.m_85849_();
            } else {
                Minecraft.m_91087_().m_91291_().m_269128_(crown, ItemDisplayContext.HEAD, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), poseStack, buffer, pEntity.m_9236_(), 0);
            }
            poseStack.m_85849_();
        }
        part.m_104301_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(pEntity))), packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag));
        if (pEntity.m_6254_()) {
            poseStack.m_85836_();
            poseStack.m_85841_(1.009f, 1.009f, 1.009f);
            poseStack.m_252880_(0.0f, -0.01f, -0.01f);
            part.m_104301_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)SADDLE_TEXTURE)), packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag));
            poseStack.m_85849_();
        }
        if (index == 4) {
            poseStack.m_252880_(-0.5f, 0.0f, 0.0f);
        }
        if (index == 3) {
            poseStack.m_252880_(0.25f, 0.0f, 0.0f);
        }
        poseStack.m_252880_(-width / 2.0f, height / 2.0f, 0.0f);
        this.renderBottomDirt(poseStack, buffer, packedLight, pEntity, index);
        if (index == 0 || index == 2) {
            poseStack.m_252880_(0.0f, -height, 0.0f);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            poseStack.m_252880_(-width, 0.0f, 0.0f);
            this.rendertTopDirt(poseStack, buffer, packedLight, pEntity, index);
        }
        poseStack.m_85849_();
    }

    private void renderFixedNameTag(HullbackEntity pEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Component name = pEntity.m_5446_();
        if (name.getString().equals("entity.whaleborne.hullback")) {
            return;
        }
        if (pEntity.m_6084_() && !name.getString().isEmpty()) {
            Font font = this.m_114481_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -1.0, 6.79);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
            float scale = 0.08f;
            poseStack.m_85841_(scale, scale, scale);
            List lines = font.m_92923_((FormattedText)name, 48);
            int n = lines.size();
            Objects.requireNonNull(font);
            float totalHeight = n * 9;
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
                float xOffset = (float)(-font.m_92724_(line)) / 2.0f;
                Objects.requireNonNull(font);
                float yOffset = (float)(i * 9) - totalHeight / 2.0f;
                font.m_272191_(line, xOffset, yOffset, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            }
            poseStack.m_85849_();
        }
    }

    private void rendertTopDirt(PoseStack poseStack, MultiBufferSource buffer, int packedLight, HullbackEntity parent, int index) {
        boolean flag = parent.f_20916_ > 0;
        BlockState[][] array = parent.getDirtArray(index, false);
        if (array != null) {
            for (int x = 0; x < array.length; ++x) {
                for (int y = 0; y < array[x].length; ++y) {
                    poseStack.m_252880_((float)y, 0.0f, (float)x);
                    Minecraft.m_91087_().m_91289_().m_110912_(array[x][y], poseStack, buffer, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag));
                    poseStack.m_252880_((float)(-y), 0.0f, (float)(-x));
                }
            }
        }
    }

    public void renderBottomDirt(PoseStack poseStack, MultiBufferSource buffer, int packedLight, HullbackEntity parent, int index) {
        boolean flag = parent.f_20916_ > 0;
        BlockState[][] array = parent.getDirtArray(index, true);
        if (array != null) {
            for (int x = 0; x < array.length; ++x) {
                for (int y = 0; y < array[x].length; ++y) {
                    poseStack.m_252880_((float)y, 0.0f, (float)x);
                    Minecraft.m_91087_().m_91289_().m_110912_(array[x][y], poseStack, buffer, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag));
                    if (array[x][y].m_60713_(Blocks.f_50038_)) {
                        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                        Minecraft.m_91087_().m_91289_().m_110912_((BlockState)array[x][y].m_61124_((Property)TallSeagrassBlock.f_154740_, (Comparable)DoubleBlockHalf.UPPER), poseStack, buffer, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag));
                        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
                    }
                    if (array[x][y].m_60713_(Blocks.f_50576_)) {
                        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                        Minecraft.m_91087_().m_91289_().m_110912_(Blocks.f_50575_.m_49966_(), poseStack, buffer, packedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag));
                        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
                    }
                    poseStack.m_252880_((float)(-y), 0.0f, (float)(-x));
                }
            }
        }
    }

    public ResourceLocation getTextureLocation(HullbackEntity entity) {
        if (entity.m_5446_().getString().equals("Steen")) {
            return STEEN_TEXTURE;
        }
        return MOB_TEXTURE;
    }

    public boolean shouldRender(HullbackEntity livingEntity, Frustum frustum, double v, double v1, double v2) {
        if (this.shouldRenderAll(livingEntity, frustum, v, v1, v2)) {
            return true;
        }
        Entity entity = livingEntity.m_21524_();
        return entity != null && frustum.m_113029_(entity.m_6921_());
    }

    public boolean shouldRenderAll(HullbackEntity hullbackEntity, Frustum frustum, double v, double v1, double v2) {
        if (!hullbackEntity.m_6000_(v, v1, v2)) {
            return false;
        }
        if (hullbackEntity.f_19811_) {
            return true;
        }
        ArrayList<AABB> list = new ArrayList<AABB>(List.of());
        for (HullbackPartEntity entity : hullbackEntity.getSubEntities()) {
            list.add(entity.m_6921_().m_82400_(0.5));
        }
        return list.stream().anyMatch(arg_0 -> ((Frustum)frustum).m_113029_(arg_0));
    }
}

