/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.client.renderers;

import com.fruityspikes.whaleborne.client.models.SailModel;
import com.fruityspikes.whaleborne.client.renderers.WhaleWidgetRenderer;
import com.fruityspikes.whaleborne.server.entities.SailEntity;
import com.fruityspikes.whaleborne.server.entities.WhaleWidgetEntity;
import com.fruityspikes.whaleborne.server.registries.WBEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.Vec3;

public class SailRenderer<T extends SailEntity>
extends WhaleWidgetRenderer<SailEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("whaleborne", "textures/entity/sail.png");
    public static final ResourceLocation TARP_TEXTURE = new ResourceLocation("whaleborne", "textures/entity/tarp.png");
    private final SailModel<SailEntity> model;
    private Vec3 edge1 = new Vec3(0.0, 0.0, 0.0);
    private Vec3 edge2 = new Vec3(0.0, 0.25, 0.0);
    private Vec3 edge3 = new Vec3(0.0, 0.5, 0.0);
    private Vec3 edge4 = new Vec3(0.0, 0.75, 0.0);
    private Vec3 edge5 = new Vec3(0.0, 1.0, 0.0);

    public SailRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.7f;
        this.model = new SailModel(context.m_174023_(WBEntityModelLayers.SAIL));
    }

    @Override
    public ResourceLocation getTextureLocation(WhaleWidgetEntity whaleWidgetEntity) {
        return TEXTURE;
    }

    @Override
    public void render(WhaleWidgetEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render(entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_())));
        float f = (float)entity.getHurtTime() - partialTick;
        float f1 = entity.getDamage() - partialTick;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.getHurtDir()));
        }
        poseStack.m_252781_(Axis.f_252495_.m_252977_(Mth.m_14189_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_())));
        this.model.setupAnim((SailEntity)entity, partialTick, 0.0f, -0.1f, 0.0f, 0.0f);
        poseStack.m_85836_();
        SailEntity sail = (SailEntity)entity;
        ItemStack item = sail.getBanner();
        List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)item), (ListTag)BannerBlockEntity.m_58487_((ItemStack)item));
        poseStack.m_85849_();
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        this.getModel().m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.renderSails((SailEntity)entity, poseStack, buffer, partialTick, packedLight, OverlayTexture.f_118083_, list, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private void renderSails(SailEntity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, float partialTick, int packedLight, int overlay, List<Pair<Holder<BannerPattern>, DyeColor>> patterns, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.07, -2.44, -0.19);
        double deltaZ = entity.m_20184_().m_82553_();
        if (entity.m_20159_()) {
            deltaZ = entity.m_20202_().m_20184_().m_82553_();
        }
        float windEffect = (float)Math.abs(deltaZ) * 10.0f;
        windEffect = Mth.m_14036_((float)windEffect, (float)0.0f, (float)1.0f);
        float time = (float)entity.f_19797_ * 0.1f + (float)entity.m_19879_();
        float randomSway = Mth.m_14031_((float)time) * 0.2f;
        float freakOutAmount = (float)((double)(Mth.m_14031_((float)(time * 100.0f)) * 0.1f) * (entity.m_9236_().m_46471_() ? 1.1 : 0.0) * (entity.m_9236_().m_46470_() ? 1.1 : 0.0));
        float middleBend = (float)((double)(-(windEffect += randomSway + freakOutAmount) * 0.8f) * (entity.m_9236_().m_46471_() ? 1.1 : 1.0) * (entity.m_9236_().m_46470_() ? 1.1 : 1.0));
        this.edge2 = new Vec3(0.0, this.edge2.f_82480_, (double)(middleBend * 0.5f));
        this.edge3 = new Vec3(0.0, this.edge3.f_82480_, (double)(middleBend * 0.85f));
        this.edge4 = new Vec3(0.0, this.edge4.f_82480_, (double)middleBend);
        float width = 3.75f;
        if (entity.getBanner().m_41619_()) {
            this.renderSailSegment(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TARP_TEXTURE)), this.edge1, this.edge2, width, packedLight, overlay, red, green, blue, alpha);
            this.renderSailSegment(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TARP_TEXTURE)), this.edge2, this.edge3, width, packedLight, overlay, red, green, blue, alpha);
            this.renderSailSegment(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TARP_TEXTURE)), this.edge3, this.edge4, width, packedLight, overlay, red, green, blue, alpha);
            this.renderSailSegment(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TARP_TEXTURE)), this.edge4, this.edge5, width, packedLight, overlay, red, green, blue, alpha);
        } else {
            BannerItem item = (BannerItem)entity.getBanner().m_41720_().m_5456_();
            DyeColor baseColor = item.m_40545_();
            float[] baseColors = baseColor.m_41068_();
            float baseRed = baseColors[0];
            float baseGreen = baseColors[1];
            float baseBlue = baseColors[2];
            this.renderSailSegment(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TARP_TEXTURE)), this.edge1, this.edge2, width, packedLight, overlay, baseRed, baseGreen, baseBlue, alpha);
            this.renderSailSegment(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TARP_TEXTURE)), this.edge2, this.edge3, width, packedLight, overlay, baseRed, baseGreen, baseBlue, alpha);
            this.renderSailSegment(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TARP_TEXTURE)), this.edge3, this.edge4, width, packedLight, overlay, baseRed, baseGreen, baseBlue, alpha);
            this.renderSailSegment(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TARP_TEXTURE)), this.edge4, this.edge5, width, packedLight, overlay, baseRed, baseGreen, baseBlue, alpha);
            for (int i = 0; i < 17 && i < patterns.size(); ++i) {
                if (i == 0) continue;
                Pair<Holder<BannerPattern>, DyeColor> pair = patterns.get(i);
                float[] patternColors = ((DyeColor)pair.getSecond()).m_41068_();
                float patternRed = patternColors[0];
                float patternGreen = patternColors[1];
                float patternBlue = patternColors[2];
                ((Holder)pair.getFirst()).m_203543_().ifPresent(bannerPatternKey -> {
                    Material bannerMaterial = Sheets.m_234347_((ResourceKey)bannerPatternKey);
                    VertexConsumer patternVertexConsumer = bannerMaterial.m_119194_(multiBufferSource, RenderType::m_110482_);
                    this.renderBannerSailSegment(poseStack, patternVertexConsumer, this.edge1, this.edge2, width, packedLight, overlay, patternRed, patternGreen, patternBlue, 1.0f);
                    this.renderBannerSailSegment(poseStack, patternVertexConsumer, this.edge2, this.edge3, width, packedLight, overlay, patternRed, patternGreen, patternBlue, 1.0f);
                    this.renderBannerSailSegment(poseStack, patternVertexConsumer, this.edge3, this.edge4, width, packedLight, overlay, patternRed, patternGreen, patternBlue, 1.0f);
                    this.renderBannerSailSegment(poseStack, patternVertexConsumer, this.edge4, this.edge5, width, packedLight, overlay, patternRed, patternGreen, patternBlue, 1.0f);
                });
            }
        }
        poseStack.m_85849_();
    }

    private void renderSailSegment(PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 topEdge, Vec3 bottomEdge, float width, int packedLight, int overlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        float x0 = -width / 2.0f;
        float x1 = width / 2.0f;
        float topY = (float)topEdge.f_82480_ * 3.55f;
        float topZ = (float)topEdge.f_82481_;
        float bottomY = (float)bottomEdge.f_82480_ * 3.55f;
        float bottomZ = (float)bottomEdge.f_82481_;
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = (float)(1.0 - topEdge.f_82480_);
        float v1 = (float)(1.0 - bottomEdge.f_82480_);
        float minLight = 0.9f;
        float topLight = minLight + (1.0f - minLight) * v0;
        float bottomLight = minLight + (1.0f - minLight) * v1;
        float nx = 0.0f;
        float nz = -1.0f;
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x0, topY, topZ).m_85950_(red, green, blue, alpha).m_7421_(u0, v0).m_86008_(overlay).m_85969_((int)((float)packedLight * topLight)).m_252939_(poseStack.m_85850_().m_252943_(), nx, 0.0f, nz).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x1, topY, topZ).m_85950_(red, green, blue, alpha).m_7421_(u1, v0).m_86008_(overlay).m_85969_((int)((float)packedLight * topLight)).m_252939_(poseStack.m_85850_().m_252943_(), nx, 0.0f, nz).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x1, bottomY, bottomZ).m_85950_(red, green, blue, alpha).m_7421_(u1, v1).m_86008_(overlay).m_85969_((int)((float)packedLight * bottomLight)).m_252939_(poseStack.m_85850_().m_252943_(), nx, 0.0f, nz).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x0, bottomY, bottomZ).m_85950_(red, green, blue, alpha).m_7421_(u0, v1).m_86008_(overlay).m_85969_((int)((float)packedLight * bottomLight)).m_252939_(poseStack.m_85850_().m_252943_(), nx, 0.0f, nz).m_5752_();
        poseStack.m_85849_();
    }

    private void renderBannerSailSegment(PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 topEdge, Vec3 bottomEdge, float width, int packedLight, int overlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        float x0 = -width / 2.0f;
        float x1 = width / 2.0f;
        float topY = (float)topEdge.f_82480_ * 3.55f;
        float topZ = (float)topEdge.f_82481_;
        float bottomY = (float)bottomEdge.f_82480_ * 3.55f;
        float bottomZ = (float)bottomEdge.f_82481_;
        float segmentHeight = 0.25f;
        float segmentIndex = (float)(topEdge.f_82480_ / (double)segmentHeight);
        float u0 = 0.0f;
        float u1 = 0.333f;
        float v0 = segmentIndex * 0.25f * 0.666f;
        float v1 = (segmentIndex + 1.0f) * 0.25f * 0.666f;
        float minLight = 0.9f;
        float topLight = minLight + (1.0f - minLight) * v0;
        float bottomLight = minLight + (1.0f - minLight) * v1;
        float nx = 0.0f;
        float nz = -1.0f;
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x0, topY, topZ).m_85950_(red, green, blue, alpha).m_7421_(u0, v0).m_86008_(overlay).m_85969_(packedLight).m_252939_(poseStack.m_85850_().m_252943_(), nx, 0.0f, nz).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x1, topY, topZ).m_85950_(red, green, blue, alpha).m_7421_(u1, v0).m_86008_(overlay).m_85969_(packedLight).m_252939_(poseStack.m_85850_().m_252943_(), nx, 0.0f, nz).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x1, bottomY, bottomZ).m_85950_(red, green, blue, alpha).m_7421_(u1, v1).m_86008_(overlay).m_85969_(packedLight).m_252939_(poseStack.m_85850_().m_252943_(), nx, 0.0f, nz).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), x0, bottomY, bottomZ).m_85950_(red, green, blue, alpha).m_7421_(u0, v1).m_86008_(overlay).m_85969_(packedLight).m_252939_(poseStack.m_85850_().m_252943_(), nx, 0.0f, nz).m_5752_();
        poseStack.m_85849_();
    }

    @Override
    public Model getModel() {
        return this.model;
    }
}

