/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.client.renderers;

import com.fruityspikes.whaleborne.client.models.SailModel;
import com.fruityspikes.whaleborne.server.entities.WhaleWidgetEntity;
import com.fruityspikes.whaleborne.server.registries.WBEntityModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class WhaleWidgetRenderer<T extends WhaleWidgetEntity>
extends EntityRenderer<WhaleWidgetEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("whaleborne", "textures/entity/sail.png");
    protected EntityModel model;

    public WhaleWidgetRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SailModel(context.m_174023_(WBEntityModelLayers.SAIL));
    }

    public void render(WhaleWidgetEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_())));
        float f = (float)entity.getHurtTime() - partialTick;
        float f1 = entity.getDamage() - partialTick;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.getHurtDir()));
        }
        poseStack.m_252781_(Axis.f_252495_.m_252977_(Mth.m_14189_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_())));
        this.model.m_6973_((Entity)entity, partialTick, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        this.getModel().m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(WhaleWidgetEntity whaleWidgetEntity) {
        return TEXTURE;
    }

    public Model getModel() {
        return this.model;
    }
}

