/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.server.blocks;

import com.fruityspikes.whaleborne.server.registries.WBParticleRegistry;
import com.fruityspikes.whaleborne.server.registries.WBSoundRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class BarnacleBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public BarnacleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7899_(BlockState state) {
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.m_276867_(pos);
        if (flag != (Boolean)state.m_61143_((Property)POWERED)) {
            if (flag) {
                this.playNote(null, state, level, pos);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    private void playNote(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        level.m_7696_(pos, (Block)this, 0, 0);
        level.m_142346_(entity, GameEvent.f_223699_, pos);
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        int count = 0;
        Block thisBlock = level.m_8055_(pos).m_60734_();
        BlockPos checkPos = pos.m_7494_();
        while (level.m_8055_(checkPos).m_60734_() == thisBlock && count < 20) {
            ++count;
            checkPos = checkPos.m_7494_();
        }
        int stackHeight = count;
        float pitch = Math.min(2.0f, (float)stackHeight * 0.22f);
        AABB boundingBox = new AABB(checkPos).m_82377_(0.0, 2.0, 0.0).m_82386_(0.0, 0.5, 0.0);
        List entities = level.m_45933_(null, boundingBox);
        entities.removeIf(entity1 -> !entity1.m_6094_() && !(entity1 instanceof ItemEntity));
        for (Entity entity2 : entities) {
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                player.f_19864_ = true;
            }
            entity2.m_20256_(entity2.m_20184_().m_82520_(0.0, (double)count / 10.0, 0.0));
        }
        level.m_7106_((ParticleOptions)WBParticleRegistry.SMOKE.get(), (double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 0.5, (double)checkPos.m_123343_() + 0.5, 0.0, 0.01, 0.0);
        if (!level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13089_)) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_() + 0.5, (double)checkPos.m_123343_() + 0.5, 0.0, 0.01, 0.0);
            level.m_214150_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, WBSoundRegistry.ORGAN.get(), SoundSource.RECORDS, 2.0f, pitch, level.f_46441_.m_188505_());
        }
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        this.playNote((Entity)player, state, level, pos);
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }
}

