/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.server.entities;

import com.fruityspikes.whaleborne.server.entities.HullbackEntity;
import com.fruityspikes.whaleborne.server.entities.WhaleWidgetEntity;
import com.fruityspikes.whaleborne.server.registries.WBItemRegistry;
import com.fruityspikes.whaleborne.server.registries.WBParticleRegistry;
import com.fruityspikes.whaleborne.server.registries.WBSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AnchorEntity
extends WhaleWidgetEntity {
    private float sinkSpeed = 0.05f;
    boolean hasHitTheBottom = false;
    int coolDown = 0;
    private BlockPos anchorHeadPosition = BlockPos.f_121853_;
    private static final EntityDataAccessor<BlockPos> DATA_HEAD_POSITION = SynchedEntityData.m_135353_(AnchorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> DATA_IS_CLOSED = SynchedEntityData.m_135353_(AnchorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_DOWN = SynchedEntityData.m_135353_(AnchorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AnchorEntity(EntityType<?> entityType, Level level) {
        super(entityType, level, (Item)WBItemRegistry.ANCHOR.get());
    }

    public void setDown(boolean down) {
        this.f_19804_.m_135381_(DATA_IS_DOWN, (Object)down);
    }

    public boolean isClosed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CLOSED);
    }

    public boolean isDown() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_DOWN);
    }

    public void setClosed(boolean closed) {
        this.f_19804_.m_135381_(DATA_IS_CLOSED, (Object)closed);
    }

    public BlockPos getHeadPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_HEAD_POSITION);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CLOSED, (Object)true);
        this.f_19804_.m_135372_(DATA_IS_DOWN, (Object)false);
        this.f_19804_.m_135372_(DATA_HEAD_POSITION, (Object)BlockPos.f_121853_);
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (!this.isClosed() && this.m_20202_() != null && (entity = this.m_20202_()) instanceof HullbackEntity) {
            HullbackEntity hullback = (HullbackEntity)entity;
            hullback.stopMoving();
        }
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (!this.m_9236_().f_46443_) {
            this.handleServerTick();
            this.updateHeadPosition();
        }
    }

    private void handleServerTick() {
        if (!this.isClosed() && this.m_20202_() != null) {
            this.handleAnchorMovement();
        }
    }

    private void handleAnchorMovement() {
        Vec3 currentHeadPos = Vec3.m_82512_((Vec3i)this.anchorHeadPosition);
        if (this.isDown()) {
            if (!this.m_9236_().m_8055_(this.anchorHeadPosition).m_280296_()) {
                this.sinkSpeed -= 0.05f;
                this.m_5496_(SoundEvents.f_11746_, 1.0f, 1.0f);
                Vec3 newPos = currentHeadPos.m_82520_(0.0, (double)this.sinkSpeed, 0.0);
                this.anchorHeadPosition = BlockPos.m_274446_((Position)newPos);
                this.hasHitTheBottom = false;
            } else if (!this.hasHitTheBottom) {
                Entity object;
                this.m_5496_(SoundEvents.f_11668_, 1.0f, 0.9f);
                if (this.m_20202_() != null && (object = this.m_20202_()) instanceof HullbackEntity) {
                    HullbackEntity hullback = (HullbackEntity)object;
                    for (int side : new int[]{-1, 1}) {
                        ServerLevel serverLevel;
                        Vec3 particlePos = hullback.getPartPos(1).m_82549_(new Vec3(3.5 * (double)side, 2.0, 0.0).m_82524_(hullback.getPartYRot(1)));
                        double x = particlePos.f_82479_;
                        double y = particlePos.f_82480_;
                        double z = particlePos.f_82481_;
                        Level level = this.m_9236_();
                        if (level instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WBParticleRegistry.SMOKE.get()), x, y, z, 20, 0.2, 0.2, 0.2, 0.02);
                        }
                        if (!((level = this.m_9236_()) instanceof ServerLevel)) continue;
                        serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, currentHeadPos.f_82479_, currentHeadPos.f_82480_ + 1.0, currentHeadPos.f_82481_, 50, 0.5, 0.5, 0.5, 0.02);
                    }
                    hullback.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
                }
                this.hasHitTheBottom = true;
            }
        } else {
            if (this.anchorHeadPosition == BlockPos.f_121853_) {
                this.anchorHeadPosition = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, -0.5, 0.0));
            }
            this.sinkSpeed += 0.03f;
            this.m_5496_(SoundEvents.f_11746_, 1.0f, 1.0f);
            Vec3 newPos = currentHeadPos.m_82520_(0.0, (double)this.sinkSpeed, 0.0);
            this.anchorHeadPosition = BlockPos.m_274446_((Position)newPos);
        }
        if (this.m_20182_().f_82480_ < currentHeadPos.f_82480_) {
            this.close();
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.coolDown <= 0 && !this.m_9236_().f_46443_) {
            this.toggleDown();
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public void toggleDown() {
        if (this.isClosed()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WBParticleRegistry.SMOKE.get()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.02);
            }
            this.deployAnchor();
        } else {
            this.toggleAnchorState();
        }
        this.coolDown = 20;
    }

    private void updateHeadPosition() {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_HEAD_POSITION, (Object)this.anchorHeadPosition);
        }
    }

    private void deployAnchor() {
        this.f_19804_.m_135381_(DATA_IS_CLOSED, (Object)false);
        this.f_19804_.m_135381_(DATA_IS_DOWN, (Object)true);
        this.sinkSpeed = -0.05f;
        double distanceInFront = -1.0;
        double x = this.m_20185_() + distanceInFront * Math.sin(Math.toRadians(-this.m_146908_()));
        double z = this.m_20189_() + distanceInFront * Math.cos(Math.toRadians(this.m_146908_()));
        this.anchorHeadPosition = BlockPos.m_274561_((double)x, (double)(this.m_20186_() - 1.0), (double)z);
        this.f_19804_.m_135381_(DATA_HEAD_POSITION, (Object)this.anchorHeadPosition);
        this.m_5496_(SoundEvents.f_11745_, 1.0f, 0.9f);
    }

    private void toggleAnchorState() {
        boolean newDownState = !this.isDown();
        this.sinkSpeed = newDownState ? -0.05f : 0.05f;
        this.f_19804_.m_135381_(DATA_IS_DOWN, (Object)newDownState);
        this.m_5496_(newDownState ? SoundEvents.f_11745_ : SoundEvents.f_11794_, 1.0f, 1.0f);
    }

    public void close() {
        this.f_19804_.m_135381_(DATA_IS_CLOSED, (Object)true);
        this.f_19804_.m_135381_(DATA_IS_DOWN, (Object)false);
        this.f_19804_.m_135381_(DATA_HEAD_POSITION, (Object)BlockPos.f_121853_);
        this.sinkSpeed = 0.05f;
        this.anchorHeadPosition = BlockPos.f_121853_;
        this.m_5496_(SoundEvents.f_12201_, 0.7f, 1.2f);
    }

    protected void m_7378_(CompoundTag tag) {
        this.f_19804_.m_135381_(DATA_IS_CLOSED, (Object)tag.m_128471_("isClosed"));
        this.f_19804_.m_135381_(DATA_IS_DOWN, (Object)tag.m_128471_("isDown"));
        this.hasHitTheBottom = tag.m_128471_("hasHitTheBottom");
        this.sinkSpeed = tag.m_128457_("sinkSpeed");
        this.anchorHeadPosition = BlockPos.m_122022_((long)tag.m_128454_("anchorHeadPos"));
        this.f_19804_.m_135381_(DATA_HEAD_POSITION, (Object)this.anchorHeadPosition);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128379_("isClosed", this.isClosed());
        tag.m_128379_("isDown", this.isDown());
        tag.m_128379_("hasHitTheBottom", this.hasHitTheBottom);
        tag.m_128350_("sinkSpeed", this.sinkSpeed);
        tag.m_128356_("anchorHeadPos", this.anchorHeadPosition.m_121878_());
    }
}

