/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.server.entities;

import com.fruityspikes.whaleborne.client.menus.CannonMenu;
import com.fruityspikes.whaleborne.network.CannonFirePacket;
import com.fruityspikes.whaleborne.network.WhaleborneNetwork;
import com.fruityspikes.whaleborne.server.entities.RideableWhaleWidgetEntity;
import com.fruityspikes.whaleborne.server.registries.WBItemRegistry;
import com.fruityspikes.whaleborne.server.registries.WBParticleRegistry;
import com.fruityspikes.whaleborne.server.registries.WBSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;

public class CannonEntity
extends RideableWhaleWidgetEntity
implements ContainerListener,
HasCustomInventoryScreen,
PlayerRideableJumping {
    protected float cannonXRot;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();
    public SimpleContainer inventory = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
        }
    };

    public CannonEntity(EntityType<?> entityType, Level level) {
        super(entityType, level, (Item)WBItemRegistry.CANNON.get());
        this.cannonXRot = this.m_146909_();
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && reason.m_146965_()) {
            Containers.m_19002_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (Container)this.inventory);
        }
        super.m_142687_(reason);
    }

    public void setCannonXRot(float cannonXRot) {
        this.cannonXRot = cannonXRot;
    }

    public float getCannonXRot() {
        return this.cannonXRot;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20160_()) {
            this.setCannonXRot(Mth.m_14189_((float)0.1f, (float)this.cannonXRot, (float)this.getFirstPassenger().m_146909_()));
            this.m_146922_(Mth.m_14189_((float)0.1f, (float)this.m_146908_(), (float)this.getFirstPassenger().m_146908_()));
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (!heldItem.m_41619_()) {
            if (this.isGunpowder(heldItem)) {
                return this.tryInsertItem(player, hand, heldItem, 1);
            }
            return this.tryInsertItem(player, hand, heldItem, 0);
        }
        return super.m_6096_(player, hand);
    }

    private boolean isGunpowder(ItemStack stack) {
        return stack.m_41720_() == Items.f_42403_;
    }

    private InteractionResult tryInsertItem(Player player, InteractionHand hand, ItemStack stack, int slot) {
        ItemStack existing = this.inventory.m_8020_(slot);
        if (existing.m_41619_()) {
            this.inventory.m_6836_(slot, stack.m_41620_(1));
            this.m_216990_(SoundEvents.f_12013_);
            return InteractionResult.SUCCESS;
        }
        if (ItemStack.m_150942_((ItemStack)existing, (ItemStack)stack) && existing.m_41613_() < existing.m_41741_()) {
            int toAdd = Math.min(stack.m_41613_(), existing.m_41741_() - existing.m_41613_());
            existing.m_41769_(toAdd);
            stack.m_41774_(toAdd);
            this.m_5496_(SoundEvents.f_12013_, 1.0f, (float)existing.m_41613_() / (float)existing.m_41741_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean shouldRiderSit() {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void m_7888_(int power) {
        if (this.m_9236_().f_46443_) {
            WhaleborneNetwork.INSTANCE.sendToServer((Object)new CannonFirePacket(this.m_19879_(), power));
        }
    }

    public void fireCannon(int power) {
        ItemStack gunpowder = this.inventory.m_8020_(1);
        if (gunpowder.m_41619_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12198_, SoundSource.NEUTRAL, 1.0f, 0.0f);
            return;
        }
        gunpowder.m_41774_(1);
        ItemStack ammo = this.inventory.m_8020_(0).m_41777_().m_41620_(1);
        if (ammo.m_41619_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11797_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12198_, SoundSource.NEUTRAL, 1.0f, 0.0f);
            return;
        }
        this.inventory.m_8020_(0).m_41774_(1);
        Vec3 lookAngle = this.getFirstPassenger().m_20154_();
        ThrownEnderpearl projectile = null;
        if (ammo.m_150930_(Items.f_42584_)) {
            projectile = new ThrownEnderpearl(this.m_9236_(), this.getFirstPassenger());
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11857_, SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
        } else if (ammo.m_150930_((Item)WBItemRegistry.BARNACLE.get())) {
            LivingEntity passenger = this.getFirstPassenger();
            if (passenger != null) {
                this.m_20153_();
                passenger.m_20334_(lookAngle.f_82479_ * (double)power, lookAngle.f_82480_ * (double)power, lookAngle.f_82481_ * (double)power);
                passenger.f_19864_ = true;
                passenger.m_20124_(Pose.CROUCHING);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), WBSoundRegistry.ORGAN.get(), SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
            }
        } else {
            Item passenger = ammo.m_41720_().m_5456_();
            if (passenger instanceof BoatItem) {
                BoatItem boatItem = (BoatItem)passenger;
                passenger = this.getFirstPassenger();
                if (passenger != null) {
                    String[] boatName = ammo.m_41720_().m_5456_().toString().split("_");
                    StringBuilder boatTypeBuilder = new StringBuilder();
                    boolean hasChest = false;
                    for (int i = 0; i < boatName.length - 1; ++i) {
                        if (!boatName[i].equals("chest")) {
                            if (boatTypeBuilder.length() > 0) {
                                boatTypeBuilder.append("_");
                            }
                            boatTypeBuilder.append(boatName[i]);
                            continue;
                        }
                        hasChest = true;
                    }
                    ChestBoat boat = hasChest ? new ChestBoat(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_()) : new Boat(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                    boat.m_28464_(Boat.Type.m_38432_((String)boatTypeBuilder.toString()));
                    boat.m_146922_(passenger.m_146908_());
                    passenger.m_20329_((Entity)boat);
                    projectile = boat;
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12601_, SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
                }
            } else {
                Item item = ammo.m_41720_();
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                    projectile = spawnEggItem.m_43228_(null).m_20615_(this.m_9236_());
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
                } else if (ammo.m_150930_(Items.f_41996_)) {
                    projectile = new PrimedTnt(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (LivingEntity)this.m_20202_());
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
                } else if (ammo.m_150930_(Items.f_42412_)) {
                    projectile = new Arrow(this.m_9236_(), (LivingEntity)this.m_20202_());
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11847_, SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
                } else {
                    projectile = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), ammo);
                    ((ItemEntity)projectile).m_32010_(10);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, (float)power / 50.0f);
                }
            }
        }
        projectile.m_146884_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
        projectile.m_20334_(lookAngle.f_82479_ * ((double)power / 50.0), lookAngle.f_82480_ * ((double)power / 50.0), lookAngle.f_82481_ * ((double)power / 50.0));
        this.m_20202_().m_5997_(-lookAngle.f_82479_ * ((double)power / 200.0), 0.0, -lookAngle.f_82481_ * ((double)power / 200.0));
        this.m_9236_().m_7967_((Entity)projectile);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WBParticleRegistry.SMOKE.get()), this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 5, 0.1, 0.1, 0.1, 0.02);
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, (float)(power / 100) + this.f_19796_.m_188501_() * 0.4f);
    }

    private void openCannonMenu(Player player) {
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"menu.title.whaleborne.cannon");
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new CannonMenu(windowId, playerInventory, CannonEntity.this);
                }
            }, buf -> buf.writeInt(this.m_19879_()));
        }
    }

    @Override
    public double m_6048_() {
        return this.m_20206_();
    }

    public boolean m_7132_() {
        return true;
    }

    public void m_7199_(int i) {
    }

    public void m_8012_() {
    }

    public void m_5757_(Container container) {
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
    }

    protected int getInventorySize() {
        return 2;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ListTag items = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            stack.m_41739_(itemTag);
            items.add((Object)itemTag);
        }
        tag.m_128365_("Items", (Tag)items);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        ListTag items = tag.m_128437_("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag itemTag = items.m_128728_(i);
            int slot = itemTag.m_128445_("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
    }

    public void m_213583_(Player player) {
        this.openCannonMenu(player);
    }
}

