/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.server.entities;

import com.fruityspikes.whaleborne.client.menus.HullbackMenu;
import com.fruityspikes.whaleborne.network.HullbackHurtPacket;
import com.fruityspikes.whaleborne.network.SyncHullbackDirtPacket;
import com.fruityspikes.whaleborne.network.WhaleborneNetwork;
import com.fruityspikes.whaleborne.server.entities.AnchorEntity;
import com.fruityspikes.whaleborne.server.entities.CannonEntity;
import com.fruityspikes.whaleborne.server.entities.HelmEntity;
import com.fruityspikes.whaleborne.server.entities.HullbackPartEntity;
import com.fruityspikes.whaleborne.server.entities.HullbackWalkableEntity;
import com.fruityspikes.whaleborne.server.entities.SailEntity;
import com.fruityspikes.whaleborne.server.registries.WBBlockRegistry;
import com.fruityspikes.whaleborne.server.registries.WBEntityRegistry;
import com.fruityspikes.whaleborne.server.registries.WBItemRegistry;
import com.fruityspikes.whaleborne.server.registries.WBParticleRegistry;
import com.fruityspikes.whaleborne.server.registries.WBSoundRegistry;
import com.fruityspikes.whaleborne.server.registries.WBTagRegistry;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class HullbackEntity
extends WaterAnimal
implements ContainerListener,
HasCustomInventoryScreen,
PlayerRideableJumping,
Saddleable {
    private static final UUID SAIL_SPEED_MODIFIER_UUID = UUID.fromString("12345678-1234-1234-1234-1234567890ab");
    private boolean validatedAfterLoad = false;
    private float leftEyeYaw;
    private float rightEyeYaw;
    private float eyePitch;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();
    private boolean immobile;
    private boolean tamedCoolDown;
    private Vec3 currentTarget;
    public int stationaryTicks;
    public SimpleContainer inventory = new SimpleContainer(3){

        public void m_6596_() {
            super.m_6596_();
        }
    };
    public static final int INV_SLOT_CROWN = 0;
    public static final int INV_SLOT_SADDLE = 1;
    public static final int INV_SLOT_ARMOR = 2;
    public static boolean HAS_MOBIUS_SPAWNED = false;
    public static final EntityDataAccessor<ItemStack> DATA_CROWN_ID = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<ItemStack> DATA_ARMOR = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> DATA_MOUTH_PROGRESS = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SEAT_0 = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SEAT_1 = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SEAT_2 = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SEAT_3 = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SEAT_4 = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SEAT_5 = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_SEAT_6 = SynchedEntityData.m_135353_(HullbackEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public final HullbackPartEntity head;
    public final HullbackPartEntity nose;
    public final HullbackPartEntity body;
    public final HullbackPartEntity tail;
    public final HullbackPartEntity fluke;
    public HullbackWalkableEntity moving_head;
    public HullbackWalkableEntity moving_nose;
    public HullbackWalkableEntity moving_body;
    private final HullbackPartEntity[] subEntities;
    private Vec3[] prevPartPositions;
    private Vec3[] partPosition;
    private float[] partYRot;
    private float[] partXRot;
    private Vec3[] oldPartPosition;
    private float[] oldPartYRot;
    private float[] oldPartXRot;
    public float newRotY = this.m_146908_();
    private float mouthOpenProgress;
    private float mouthTarget;
    public float AttributeSpeedModifier = 1.0f;
    public BlockState[][] headDirt;
    public BlockState[][] headTopDirt;
    public BlockState[][] bodyDirt;
    public BlockState[][] bodyTopDirt;
    public BlockState[][] tailDirt;
    public BlockState[][] flukeDirt;
    public BlockState[] possibleBottomBlocks = new BlockState[]{Blocks.f_50037_.m_49966_(), Blocks.f_50575_.m_49966_(), Blocks.f_50038_.m_49966_(), Blocks.f_50576_.m_49966_(), ((Block)WBBlockRegistry.WHALE_BARNACLE_0.get()).m_49966_(), ((Block)WBBlockRegistry.WHALE_BARNACLE_1.get()).m_49966_()};
    public BlockState[] possibleFreshBlocks = new BlockState[]{Blocks.f_50037_.m_49966_(), Blocks.f_50575_.m_49966_(), ((Block)WBBlockRegistry.WHALE_BARNACLE_0.get()).m_49966_(), Blocks.f_152543_.m_49966_()};
    public BlockState[] possibleTopBlocks = new BlockState[]{Blocks.f_152543_.m_49966_(), ((Block)WBBlockRegistry.WHALE_BARNACLE_0.get()).m_49966_(), ((Block)WBBlockRegistry.WHALE_BARNACLE_1.get()).m_49966_()};
    public final Vec3[] seatOffsets = new Vec3[]{new Vec3(0.0, 5.5, 0.0), new Vec3(0.0, 5.5, -3.0), new Vec3(1.5, 5.5, 0.3), new Vec3(-1.5, 5.5, 0.3), new Vec3(1.5, 5.5, -1.75), new Vec3(-1.5, 5.5, -1.75), new Vec3(0.0, (double)1.6f, -0.8)};
    public Vec3[] seats = new Vec3[7];
    public Vec3[] oldSeats = new Vec3[7];

    public static UUID getSailSpeedModifierUuid() {
        return SAIL_SPEED_MODIFIER_UUID;
    }

    public HullbackEntity(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 1, 2, 0.1f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 1);
        this.nose = new HullbackPartEntity(this, "nose", 5.0f, 5.0f);
        this.head = new HullbackPartEntity(this, "head", 5.0f, 5.0f);
        this.body = new HullbackPartEntity(this, "body", 5.0f, 5.0f);
        this.tail = new HullbackPartEntity(this, "tail", 2.5f, 2.5f);
        this.fluke = new HullbackPartEntity(this, "fluke", 4.0f, 0.6f);
        this.moving_nose = null;
        this.moving_head = null;
        this.moving_body = null;
        this.subEntities = new HullbackPartEntity[]{this.nose, this.head, this.body, this.tail, this.fluke};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        this.prevPartPositions = new Vec3[5];
        this.partPosition = new Vec3[5];
        this.partYRot = new float[5];
        this.partXRot = new float[5];
        this.oldPartPosition = new Vec3[5];
        this.oldPartYRot = new float[5];
        this.oldPartXRot = new float[5];
        Arrays.fill(this.partPosition, Vec3.f_82478_);
        this.mouthOpenProgress = 0.0f;
        this.currentTarget = this.m_20182_();
        if (!level.f_46443_) {
            this.initDirt();
        } else {
            this.initClientDirt();
        }
        this.stationaryTicks = 60;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return HullbackEntity.checkHullbackSpawnRules((EntityType<HullbackEntity>)this.m_6095_(), level, spawnReason, this.m_20183_(), level.m_213780_());
    }

    public static boolean checkHullbackSpawnRules(EntityType<HullbackEntity> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!WaterAnimal.m_218282_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        if (!HullbackEntity.hasSpawnSpace(level, pos)) {
            return false;
        }
        return !HullbackEntity.hasNearbyHullbacks(level, pos);
    }

    private static boolean hasSpawnSpace(LevelAccessor level, BlockPos pos) {
        int checkRadius = 10;
        int heightCheck = 6;
        AABB spawnCheckArea = new AABB(pos).m_82377_((double)checkRadius, (double)heightCheck, (double)checkRadius);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int x = (int)spawnCheckArea.f_82288_;
        while ((double)x <= spawnCheckArea.f_82291_) {
            int y = (int)spawnCheckArea.f_82289_;
            while ((double)y <= spawnCheckArea.f_82292_) {
                int z = (int)spawnCheckArea.f_82290_;
                while ((double)z <= spawnCheckArea.f_82293_) {
                    mutablePos.m_122178_(x, y, z);
                    BlockState state = level.m_8055_((BlockPos)mutablePos);
                    if (state.m_280296_() && state.m_60812_((BlockGetter)level, (BlockPos)mutablePos) != Shapes.m_83040_()) {
                        return false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    private static boolean hasNearbyHullbacks(LevelAccessor level, BlockPos pos) {
        AABB checkArea = new AABB(pos).m_82377_(32.0, 16.0, 32.0);
        return !level.m_6443_(HullbackEntity.class, checkArea, e -> e.m_6084_() && !e.isTamed()).isEmpty();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void initClientDirt() {
        this.headDirt = new BlockState[8][5];
        this.headTopDirt = new BlockState[8][5];
        this.bodyDirt = new BlockState[6][5];
        this.bodyTopDirt = new BlockState[6][5];
        this.tailDirt = new BlockState[4][2];
        this.flukeDirt = new BlockState[3][5];
        for (BlockState[][] array : new BlockState[][][]{this.headDirt, this.headTopDirt, this.bodyDirt, this.bodyTopDirt, this.tailDirt, this.flukeDirt}) {
            for (int x = 0; x < array.length; ++x) {
                for (int y = 0; y < array[x].length; ++y) {
                    array[x][y] = Blocks.f_50016_.m_49966_();
                }
            }
        }
    }

    private void initDirt() {
        this.headDirt = new BlockState[8][5];
        this.headTopDirt = new BlockState[8][5];
        this.bodyDirt = new BlockState[6][5];
        this.bodyTopDirt = new BlockState[6][5];
        this.tailDirt = new BlockState[4][2];
        this.flukeDirt = new BlockState[3][5];
        for (BlockState[][] array : new BlockState[][][]{this.headDirt, this.headTopDirt, this.bodyDirt, this.bodyTopDirt, this.tailDirt, this.flukeDirt}) {
            for (int x = 0; x < array.length; ++x) {
                for (int y = 0; y < array[x].length; ++y) {
                    array[x][y] = Blocks.f_50016_.m_49966_();
                }
            }
        }
        this.fillDirtArray(this.headDirt, true);
        this.fillDirtArray(this.headTopDirt, false);
        this.fillDirtArray(this.bodyDirt, true);
        this.fillDirtArray(this.bodyTopDirt, false);
        this.fillDirtArray(this.tailDirt, true);
        this.fillDirtArray(this.flukeDirt, true);
        this.syncDirtToClients();
    }

    private void fillDirtArray(BlockState[][] array, boolean bottom) {
        if (bottom) {
            for (int x = 0; x < array.length; ++x) {
                for (int y = 0; y < array[x].length; ++y) {
                    array[x][y] = Blocks.f_50016_.m_49966_();
                    if (!(this.f_19796_.m_188500_() < 0.5)) continue;
                    array[x][y] = this.possibleBottomBlocks[this.getWeightedIndex(this.possibleBottomBlocks.length, false)];
                }
            }
        } else {
            for (int x = 0; x < array.length; ++x) {
                for (int y = 0; y < array[x].length; ++y) {
                    array[x][y] = Blocks.f_50016_.m_49966_();
                    if (!(this.f_19796_.m_188500_() < 0.3)) continue;
                    array[x][y] = this.possibleTopBlocks[this.getWeightedIndex(this.possibleTopBlocks.length, false)];
                }
            }
        }
        this.syncDirtToClients();
    }

    public BlockState[][] getDirtArray(int index, boolean bottom) {
        if (bottom) {
            switch (index) {
                case 2: {
                    return this.bodyDirt;
                }
                case 3: {
                    return this.tailDirt;
                }
                case 4: {
                    return this.flukeDirt;
                }
            }
            return this.headDirt;
        }
        if (index == 0) {
            return this.headTopDirt;
        }
        return this.bodyTopDirt;
    }

    public void syncDirtToClients() {
        if (!this.m_9236_().f_46443_) {
            this.syncDirtArray(this.headDirt, 0, true);
            this.syncDirtArray(this.headTopDirt, 1, false);
            this.syncDirtArray(this.bodyDirt, 2, true);
            this.syncDirtArray(this.bodyTopDirt, 3, false);
            this.syncDirtArray(this.tailDirt, 4, true);
            this.syncDirtArray(this.flukeDirt, 5, true);
        }
    }

    public void syncDirtArray(BlockState[][] array, int arrayType, boolean isBottom) {
        if (!this.m_9236_().f_46443_) {
            WhaleborneNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new SyncHullbackDirtPacket(this.m_19879_(), array, arrayType, isBottom));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, (double)1.2f).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected int getInventorySize() {
        return 3;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public void updateContainerEquipment() {
        ItemStack crown = this.inventory.m_8020_(0);
        ItemStack armor = this.inventory.m_8020_(2);
        boolean hasSaddle = !this.inventory.m_8020_(1).m_41619_();
        this.f_19804_.m_135381_(DATA_CROWN_ID, (Object)crown);
        this.f_19804_.m_135381_(DATA_ARMOR, (Object)armor);
        this.sendHurtSyncPacket();
        this.setFlag(4, hasSaddle);
    }

    public void m_5757_(Container invBasic) {
        ItemStack itemstack = this.getArmor();
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        ItemStack itemstack1 = this.getArmor();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
        if (this.f_19797_ > 20 && itemstack != itemstack1) {
            this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
        }
    }

    public void m_20321_(boolean downwards) {
    }

    public ItemStack getArmor() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ARMOR);
    }

    public ItemStack getCrown() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_CROWN_ID);
    }

    public boolean isTamed() {
        return this.getFlag(2);
    }

    public void setTamed(boolean tamed) {
        this.m_21530_();
        this.setFlag(2, tamed);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean m_6741_() {
        return this.m_6084_() && this.isTamed();
    }

    public void m_5853_(@Nullable SoundSource source) {
        this.inventory.m_6836_(1, new ItemStack((ItemLike)Items.f_42450_));
    }

    public boolean m_6254_() {
        return this.getFlag(4);
    }

    protected boolean getFlag(int flagId) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & flagId) != 0;
    }

    protected void setFlag(int flagId, boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | flagId)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~flagId)));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_SEAT_0, Optional.empty());
        this.f_19804_.m_135372_(DATA_SEAT_1, Optional.empty());
        this.f_19804_.m_135372_(DATA_SEAT_2, Optional.empty());
        this.f_19804_.m_135372_(DATA_SEAT_3, Optional.empty());
        this.f_19804_.m_135372_(DATA_SEAT_4, Optional.empty());
        this.f_19804_.m_135372_(DATA_SEAT_5, Optional.empty());
        this.f_19804_.m_135372_(DATA_SEAT_6, Optional.empty());
        this.f_19804_.m_135372_(DATA_CROWN_ID, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_ARMOR, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_MOUTH_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        compound.m_128365_("Items", (Tag)listtag);
        compound.m_128344_("Flags", ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS)).byteValue());
        CompoundTag hasMobiusSpawned = new CompoundTag();
        hasMobiusSpawned.m_128379_("HasMobiusSpawned", HAS_MOBIUS_SPAWNED);
        for (int i = 0; i < 7; ++i) {
            Optional occupant = (Optional)this.f_19804_.m_135370_(this.getSeatAccessor(i));
            String seatKey = "Seat_" + i;
            if (!occupant.isPresent()) continue;
            compound.m_128362_(seatKey, (UUID)occupant.get());
        }
        compound.m_128365_("HeadDirt", (Tag)this.saveDirtArray(this.headDirt));
        compound.m_128365_("HeadTopDirt", (Tag)this.saveDirtArray(this.headTopDirt));
        compound.m_128365_("BodyDirt", (Tag)this.saveDirtArray(this.bodyDirt));
        compound.m_128365_("BodyTopDirt", (Tag)this.saveDirtArray(this.bodyTopDirt));
        compound.m_128365_("tailDirt", (Tag)this.saveDirtArray(this.tailDirt));
        compound.m_128365_("flukeDirt", (Tag)this.saveDirtArray(this.flukeDirt));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ListTag items = compound.m_128437_("Items", 10);
        for (int i2 = 0; i2 < items.size(); ++i2) {
            CompoundTag itemTag = items.m_128728_(i2);
            int slot = itemTag.m_128445_("Slot") & 0xFF;
            if (slot >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
        this.createInventory();
        this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)compound.m_128445_("Flags"));
        HAS_MOBIUS_SPAWNED = compound.m_128471_("HasMobiusSpawned");
        boolean hasAnySeatData = IntStream.range(0, 7).anyMatch(i -> compound.m_128403_("Seat_" + i));
        for (int i3 = 0; i3 < 7; ++i3) {
            String seatKey = "Seat_" + i3;
            if (compound.m_128403_(seatKey)) {
                UUID uuid = compound.m_128342_(seatKey);
                this.f_19804_.m_135381_(this.getSeatAccessor(i3), Optional.of(uuid));
                continue;
            }
            this.f_19804_.m_135381_(this.getSeatAccessor(i3), Optional.empty());
        }
        if (compound.m_128441_("HeadDirt")) {
            this.headDirt = this.loadDirtArray(compound.m_128469_("HeadDirt"));
        }
        if (compound.m_128441_("HeadTopDirt")) {
            this.headTopDirt = this.loadDirtArray(compound.m_128469_("HeadTopDirt"));
        }
        if (compound.m_128441_("BodyDirt")) {
            this.bodyDirt = this.loadDirtArray(compound.m_128469_("BodyDirt"));
        }
        if (compound.m_128441_("BodyTopDirt")) {
            this.bodyTopDirt = this.loadDirtArray(compound.m_128469_("BodyTopDirt"));
        }
        if (compound.m_128441_("TailDirt")) {
            this.tailDirt = this.loadDirtArray(compound.m_128469_("TailDirt"));
        }
        if (compound.m_128441_("FlukeDirt")) {
            this.flukeDirt = this.loadDirtArray(compound.m_128469_("FlukeDirt"));
        }
        this.syncDirtToClients();
        this.updateContainerEquipment();
    }

    private EntityDataAccessor<Optional<UUID>> getSeatAccessor(int seatIndex) {
        return switch (seatIndex) {
            case 0 -> DATA_SEAT_0;
            case 1 -> DATA_SEAT_1;
            case 2 -> DATA_SEAT_2;
            case 3 -> DATA_SEAT_3;
            case 4 -> DATA_SEAT_4;
            case 5 -> DATA_SEAT_5;
            default -> DATA_SEAT_6;
        };
    }

    private CompoundTag saveDirtArray(BlockState[][] array) {
        CompoundTag tag = new CompoundTag();
        for (int x = 0; x < array.length; ++x) {
            ListTag column = new ListTag();
            for (int y = 0; y < array[x].length; ++y) {
                column.add((Object)NbtUtils.m_129202_((BlockState)array[x][y]));
            }
            tag.m_128365_("x" + x, (Tag)column);
        }
        return tag;
    }

    private BlockState[][] loadDirtArray(CompoundTag tag) {
        BlockState[][] array = new BlockState[tag.m_128440_()][];
        for (int x = 0; x < array.length; ++x) {
            String key = "x" + x;
            if (!tag.m_128441_(key)) continue;
            ListTag column = tag.m_128437_(key, 10);
            array[x] = new BlockState[column.size()];
            for (int y = 0; y < column.size(); ++y) {
                array[x][y] = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)column.m_128728_(y));
            }
        }
        return array;
    }

    public float getArmorProgress() {
        return (float)((ItemStack)this.f_19804_.m_135370_(DATA_ARMOR)).m_41613_() / 64.0f;
    }

    public float getLeftEyeYaw() {
        return this.leftEyeYaw;
    }

    public float getRightEyeYaw() {
        return this.rightEyeYaw;
    }

    public float getEyePitch() {
        return this.eyePitch;
    }

    public boolean m_6040_() {
        return this.m_20160_();
    }

    protected void m_6229_(int airSupply) {
    }

    public int m_6062_() {
        return 10000;
    }

    protected int m_7305_(int currentAir) {
        return this.m_6062_();
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    public HullbackPartEntity[] getSubEntities() {
        return this.subEntities;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
    }

    private boolean scanPlayerAbove() {
        for (HullbackPartEntity part : this.getSubEntities()) {
            AABB box = part.m_20191_();
            AABB topSurface = new AABB(box.f_82288_, box.f_82292_, box.f_82290_, box.f_82291_, box.f_82292_ + 2.0, box.f_82293_);
            List entities = this.m_9236_().m_6443_(Entity.class, topSurface, entity -> entity instanceof Player && !entity.m_5833_() && !entity.m_20159_());
            if (entities.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void m_8032_() {
        if ((double)this.f_19796_.m_188501_() < 0.5) {
            return;
        }
        this.mouthTarget = 0.2f;
        for (int side : new int[]{-1, 1}) {
            Vec3 particlePos = this.partPosition[1].m_82549_(new Vec3(3.5 * (double)side, 2.0, 0.0).m_82524_(-this.partYRot[1]));
            double x = particlePos.f_82479_;
            double y = particlePos.f_82480_;
            double z = particlePos.f_82481_;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WBParticleRegistry.SMOKE.get()), x, y, z, 20, 0.2, 0.2, 0.2, 0.02);
        }
        this.m_5496_(WBSoundRegistry.HULLBACK_AMBIENT.get(), 3.0f, 1.0f);
    }

    protected void m_5625_(float volume) {
        super.m_5625_(2.0f);
    }

    protected SoundEvent m_5501_() {
        return WBSoundRegistry.HULLBACK_SWIM.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return WBSoundRegistry.HULLBACK_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return WBSoundRegistry.HULLBACK_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return WBSoundRegistry.HULLBACK_AMBIENT.get();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HullbackBreathAirGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HullbackTryFindWaterGoal((PathfinderMob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new HullbackTryFindWaterGoal((PathfinderMob)this, false));
        this.f_21345_.m_25352_(2, (Goal)new HullbackRandomSwimGoal(this, 1.0, 10));
        this.f_21345_.m_25352_(0, (Goal)new HullbackApproachPlayerGoal(this, 0.01f));
        this.f_21345_.m_25352_(0, (Goal)new HullbackArmorPlayerGoal(this, 0.005f));
        this.f_21345_.m_25352_(3, (Goal)new FollowBoatGoal((PathfinderMob)this));
    }

    public void moveEntitiesOnTop(int index) {
        HullbackPartEntity part = this.getSubEntities()[index];
        Vec3 offset = this.partPosition[index].m_82546_(this.oldPartPosition[index]);
        if (offset.m_82553_() <= 0.0) {
            return;
        }
        for (Entity entity2 : this.m_9236_().m_6249_((Entity)part, part.m_20191_().m_82377_(0.0, (double)0.01f, 0.0), EntitySelector.f_20408_.and(entity -> !entity.m_20159_()))) {
            double gravity;
            if (entity2.f_19794_ || entity2 instanceof HullbackPartEntity || entity2 instanceof HullbackEntity || entity2 instanceof HullbackWalkableEntity) continue;
            double d = gravity = entity2.m_20068_() ? 0.0 : 0.08;
            if (entity2 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                AttributeInstance attribute = living.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                gravity = attribute.m_22135_();
            }
            float f2 = 1.0f;
            entity2.m_6478_(MoverType.SHULKER, new Vec3((double)(f2 * (float)offset.f_82479_), (double)(f2 * (float)offset.f_82480_), (double)(f2 * (float)offset.f_82481_)));
            entity2.f_19864_ = true;
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_20160_()) {
            return super.m_6071_(player, hand);
        }
        return super.m_6071_(player, hand);
    }

    public InteractionResult interactDebug(Player player, InteractionHand hand) {
        if (!this.isTamed()) {
            this.setTamed(true);
            this.m_21530_();
            return InteractionResult.SUCCESS;
        }
        System.out.println(this.m_9236_() + ": Seat Data: ");
        for (int i = 0; i < 7; ++i) {
            System.out.println("Seat " + i + ": " + this.f_19804_.m_135370_(this.getSeatAccessor(i)));
        }
        System.out.println(this.m_20197_());
        return InteractionResult.SUCCESS;
    }

    public InteractionResult interactRide(Player player, InteractionHand hand, int seatIndex, @Nullable EntityType<?> entityType) {
        if (seatIndex < 0 || seatIndex >= 7) {
            return InteractionResult.FAIL;
        }
        if ((double)this.getArmorProgress() < 0.5) {
            return InteractionResult.FAIL;
        }
        if (!this.m_6254_()) {
            this.mouthTarget = 1.0f;
            this.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
            return InteractionResult.PASS;
        }
        Optional currentSeatOccupant = (Optional)this.f_19804_.m_135370_(this.getSeatAccessor(seatIndex));
        if (currentSeatOccupant.isPresent()) {
            if (((UUID)currentSeatOccupant.get()).equals(player.m_20148_())) {
                return InteractionResult.PASS;
            }
            return InteractionResult.FAIL;
        }
        if (entityType != null) {
            return this.placeEquipment(player, hand, seatIndex, entityType);
        }
        return this.mountPlayer(player, seatIndex);
    }

    private InteractionResult placeEquipment(Player player, InteractionHand hand, int seatIndex, EntityType<?> entityType) {
        Entity entity = entityType.m_20615_(this.m_9236_());
        if (entity == null) {
            return InteractionResult.FAIL;
        }
        Vec3 seatPos = this.seats[seatIndex];
        entity.m_7678_(seatPos.f_82479_, seatPos.f_82480_ + 1.0, seatPos.f_82481_, this.m_146908_(), 0.0f);
        this.m_9236_().m_7967_(entity);
        if (entity.m_7998_((Entity)this, true)) {
            this.assignSeat(seatIndex, entity);
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult mountPlayer(Player player, int seatIndex) {
        for (int i = 0; i < 7; ++i) {
            Optional occupant = (Optional)this.f_19804_.m_135370_(this.getSeatAccessor(i));
            if (!occupant.isPresent() || !((UUID)occupant.get()).equals(player.m_20148_())) continue;
            player.m_8127_();
        }
        if (player.m_7998_((Entity)this, true)) {
            this.assignSeat(seatIndex, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResult interactClean(Player player, InteractionHand hand, HullbackPartEntity part, Boolean top) {
        ItemStack heldItem = player.m_21120_(hand);
        this.mouthTarget = 0.2f;
        if (this.handleVegetationRemoval(player, hand, part, top, heldItem.m_41720_() instanceof ShearsItem) == InteractionResult.PASS) {
            BlockState[][] object = this.headTopDirt;
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                BlockState[] states;
                for (BlockState state : states = object[i]) {
                    if (state == Blocks.f_50016_.m_49966_()) continue;
                    this.mouthTarget = 0.5f;
                    this.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
                    return InteractionResult.SUCCESS;
                }
            }
            for (BlockState[] blockStates : this.bodyTopDirt) {
                for (BlockState blockState : blockStates) {
                    if (blockState == Blocks.f_50016_.m_49966_()) continue;
                    this.mouthTarget = 0.5f;
                    this.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
                    return InteractionResult.SUCCESS;
                }
            }
            this.setTamed(true);
            this.m_21530_();
            this.mouthTarget = 0.1f;
            this.m_216990_(WBSoundRegistry.HULLBACK_HAPPY.get());
            for (int side : new int[]{-1, 1}) {
                Vec3 particlePos = this.partPosition[1].m_82549_(new Vec3((double)(4 * side), 2.0, 0.0).m_82524_(this.partYRot[1]));
                double x = particlePos.f_82479_;
                double y = particlePos.f_82480_;
                double z = particlePos.f_82481_;
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, x, y, z, 10, 0.5, 0.5, 0.5, 0.02);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult interactArmor(Player player, InteractionHand hand, HullbackPartEntity part, Boolean top) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() instanceof SaddleItem) {
            if (!this.m_6254_()) {
                if (this.isTamed()) {
                    this.m_5853_(SoundSource.PLAYERS);
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12034_, SoundSource.PLAYERS, 1.0f, 0.1f);
                    return InteractionResult.SUCCESS;
                }
                this.mouthTarget = 0.3f;
                this.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
                return InteractionResult.PASS;
            }
            return InteractionResult.PASS;
        }
        if (heldItem.m_204117_(WBTagRegistry.HULLBACK_EQUIPPABLE)) {
            if (!this.m_6254_()) {
                this.mouthTarget = 0.3f;
                this.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
                return InteractionResult.PASS;
            }
            ItemStack currentArmor = this.inventory.m_8020_(2);
            if (currentArmor.m_41613_() == currentArmor.m_41741_()) {
                this.mouthTarget = 0.3f;
                this.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
                return InteractionResult.PASS;
            }
            if (currentArmor.m_41613_() < currentArmor.m_41741_()) {
                if (currentArmor.m_41619_()) {
                    ItemStack newArmor = new ItemStack((ItemLike)heldItem.m_41720_(), 1);
                    this.inventory.m_6836_(2, newArmor);
                    this.updateContainerEquipment();
                } else if (heldItem.m_41720_() == currentArmor.m_41720_()) {
                    if (player.m_7500_()) {
                        currentArmor.m_41764_(64);
                    } else {
                        currentArmor.m_41769_(1);
                    }
                    this.f_19804_.m_135381_(DATA_ARMOR, (Object)currentArmor.m_41777_());
                } else {
                    this.mouthTarget = 0.3f;
                    this.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
                    return InteractionResult.PASS;
                }
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12635_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12016_, SoundSource.PLAYERS, 1.0f, 0.5f + (float)currentArmor.m_41613_() / 64.0f);
                if (currentArmor.m_41613_() == 64) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12601_, SoundSource.PLAYERS, 2.0f, 1.0f);
                    this.m_216990_(WBSoundRegistry.HULLBACK_TAME.get());
                }
                this.updateContainerEquipment();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleVegetationRemoval(Player player, InteractionHand hand, HullbackPartEntity part, boolean top, boolean isShears) {
        BlockState[][] dirtArray = this.getDirtArrayForPart(part, top);
        for (int x = 0; x < dirtArray.length; ++x) {
            for (int y = 0; y < dirtArray[x].length; ++y) {
                if (!this.isRemovableVegetation(dirtArray[x][y], isShears)) continue;
                BlockState removedState = dirtArray[x][y];
                if (!this.m_9236_().f_46443_) {
                    dirtArray[x][y] = Blocks.f_50016_.m_49966_();
                    ItemStack drop = this.getDropForBlock(removedState);
                    if (!drop.m_41619_()) {
                        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), part.m_20185_() + (double)y - (double)(part.getSize().f_20377_ / 2.0f), part.m_20186_() + (double)(top ? part.getSize().f_20378_ + 0.5f : -0.5f), part.m_20189_() - (double)x + (double)(part.getSize().f_20377_ / 2.0f), drop);
                        this.m_9236_().m_7967_((Entity)itemEntity);
                    }
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    }
                    this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), isShears ? SoundEvents.f_12344_ : SoundEvents.f_11688_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.mouthTarget = 1.0f;
                    this.syncDirtToClients();
                    return InteractionResult.SUCCESS;
                }
                dirtArray[x][y] = Blocks.f_50016_.m_49966_();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private BlockState[][] getDirtArrayForPart(HullbackPartEntity part, boolean top) {
        if (part == this.head) {
            return top ? this.headTopDirt : this.headDirt;
        }
        if (part == this.body) {
            return top ? this.bodyTopDirt : this.bodyDirt;
        }
        if (part == this.fluke) {
            return this.flukeDirt;
        }
        if (part == this.nose) {
            return top ? this.headTopDirt : this.headDirt;
        }
        return this.tailDirt;
    }

    private boolean isRemovableVegetation(BlockState state, boolean isShears) {
        Block block = state.m_60734_();
        if (isShears) {
            return block == Blocks.f_50037_ || block == Blocks.f_50038_ || block == Blocks.f_50575_ || block == Blocks.f_50576_ || block == Blocks.f_152543_;
        }
        return block == WBBlockRegistry.WHALE_BARNACLE_0.get() || block == WBBlockRegistry.WHALE_BARNACLE_1.get() || block == WBBlockRegistry.WHALE_BARNACLE_2.get();
    }

    private ItemStack getDropForBlock(BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50037_) {
            return new ItemStack((ItemLike)Items.f_41867_);
        }
        if (block == Blocks.f_50575_) {
            return new ItemStack((ItemLike)Items.f_41910_);
        }
        if (block == Blocks.f_152543_) {
            return new ItemStack((ItemLike)Items.f_151015_);
        }
        if (block == WBBlockRegistry.WHALE_BARNACLE_0.get()) {
            return new ItemStack((ItemLike)WBItemRegistry.ROUGH_BARNACLE.get());
        }
        if (block == WBBlockRegistry.WHALE_BARNACLE_1.get()) {
            return new ItemStack((ItemLike)WBItemRegistry.ROUGH_BARNACLE.get(), 2);
        }
        if (block == WBBlockRegistry.WHALE_BARNACLE_2.get()) {
            return new ItemStack((ItemLike)WBItemRegistry.ROUGH_BARNACLE.get(), 5);
        }
        if (block == Blocks.f_50576_) {
            return new ItemStack((ItemLike)Items.f_41910_, 2);
        }
        if (block == Blocks.f_50038_) {
            return new ItemStack((ItemLike)Items.f_41867_, 2);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        BlockItem blockItem;
        BlockState defaultState;
        ItemStack armorStack = this.inventory.m_8020_(2);
        ItemStack armorStackClient = (ItemStack)this.f_19804_.m_135370_(DATA_ARMOR);
        float resistance = 1.0f;
        Item item = armorStack.m_41720_();
        if (item instanceof BlockItem && (resistance = (defaultState = (blockItem = (BlockItem)item).m_40614_().m_49966_()).m_60800_(null, null)) < 0.0f) {
            resistance = 50.0f;
        }
        if (!armorStack.m_41619_()) {
            float blockChance = resistance / 70.0f;
            if (this.f_19796_.m_188501_() < blockChance) {
                amount = 0.0f;
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                this.m_5496_(WBSoundRegistry.HULLBACK_HAPPY.get(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                this.updateContainerEquipment();
                return super.m_6469_(source, amount);
            }
            this.mouthTarget = 0.8f;
            int originalCount = armorStack.m_41613_();
            int armorDamage = Math.min(originalCount, (int)Math.ceil(amount));
            armorStack.m_41774_(armorDamage);
            this.inventory.m_6836_(2, armorStack);
            this.f_19804_.m_135381_(DATA_ARMOR, (Object)armorStack);
            this.m_5496_(SoundEvents.f_12018_, 0.8f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            this.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
            float remainingDamage = amount - (float)armorDamage;
            if (remainingDamage > 0.0f) {
                this.updateContainerEquipment();
                return super.m_6469_(source, remainingDamage);
            }
            this.updateContainerEquipment();
            return super.m_6469_(source, remainingDamage);
        }
        this.mouthTarget = 0.0f;
        return super.m_6469_(source, amount);
    }

    private void sendHurtSyncPacket() {
        if (!this.m_9236_().f_46443_) {
            WhaleborneNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new HullbackHurtPacket(this.m_19879_(), this.inventory.m_8020_(2), this.inventory.m_8020_(0), (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS)));
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.updateContainerEquipment();
        this.inventory.m_6836_(2, (ItemStack)this.f_19804_.m_135370_(DATA_ARMOR));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 40 == 0) {
            this.f_19804_.m_135381_(DATA_ARMOR, (Object)this.inventory.m_8020_(2));
        }
        if (this.m_9236_().f_46443_ && this.getArmorProgress() > 0.0f && this.inventory.m_8020_(2).m_41720_().m_5456_() == Items.f_41852_.m_5456_()) {
            this.inventory.m_6836_(2, this.getArmor());
        }
        if (this.stationaryTicks > 0) {
            this.stopMoving();
            --this.stationaryTicks;
        }
        if (this.scanPlayerAbove()) {
            this.stationaryTicks = 5;
        }
        if (this.stationaryTicks == 0) {
            if (this.moving_nose != null) {
                this.moving_nose.m_146870_();
                this.moving_nose = null;
            }
            if (this.moving_head != null) {
                this.moving_head.m_146870_();
                this.moving_head = null;
            }
            if (this.moving_body != null) {
                this.moving_body.m_146870_();
                this.moving_body = null;
            }
        }
        if (!this.isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
            this.mouthTarget = 1.0f;
        }
        if (!this.m_6254_() && !this.m_9236_().f_46443_) {
            if (!this.m_20197_().isEmpty()) {
                this.m_20153_();
            }
        } else if (this.getArmorProgress() < 0.45f && this.getInventory().m_8020_(2).m_41613_() < 64 && !this.m_9236_().f_46443_) {
            this.m_20153_();
        }
        this.setOldPosAndRots();
        this.updatePartPositions();
        this.rotatePassengers();
        if (this.getSubEntities()[1].isEyeInFluidType(Fluids.f_76193_.getFluidType()) && this.f_19797_ % 80 == 0) {
            this.m_5634_(0.25f);
        }
        if (this.m_20184_().m_82553_() > 0.3) {
            this.mouthTarget = 0.8f;
        }
        this.updateMouthOpening();
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_20900_ != 0.0f) {
                this.m_146922_(Mth.m_14189_((float)0.8f, (float)this.m_146908_(), (float)(this.m_146908_() - player.f_20900_)));
            }
        }
        if (this.f_19797_ % 80 == 0) {
            this.mouthTarget = 0.0f;
        }
        if (this.f_19797_ % 20 == 0) {
            this.validateAssignments();
        }
        if (this.f_19797_ == 10) {
            this.syncDirtToClients();
        }
        this.f_20885_ = this.f_20883_ + (this.partYRot[0] - this.partYRot[4]) * 1.5f;
        if (this.isTamed() && this.partPosition != null && this.partYRot != null && this.partXRot != null) {
            this.seats[0] = this.partPosition[0].m_82549_(this.seatOffsets[0].m_82496_(this.partXRot[1] * ((float)Math.PI / 180)).m_82524_(-this.partYRot[1] * ((float)Math.PI / 180)));
            this.seats[1] = this.partPosition[0].m_82549_(this.seatOffsets[1].m_82496_(this.partXRot[1] * ((float)Math.PI / 180)).m_82524_(-this.partYRot[1] * ((float)Math.PI / 180)));
            this.seats[2] = this.partPosition[2].m_82549_(this.seatOffsets[2].m_82496_(this.partXRot[2] * ((float)Math.PI / 180)).m_82524_(-this.partYRot[2] * ((float)Math.PI / 180)));
            this.seats[3] = this.partPosition[2].m_82549_(this.seatOffsets[3].m_82496_(this.partXRot[2] * ((float)Math.PI / 180)).m_82524_(-this.partYRot[2] * ((float)Math.PI / 180)));
            this.seats[4] = this.partPosition[2].m_82549_(this.seatOffsets[4].m_82496_(this.partXRot[2] * ((float)Math.PI / 180)).m_82524_(-this.partYRot[2] * ((float)Math.PI / 180)));
            this.seats[5] = this.partPosition[2].m_82549_(this.seatOffsets[5].m_82496_(this.partXRot[2] * ((float)Math.PI / 180)).m_82524_(-this.partYRot[2] * ((float)Math.PI / 180)));
            this.seats[6] = this.partPosition[4].m_82549_(this.seatOffsets[6].m_82496_(this.partXRot[4] * ((float)Math.PI / 180)).m_82524_(-this.partYRot[4] * ((float)Math.PI / 180)));
            this.oldSeats[0] = this.oldPartPosition[0].m_82549_(this.seatOffsets[0].m_82496_(this.oldPartXRot[1] * ((float)Math.PI / 180)).m_82524_(-this.oldPartYRot[1] * ((float)Math.PI / 180)));
            this.oldSeats[1] = this.oldPartPosition[0].m_82549_(this.seatOffsets[1].m_82496_(this.oldPartXRot[1] * ((float)Math.PI / 180)).m_82524_(-this.oldPartYRot[1] * ((float)Math.PI / 180)));
            this.oldSeats[2] = this.oldPartPosition[2].m_82549_(this.seatOffsets[2].m_82496_(this.oldPartXRot[2] * ((float)Math.PI / 180)).m_82524_(-this.oldPartYRot[2] * ((float)Math.PI / 180)));
            this.oldSeats[3] = this.oldPartPosition[2].m_82549_(this.seatOffsets[3].m_82496_(this.oldPartXRot[2] * ((float)Math.PI / 180)).m_82524_(-this.oldPartYRot[2] * ((float)Math.PI / 180)));
            this.oldSeats[4] = this.oldPartPosition[2].m_82549_(this.seatOffsets[4].m_82496_(this.oldPartXRot[2] * ((float)Math.PI / 180)).m_82524_(-this.oldPartYRot[2] * ((float)Math.PI / 180)));
            this.oldSeats[5] = this.oldPartPosition[2].m_82549_(this.seatOffsets[5].m_82496_(this.oldPartXRot[2] * ((float)Math.PI / 180)).m_82524_(-this.oldPartYRot[2] * ((float)Math.PI / 180)));
            this.oldSeats[6] = this.oldPartPosition[4].m_82549_(this.seatOffsets[6].m_82496_(this.oldPartXRot[4] * ((float)Math.PI / 180)).m_82524_(-this.oldPartYRot[4] * ((float)Math.PI / 180)));
        }
        if (!this.m_9236_().f_46443_) {
            this.randomTickDirt(this.headDirt, true);
            this.randomTickDirt(this.bodyDirt, true);
            this.randomTickDirt(this.tailDirt, true);
            this.randomTickDirt(this.flukeDirt, true);
            if (!this.isTamed()) {
                this.randomTickDirt(this.headTopDirt, false);
                this.randomTickDirt(this.bodyTopDirt, false);
            } else {
                int x;
                for (x = 0; x < this.headTopDirt.length; ++x) {
                    for (int y = 0; y < this.headTopDirt[x].length; ++y) {
                        this.headTopDirt[x][y] = Blocks.f_50016_.m_49966_();
                    }
                }
                for (x = 0; x < this.bodyTopDirt.length; ++x) {
                    for (int y = 0; y < this.bodyTopDirt[x].length; ++y) {
                        this.bodyTopDirt[x][y] = Blocks.f_50016_.m_49966_();
                    }
                }
            }
        }
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_8119_();
            if (i != 2 && i != 4) continue;
            float offset = 0.0f;
            if (!this.m_9236_().f_46443_ || !this.m_20069_() || !(this.m_20184_().m_82553_() > 0.03)) continue;
            for (int side : new int[]{-1, 1}) {
                if (i == 2) {
                    offset = 4.0f;
                }
                Vec3 particlePos = this.partPosition[i].m_82549_(new Vec3((double)((offset + this.subEntities[i].getSize().f_20377_ / 2.0f) * (float)side), 0.0, (double)(this.subEntities[i].getSize().f_20377_ / 2.0f)).m_82524_(this.partYRot[i]));
                double x = particlePos.f_82479_;
                double y = particlePos.f_82480_;
                double z = particlePos.f_82481_;
                for (int j = 0; j < 4; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 0.0, 0.1, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 0.0, 0.1, 0.0);
                }
            }
        }
    }

    public boolean hasAnchorDown() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof AnchorEntity)) continue;
            AnchorEntity anchor = (AnchorEntity)passenger;
            if (!anchor.isDown()) break;
            return true;
        }
        return false;
    }

    public HullbackWalkableEntity spawnPlatform(int index) {
        HullbackWalkableEntity part = new HullbackWalkableEntity((EntityType)WBEntityRegistry.HULLBACK_PLATFORM.get(), this.m_9236_());
        part.m_6034_(this.getSubEntities()[index].m_20185_(), this.m_20182_().f_82480_ + 4.7, this.getSubEntities()[index].m_20189_());
        if (this.m_9236_().m_7967_((Entity)part)) {
            return part;
        }
        return null;
    }

    public void stopMoving() {
        this.m_21573_().m_26573_();
        if (this.moving_nose == null) {
            this.moving_nose = this.spawnPlatform(0);
        } else if (this.f_19797_ % 5 == 0) {
            // empty if block
        }
        if (this.moving_head == null) {
            this.moving_head = this.spawnPlatform(1);
        } else if (this.f_19797_ % 5 == 0) {
            // empty if block
        }
        if (this.moving_body == null) {
            this.moving_body = this.spawnPlatform(2);
        } else if (this.f_19797_ % 5 == 0) {
            // empty if block
        }
        this.m_6034_(this.f_19854_, this.f_19855_, this.f_19856_);
        this.m_146922_(this.f_19859_);
        this.m_146926_(this.f_19860_);
    }

    private void randomTickDirt(BlockState[][] array, boolean bottom) {
        if (bottom) {
            if (this.f_19796_.m_188503_(30000) <= 10) {
                int y;
                int x = this.getWeightedIndex(array.length, true);
                BlockState currentState = array[x][y = this.getWeightedIndex(array[x].length, true)];
                if (currentState == Blocks.f_50037_.m_49966_()) {
                    array[x][y] = Blocks.f_50038_.m_49966_();
                    this.syncDirtToClients();
                    this.m_216990_(SoundEvents.f_144074_);
                    return;
                }
                if (currentState == Blocks.f_50575_.m_49966_()) {
                    array[x][y] = Blocks.f_50576_.m_49966_();
                    this.syncDirtToClients();
                    this.m_216990_(SoundEvents.f_144074_);
                    return;
                }
                if (currentState == ((Block)WBBlockRegistry.WHALE_BARNACLE_0.get()).m_49966_()) {
                    array[x][y] = ((Block)WBBlockRegistry.WHALE_BARNACLE_1.get()).m_49966_();
                    this.syncDirtToClients();
                    this.m_216990_(SoundEvents.f_144074_);
                    return;
                }
                if (currentState == ((Block)WBBlockRegistry.WHALE_BARNACLE_1.get()).m_49966_()) {
                    array[x][y] = ((Block)WBBlockRegistry.WHALE_BARNACLE_2.get()).m_49966_();
                    this.syncDirtToClients();
                    this.m_216990_(SoundEvents.f_144074_);
                    return;
                }
                if (currentState == Blocks.f_50016_.m_49966_()) {
                    int index = this.getWeightedIndex(this.possibleFreshBlocks.length, false);
                    array[x][y] = this.possibleFreshBlocks[index];
                    this.syncDirtToClients();
                    this.m_216990_(SoundEvents.f_144074_);
                    return;
                }
            }
        } else if (this.f_19796_.m_188503_(30000) <= 5) {
            int y;
            int x = this.getWeightedIndex(array.length, true);
            BlockState currentState = array[x][y = this.getWeightedIndex(array[x].length, true)];
            if (currentState == Blocks.f_50016_.m_49966_()) {
                int index = this.getWeightedIndex(this.possibleTopBlocks.length, false);
                array[x][y] = this.possibleTopBlocks[index];
                this.syncDirtToClients();
                this.m_216990_(SoundEvents.f_144074_);
                return;
            }
            if (currentState == ((Block)WBBlockRegistry.WHALE_BARNACLE_0.get()).m_49966_()) {
                array[x][y] = ((Block)WBBlockRegistry.WHALE_BARNACLE_1.get()).m_49966_();
                this.syncDirtToClients();
                this.m_216990_(SoundEvents.f_144074_);
                return;
            }
            if (currentState == ((Block)WBBlockRegistry.WHALE_BARNACLE_1.get()).m_49966_()) {
                array[x][y] = ((Block)WBBlockRegistry.WHALE_BARNACLE_2.get()).m_49966_();
                this.syncDirtToClients();
                this.m_216990_(SoundEvents.f_144074_);
                return;
            }
        }
    }

    private int getWeightedIndex(int length, boolean higherWeight) {
        double[] weights = new double[length];
        double totalWeight = 0.0;
        for (int i = 0; i < length; ++i) {
            weights[i] = higherWeight ? (double)(i + 1) : (double)(length - i);
            totalWeight += weights[i];
        }
        double randomValue = this.f_19796_.m_188500_() * totalWeight;
        double cumulativeWeight = 0.0;
        for (int i = 0; i < length; ++i) {
            if (!(randomValue <= (cumulativeWeight += weights[i]))) continue;
            return i;
        }
        return length - 1;
    }

    private void updateMouthOpening() {
        this.mouthOpenProgress = (float)Mth.m_14139_((double)0.3, (double)this.mouthOpenProgress, (double)this.mouthTarget);
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_MOUTH_PROGRESS, (Object)Float.valueOf(this.mouthOpenProgress));
        }
    }

    public float getMouthOpenProgress() {
        return ((Float)this.f_19804_.m_135370_(DATA_MOUTH_PROGRESS)).floatValue();
    }

    public Vec3 getPartPos(int i) {
        return this.partPosition[i];
    }

    public float getPartYRot(int i) {
        return this.partYRot[i];
    }

    public float getPartXRot(int i) {
        return this.partXRot[i];
    }

    public Vec3 getOldPartPos(int i) {
        return this.oldPartPosition[i];
    }

    public float getOldPartYRot(int i) {
        return this.oldPartYRot[i];
    }

    public float getOldPartXRot(int i) {
        return this.oldPartXRot[i];
    }

    public void setOldPosAndRots() {
        for (int i = 0; i < 5; ++i) {
            this.oldPartPosition[i] = this.subEntities[i].m_20182_();
            this.oldPartYRot[i] = this.subEntities[i].m_146908_();
            this.oldPartXRot[i] = this.subEntities[i].m_146909_();
        }
    }

    private void updatePartPositions() {
        float[] partDragFactors = new float[]{1.0f, 0.9f, 0.2f, 0.1f, 0.09f};
        Vec3[] baseOffsets = new Vec3[]{new Vec3(0.0, 0.0, 6.0), new Vec3(0.0, 0.0, 2.5), new Vec3(0.0, 0.0, -2.25), new Vec3(0.0, 0.0, -7.0), new Vec3(0.0, 0.0, -11.0)};
        if (this.prevPartPositions[0] == null) {
            for (int i = 0; i < this.prevPartPositions.length; ++i) {
                this.prevPartPositions[i] = this.m_20182_();
            }
        }
        float swimCycle = (float)((double)Mth.m_14031_((float)((float)this.f_19797_ * 0.1f)) * this.m_20184_().m_82553_());
        float yawRad = -this.m_146908_() * ((float)Math.PI / 180);
        float pitchRad = this.m_146909_() * ((float)Math.PI / 180);
        for (int i = 0; i < baseOffsets.length; ++i) {
            baseOffsets[i] = baseOffsets[i].m_82524_(yawRad).m_82496_(pitchRad);
            baseOffsets[i] = new Vec3(this.m_20185_() + baseOffsets[i].f_82479_, this.m_20186_() + baseOffsets[i].f_82480_, this.m_20189_() + baseOffsets[i].f_82481_);
            if (i > 0) {
                baseOffsets[i] = new Vec3(Mth.m_14139_((double)partDragFactors[i], (double)this.prevPartPositions[i].f_82479_, (double)baseOffsets[i].f_82479_), Mth.m_14139_((double)partDragFactors[i], (double)this.prevPartPositions[i].f_82480_, (double)baseOffsets[i].f_82480_), Mth.m_14139_((double)partDragFactors[i], (double)this.prevPartPositions[i].f_82481_, (double)baseOffsets[i].f_82481_));
            }
            this.prevPartPositions[i] = baseOffsets[i];
        }
        this.partPosition[0] = this.prevPartPositions[0];
        this.partYRot[0] = this.calculateYaw(this.prevPartPositions[0], this.prevPartPositions[1]);
        this.partXRot[0] = this.calculatePitch(this.prevPartPositions[0], this.prevPartPositions[1]);
        this.nose.m_7678_(this.prevPartPositions[0].f_82479_, this.prevPartPositions[0].f_82480_, this.prevPartPositions[0].f_82481_, this.partYRot[0], this.partXRot[0]);
        this.partPosition[1] = new Vec3(this.prevPartPositions[1].f_82479_, this.prevPartPositions[1].f_82480_ + (double)(swimCycle * 2.0f), this.prevPartPositions[1].f_82481_);
        this.partYRot[1] = this.calculateYaw(this.prevPartPositions[0], this.prevPartPositions[1]);
        this.partXRot[1] = this.calculatePitch(this.prevPartPositions[0], this.prevPartPositions[1]);
        this.head.m_7678_(this.prevPartPositions[1].f_82479_, this.prevPartPositions[1].f_82480_ + (double)(swimCycle * 2.0f), this.prevPartPositions[1].f_82481_, this.partYRot[1], this.partXRot[1]);
        this.partPosition[2] = new Vec3(this.prevPartPositions[2].f_82479_, this.prevPartPositions[2].f_82480_ + (double)(swimCycle * 2.0f), this.prevPartPositions[2].f_82481_);
        this.partYRot[2] = this.calculateYaw(this.prevPartPositions[1], this.prevPartPositions[2]);
        this.partXRot[2] = this.calculatePitch(this.prevPartPositions[1], this.prevPartPositions[2]);
        this.body.m_7678_(this.prevPartPositions[2].f_82479_, this.prevPartPositions[2].f_82480_ + (double)(swimCycle * 2.0f), this.prevPartPositions[2].f_82481_, this.partYRot[2], this.partXRot[2]);
        this.partPosition[3] = new Vec3(this.prevPartPositions[3].f_82479_, this.prevPartPositions[3].f_82480_ + (double)(swimCycle * 8.0f), this.prevPartPositions[3].f_82481_);
        this.partYRot[3] = this.calculateYaw(this.prevPartPositions[2], this.prevPartPositions[3]);
        this.partXRot[3] = this.calculatePitch(this.prevPartPositions[2], this.prevPartPositions[3]) * 1.5f - swimCycle * 20.0f;
        this.tail.m_7678_(this.prevPartPositions[3].f_82479_, this.prevPartPositions[3].f_82480_ + (double)(swimCycle * 8.0f), this.prevPartPositions[3].f_82481_, this.partYRot[3], this.partXRot[3]);
        float flukeDistance = 4.0f;
        Vec3 flukeOffset = new Vec3(0.0, 0.0, (double)(-flukeDistance)).m_82524_(-this.tail.m_146908_() * ((float)Math.PI / 180)).m_82496_(this.tail.m_146909_() * ((float)Math.PI / 180));
        Vec3 flukeTarget = new Vec3(this.tail.m_20185_() + flukeOffset.f_82479_, this.tail.m_20186_() + flukeOffset.f_82480_ + (double)(swimCycle * 10.0f), this.tail.m_20189_() + flukeOffset.f_82481_);
        float flukeYaw = this.calculateYaw(this.tail.m_20182_(), flukeTarget);
        float flukePitch = this.calculatePitch(this.tail.m_20182_(), flukeTarget);
        flukeYaw = Mth.m_14189_((float)partDragFactors[4], (float)this.oldPartYRot[4], (float)flukeYaw);
        this.partPosition[4] = flukeTarget;
        this.partYRot[4] = flukeYaw;
        this.partXRot[4] = flukePitch * 1.5f + swimCycle * 30.0f;
        this.fluke.m_7678_(flukeTarget.f_82479_, flukeTarget.f_82480_, flukeTarget.f_82481_, flukeYaw, flukePitch * 1.5f + swimCycle * 30.0f);
    }

    private float calculateYaw(Vec3 from, Vec3 to) {
        double dx = to.f_82479_ - from.f_82479_;
        double dz = to.f_82481_ - from.f_82481_;
        return (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) + 90.0f;
    }

    private float calculatePitch(Vec3 from, Vec3 to) {
        double dx = to.f_82479_ - from.f_82479_;
        double dy = to.f_82480_ - from.f_82480_;
        double dz = to.f_82481_ - from.f_82481_;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        return -((float)(Mth.m_14136_((double)dy, (double)horizontalDistance) * 57.29577951308232));
    }

    protected BodyRotationControl m_7560_() {
        return new HullbackBodyRotationControl(this);
    }

    public void m_7888_(int i) {
    }

    public boolean m_7132_() {
        return true;
    }

    public void m_7199_(int i) {
    }

    public void m_8012_() {
    }

    public boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < 7;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        int seatIndex = this.getSeatByEntity(passenger);
        if (seatIndex == -1) {
            return;
        }
        float yOffset = 0.0f;
        if (this.getArmorProgress() == 0.0f) {
            yOffset = 0.5f;
        }
        if (seatIndex < this.seats.length && this.seats[seatIndex] != null) {
            callback.m_20372_(passenger, this.seats[seatIndex].f_82479_, this.seats[seatIndex].f_82480_ - (double)yOffset + passenger.m_6049_(), this.seats[seatIndex].f_82481_);
        }
    }

    private void updateModifiers() {
        double speedModifier = 0.0;
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof SailEntity)) continue;
            SailEntity sail = (SailEntity)passenger;
            speedModifier += (double)sail.getSpeedModifier();
        }
        AttributeInstance inst = this.m_21051_(HullbackEntity.getSwimSpeed());
        if (inst != null) {
            AttributeModifier old = inst.m_22111_(SAIL_SPEED_MODIFIER_UUID);
            if (old != null) {
                inst.m_22130_(old);
            }
            if (speedModifier != 0.0) {
                inst.m_22125_(new AttributeModifier(SAIL_SPEED_MODIFIER_UUID, "whaleborne:sail_speed_modifier", speedModifier, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public static Attribute getSwimSpeed() {
        return ForgeMod.SWIM_SPEED.isPresent() ? (Attribute)ForgeMod.SWIM_SPEED.get() : Attributes.f_22279_;
    }

    public int getSeatByEntity(Entity entity) {
        if (entity != null) {
            for (int seatIndex = 0; seatIndex < 7; ++seatIndex) {
                Optional seatOccupant = (Optional)this.f_19804_.m_135370_(this.getSeatAccessor(seatIndex));
                if (!seatOccupant.isPresent() || !((UUID)seatOccupant.get()).equals(entity.m_20148_())) continue;
                return seatIndex;
            }
        }
        return -1;
    }

    private void validateAssignments() {
        Set currentPassengerUUIDs = this.m_20197_().stream().map(Entity::m_20148_).collect(Collectors.toSet());
        this.updateModifiers();
        for (int seatIndex = 0; seatIndex < 7; ++seatIndex) {
            EntityDataAccessor<Optional<UUID>> seatAccessor = this.getSeatAccessor(seatIndex);
            Optional assignedUUID = (Optional)this.f_19804_.m_135370_(seatAccessor);
            if (!assignedUUID.isPresent()) continue;
            UUID uuid = (UUID)assignedUUID.get();
            if (!currentPassengerUUIDs.contains(uuid)) {
                this.f_19804_.m_135381_(seatAccessor, Optional.empty());
                continue;
            }
            Entity passenger = this.getEntityByUUID(uuid);
            if (passenger == null || this.getSeatByEntity(passenger) == seatIndex) continue;
            this.f_19804_.m_135381_(seatAccessor, Optional.empty());
        }
    }

    public void assignSeat(int seatIndex, @Nullable Entity passenger) {
        this.f_19804_.m_135381_(this.getSeatAccessor(seatIndex), Optional.of(passenger.m_20148_()));
        if (this.m_9236_() instanceof ServerLevel) {
            PacketDistributor.TRACKING_ENTITY.with(() -> this).send((Packet)new ClientboundSetPassengersPacket((Entity)this));
        }
    }

    public Optional<Entity> getPassengerForSeat(int seatIndex) {
        if (seatIndex < 0 || seatIndex >= 7) {
            return Optional.empty();
        }
        return ((Optional)this.f_19804_.m_135370_(this.getSeatAccessor(seatIndex))).flatMap(uuid -> this.m_20197_().stream().filter(p -> p.m_20148_().equals(uuid)).findFirst());
    }

    private boolean isPassengerAssigned(Entity passenger) {
        for (int i = 0; i < 7; ++i) {
            Optional seatUUID = (Optional)this.f_19804_.m_135370_(this.getSeatAccessor(i));
            if (!seatUUID.isPresent() || !((UUID)seatUUID.get()).equals(passenger.m_20148_())) continue;
            return true;
        }
        return false;
    }

    private int findFreeSeat() {
        for (int i = 0; i < 7; ++i) {
            if (!((Optional)this.f_19804_.m_135370_(this.getSeatAccessor(i))).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_9236_() instanceof ServerLevel) {
            PacketDistributor.TRACKING_ENTITY.with(() -> this).send((Packet)new ClientboundSetPassengersPacket((Entity)this));
        }
    }

    protected void m_20351_(Entity passenger) {
        if (passenger instanceof Player) {
            this.stationaryTicks = 100;
        }
        if (passenger.m_213877_()) {
            for (int i = 0; i < 7; ++i) {
                Optional occupant = (Optional)this.f_19804_.m_135370_(this.getSeatAccessor(i));
                if (!occupant.isPresent() || !((UUID)occupant.get()).equals(passenger.m_20148_())) continue;
                this.f_19804_.m_135381_(this.getSeatAccessor(i), Optional.empty());
            }
        }
        super.m_20351_(passenger);
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        int seatIndex = this.getSeatByEntity((Entity)passenger);
        if (seatIndex != -1) {
            for (int i = 0; i < 7; ++i) {
                Optional occupant = (Optional)this.f_19804_.m_135370_(this.getSeatAccessor(i));
                if (!occupant.isPresent() || !((UUID)occupant.get()).equals(passenger.m_20148_())) continue;
                this.f_19804_.m_135381_(this.getSeatAccessor(i), Optional.empty());
            }
            if (seatIndex >= 0 && seatIndex < this.seats.length) {
                Vec3 seatPos = this.seats[seatIndex];
                return new Vec3(seatPos.f_82479_, seatPos.f_82480_, seatPos.f_82481_);
            }
        }
        return super.m_7688_(passenger);
    }

    public void rotatePassengers() {
        for (Entity passenger : this.m_20197_()) {
            CannonEntity cannonEntity;
            int partIndex;
            int seat = this.getSeatByEntity(passenger);
            float offset = 0.0f;
            if (seat == 0 || seat == 1) {
                partIndex = 0;
            } else if (seat == 2 || seat == 4) {
                partIndex = 2;
                offset = -1.0f;
            } else if (seat == 3 || seat == 5) {
                partIndex = 2;
                offset = 1.0f;
            } else {
                if (seat != 6) continue;
                partIndex = 4;
            }
            if (passenger instanceof Player || passenger instanceof CannonEntity && (cannonEntity = (CannonEntity)passenger).m_20160_()) continue;
            if (passenger instanceof SailEntity) {
                passenger.f_19859_ = Mth.m_14189_((float)((float)(0.05 + 0.1 * (double)partIndex)), (float)passenger.m_146908_(), (float)this.oldPartYRot[partIndex]) + offset;
                passenger.f_19860_ = Mth.m_14189_((float)((float)(0.05 + 0.1 * (double)partIndex)), (float)passenger.m_146909_(), (float)this.oldPartXRot[partIndex]);
                passenger.m_146922_(Mth.m_14189_((float)((float)(0.05 + 0.1 * (double)partIndex)), (float)passenger.m_146908_(), (float)this.partYRot[partIndex]) + offset);
                passenger.m_146926_(Mth.m_14189_((float)((float)(0.05 + 0.1 * (double)partIndex)), (float)passenger.m_146909_(), (float)this.partXRot[partIndex]));
                continue;
            }
            passenger.f_19859_ = this.oldPartYRot[partIndex];
            passenger.f_19860_ = this.oldPartXRot[partIndex];
            passenger.m_146922_(this.partYRot[partIndex] + offset);
            passenger.m_146926_(this.partXRot[partIndex]);
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        for (int i = 0; i < 7; ++i) {
            HelmEntity helm;
            LivingEntity controller;
            Entity entity;
            Optional seatOccupant = (Optional)this.f_19804_.m_135370_(this.getSeatAccessor(i));
            if (!seatOccupant.isPresent() || !((entity = this.getEntityByUUID((UUID)seatOccupant.get())) instanceof HelmEntity) || (controller = (helm = (HelmEntity)entity).m_6688_()) == null) continue;
            return controller;
        }
        return null;
    }

    public Entity getEntityByUUID(UUID uuid) {
        for (Entity entity : this.m_20197_()) {
            if (!entity.m_20148_().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    private void syncMovement() {
        if (!this.m_9236_().f_46443_) {
            PacketDistributor.TRACKING_ENTITY.with(() -> this).send((Packet)new ClientboundSetEntityMotionPacket(this.m_19879_(), this.m_20184_()));
        }
    }

    protected Vec3 m_274312_(Player player, Vec3 travelVector) {
        Entity entity;
        if (Mth.m_14154_((float)player.f_20900_) > 0.0f) {
            if (this.hasAnchorDown()) {
                if (this.f_19797_ % 10 == 0) {
                    this.m_216990_(SoundEvents.f_12634_);
                }
                return Vec3.f_82478_;
            }
            if (this.f_19797_ % 2 == 0) {
                this.m_216990_(SoundEvents.f_12632_);
            }
            if (this.m_6688_().m_20202_() != null && (entity = this.m_6688_().m_20202_()) instanceof HelmEntity) {
                HelmEntity helmEntity = (HelmEntity)entity;
                helmEntity.setWheelRotation(helmEntity.getWheelRotation() + player.f_20900_ / 10.0f);
            }
        } else if (this.m_6688_().m_20202_() != null && (entity = this.m_6688_().m_20202_()) instanceof HelmEntity) {
            HelmEntity helmEntity = (HelmEntity)entity;
            helmEntity.setPrevWheelRotation(helmEntity.getWheelRotation());
        }
        float f = player.f_20900_ * 0.5f;
        float f1 = player.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        float f3 = 0.0f;
        if (this.nose.isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
            f3 = 1.0f;
        }
        return new Vec3(0.0, (double)f3, (double)f1);
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public void m_213583_(Player player) {
        this.openHullbackMenu(player);
    }

    private void openHullbackMenu(Player player) {
        ServerPlayer serverPlayer;
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_20201_() instanceof HullbackEntity) {
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return HullbackEntity.this.m_5446_();
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new HullbackMenu(windowId, playerInventory, HullbackEntity.this);
                }
            }, buf -> buf.writeInt(this.m_19879_()));
        }
    }

    public class HullbackBreathAirGoal
    extends Goal {
        private static final int BREACH_HEIGHT = 5;
        private static final float BREACH_SPEED = 1.2f;
        private static final float ROTATION_SPEED = 10.0f;
        private final HullbackEntity hullback;
        private int breachCooldown = 0;
        private boolean isBreaching = false;
        private Vec3 initialPos;

        public HullbackBreathAirGoal(HullbackEntity hullback) {
            this.hullback = hullback;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.breachCooldown > 0) {
                --this.breachCooldown;
                return false;
            }
            return (double)this.hullback.m_20146_() < (double)this.hullback.m_6062_() * 0.2;
        }

        public boolean m_8045_() {
            return this.hullback.m_20146_() < this.hullback.m_6062_() || !this.hullback.m_20069_();
        }

        public void m_8056_() {
            this.isBreaching = true;
            this.initialPos = this.hullback.m_20182_();
            this.hullback.m_21573_().m_26573_();
            int surfaceY = this.hullback.m_9236_().m_5736_();
            Vec3 breachTarget = new Vec3(this.hullback.m_20185_(), (double)(surfaceY + 5), this.hullback.m_20189_());
            this.hullback.m_21566_().m_6849_(breachTarget.f_82479_, breachTarget.f_82480_, breachTarget.f_82481_, (double)1.2f);
        }

        public void m_8037_() {
            super.m_8037_();
            float targetXRot = -60.0f;
            this.hullback.m_146926_(Mth.m_14189_((float)1.0f, (float)this.hullback.m_146909_(), (float)targetXRot));
            if (this.hullback.m_20069_()) {
                this.hullback.m_20256_(new Vec3(0.3, 0.8, 0.0).m_82524_(this.hullback.m_146908_()));
            }
            if (this.hullback.m_20186_() >= (double)this.hullback.m_9236_().m_5736_() && this.hullback.m_9236_().f_46443_) {
                for (int i = 0; i < 5; ++i) {
                    this.hullback.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.hullback.m_20185_() + (double)((this.hullback.m_217043_().m_188501_() - 0.5f) * 3.0f), (double)this.hullback.m_9236_().m_5736_(), this.hullback.m_20189_() + (double)((this.hullback.m_217043_().m_188501_() - 0.5f) * 3.0f), 0.0, 0.5, 0.0);
                }
            }
        }

        public void m_8041_() {
            this.isBreaching = false;
            this.breachCooldown = 200;
            this.hullback.m_20301_(this.hullback.m_6062_());
            if (this.hullback.m_9236_().f_46443_) {
                for (int i = 0; i < 20; ++i) {
                    this.hullback.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.hullback.partPosition[2].f_82479_, this.hullback.partPosition[2].f_82480_, this.hullback.partPosition[2].f_82481_, (double)((this.hullback.m_217043_().m_188501_() - 0.5f) * 0.5f), (double)(this.hullback.m_217043_().m_188501_() * 0.5f), (double)((this.hullback.m_217043_().m_188501_() - 0.5f) * 0.5f));
                }
                this.hullback.mouthTarget = 0.0f;
            }
            Vec3 particlePos = HullbackEntity.this.partPosition[1].m_82549_(new Vec3(0.0, 7.0, 0.0));
            double x = particlePos.f_82479_;
            double y = particlePos.f_82480_;
            double z = particlePos.f_82481_;
            Level level = this.hullback.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WBParticleRegistry.SMOKE.get()), x, y, z, 50, 0.2, 0.2, 0.2, 0.02);
            }
            this.hullback.m_5496_(WBSoundRegistry.HULLBACK_BREATHE.get(), 3.0f, 1.0f);
            this.hullback.m_146926_(Mth.m_14189_((float)0.1f, (float)this.hullback.m_146909_(), (float)0.0f));
        }

        public boolean isBreaching() {
            return this.isBreaching;
        }
    }

    public class HullbackTryFindWaterGoal
    extends Goal {
        private final PathfinderMob mob;
        private final boolean isBeached;

        public HullbackTryFindWaterGoal(PathfinderMob mob, boolean isBeached) {
            this.mob = mob;
            this.isBeached = isBeached;
        }

        public boolean m_8036_() {
            if (this.isBeached) {
                return this.mob.f_19797_ > 20 && !this.mob.isEyeInFluidType(Fluids.f_76193_.getFluidType());
            }
            return this.mob.f_19797_ > 20 && !this.mob.m_9236_().m_6425_(this.mob.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_);
        }

        public void m_8056_() {
            BlockPos blockpos = null;
            for (BlockPos blockpos1 : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.mob.m_20185_() - (this.isBeached ? 20.0 : 5.0))), (int)Mth.m_14107_((double)(this.mob.m_20186_() - 2.0)), (int)Mth.m_14107_((double)(this.mob.m_20189_() - (this.isBeached ? 20.0 : 5.0))), (int)Mth.m_14107_((double)(this.mob.m_20185_() + (this.isBeached ? 20.0 : 5.0))), (int)this.mob.m_146904_(), (int)Mth.m_14107_((double)(this.mob.m_20189_() + (this.isBeached ? 20.0 : 5.0))))) {
                if (!this.mob.m_9236_().m_6425_(blockpos1).m_205070_(FluidTags.f_13131_)) continue;
                blockpos = blockpos1;
                break;
            }
            if (blockpos != null) {
                this.mob.m_21566_().m_6849_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 1.0);
                this.mob.m_21563_().m_24946_(this.mob.m_21566_().m_25000_(), this.mob.m_21566_().m_25001_(), this.mob.m_21566_().m_25002_());
            }
        }

        public void m_8037_() {
            super.m_8037_();
            Vec3 target = new Vec3(this.mob.m_21566_().m_25000_(), this.mob.m_21566_().m_25001_(), this.mob.m_21566_().m_25002_());
            float targetYRot = (float)Math.toDegrees(Math.atan2(target.f_82481_ - this.mob.m_20189_(), target.f_82479_ - this.mob.m_20185_())) - 90.0f;
            this.mob.m_146922_(Mth.m_14189_((float)0.01f, (float)this.mob.m_146908_(), (float)targetYRot));
            if (this.mob.f_19797_ % 10 == 0) {
                this.mob.m_216990_(WBSoundRegistry.HULLBACK_MAD.get());
            }
            if (this.mob.f_19797_ % 100 == 0 && !this.mob.m_9236_().m_8055_(this.mob.m_20183_().m_7495_()).m_60795_()) {
                ((HullbackEntity)this.mob).mouthTarget = 0.0f;
                this.mob.m_21563_().m_24964_(target);
                this.mob.m_146922_(Mth.m_14189_((float)0.1f, (float)this.mob.m_146908_(), (float)targetYRot));
                this.mob.f_20883_ = this.mob.m_146908_();
                Vec3 direction = target.m_82546_(this.mob.m_20182_()).m_82541_();
                double lungePower = 1.0;
                Vec3 velocity = direction.m_82490_(lungePower).m_82520_(0.0, 0.5, 0.0);
                if (this.isBeached) {
                    this.mob.m_5496_(WBSoundRegistry.ORGAN.get(), 2.0f, 2.0f);
                    this.mob.m_5496_(WBSoundRegistry.ORGAN.get(), 2.0f, 1.0f);
                    this.mob.m_5496_(WBSoundRegistry.HULLBACK_HURT.get(), 3.0f, 0.2f);
                    this.mob.m_5496_(WBSoundRegistry.HULLBACK_SWIM.get(), 3.0f, 0.5f);
                    this.pushEntities();
                }
                this.mob.m_20256_(velocity);
                this.mob.m_146922_(Mth.m_14189_((float)0.2f, (float)this.mob.m_146908_(), (float)targetYRot));
                this.mob.f_20883_ = this.mob.m_146908_();
            }
        }

        public void pushEntities() {
            AABB pushArea = this.mob.m_20191_().m_82400_(20.0);
            List pushableEntities = this.mob.m_9236_().m_45933_((Entity)this.mob, pushArea);
            pushableEntities.removeIf(entity -> !entity.m_6094_() && entity.m_20159_());
            Vec3 center = this.mob.m_20182_();
            double pushStrength = 3.0;
            for (Entity entity2 : pushableEntities) {
                Vec3 pushDir = entity2.m_20182_().m_82546_(center).m_82541_();
                entity2.m_5997_(pushDir.f_82479_ * pushStrength, 0.3, pushDir.f_82481_ * pushStrength);
                Level level = this.mob.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WBParticleRegistry.SMOKE.get()), entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), 10, 0.5, 0.5, 0.5, 0.02);
                }
                if (!(entity2 instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity2;
                living.m_147240_(0.5, pushDir.f_82479_, pushDir.f_82481_);
                living.f_19864_ = true;
            }
        }

        public void m_8041_() {
            super.m_8041_();
            if (this.isBeached) {
                this.mob.m_20301_(this.mob.m_6062_());
                if (this.mob.m_9236_().f_46443_) {
                    for (int i = 0; i < 20; ++i) {
                        this.mob.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, ((HullbackEntity)this.mob).partPosition[2].f_82479_, ((HullbackEntity)this.mob).partPosition[2].f_82480_, ((HullbackEntity)this.mob).partPosition[2].f_82481_, (double)((this.mob.m_217043_().m_188501_() - 0.5f) * 0.5f), (double)(this.mob.m_217043_().m_188501_() * 0.5f), (double)((this.mob.m_217043_().m_188501_() - 0.5f) * 0.5f));
                    }
                    ((HullbackEntity)this.mob).mouthTarget = 0.0f;
                }
                Vec3 particlePos = HullbackEntity.this.partPosition[1].m_82549_(new Vec3(0.0, 7.0, 0.0));
                double x = particlePos.f_82479_;
                double y = particlePos.f_82480_;
                double z = particlePos.f_82481_;
                Level level = this.mob.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)WBParticleRegistry.SMOKE.get()), x, y, z, 50, 0.2, 0.2, 0.2, 0.02);
                }
                this.mob.m_5496_(WBSoundRegistry.HULLBACK_BREATHE.get(), 6.0f, 1.0f);
            }
        }
    }

    class HullbackRandomSwimGoal
    extends RandomSwimmingGoal {
        private static final int HORIZONTAL_RANGE = 10;
        private static final int VERTICAL_RANGE = 10;
        private static final float FRONT_ANGLE = 45.0f;
        private static final int STUCK_TIMEOUT = 100;
        private static final double MIN_DISTANCE = 2.0;
        private final HullbackEntity mob;
        private int stuckTimer;
        private Vec3 lastPosition;
        private Vec3 currentTarget;

        public HullbackRandomSwimGoal(HullbackEntity mob, double speed, int interval) {
            super((PathfinderMob)mob, speed, interval);
            this.stuckTimer = 0;
            this.lastPosition = Vec3.f_82478_;
            this.currentTarget = null;
            this.mob = mob;
        }

        public boolean m_8036_() {
            Vec3 vec3;
            if (this.mob.hasAnchorDown()) {
                return false;
            }
            if (!this.f_25731_) {
                if (this.mob.m_21216_() >= 100) {
                    return false;
                }
                if (this.mob.m_217043_().m_188503_(HullbackRandomSwimGoal.m_186073_((int)this.f_25730_)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.m_7037_()) == null) {
                return false;
            }
            this.f_25726_ = vec3.f_82479_;
            this.f_25727_ = vec3.f_82480_;
            this.f_25728_ = vec3.f_82481_;
            this.f_25731_ = false;
            this.currentTarget = this.m_7037_();
            this.stuckTimer = 0;
            this.lastPosition = this.mob.m_20182_();
            return true;
        }

        public boolean m_8045_() {
            if (this.currentTarget == null) {
                return false;
            }
            Vec3 currentPos = this.mob.m_20182_();
            this.stuckTimer = currentPos.m_82554_(this.lastPosition) < 0.5 ? ++this.stuckTimer : 0;
            this.lastPosition = currentPos;
            return this.stuckTimer < 100 && currentPos.m_82554_(this.currentTarget) > 2.0 && !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            if (this.currentTarget != null) {
                this.mob.m_21573_().m_26519_(this.currentTarget.f_82479_, this.currentTarget.f_82480_, this.currentTarget.f_82481_, this.mob.m_6254_() ? (double)0.2f : this.f_25729_);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.currentTarget = null;
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.mob.getSubEntities()[0].isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
                this.mob.m_20334_(0.0, -0.1, 0.0);
            }
            if (this.currentTarget != null && this.mob.m_21573_().m_26571_() && this.mob.m_20182_().m_82554_(this.currentTarget) > 2.0) {
                this.mob.m_21573_().m_26519_(this.currentTarget.f_82479_, this.currentTarget.f_82480_, this.currentTarget.f_82481_, this.f_25729_);
            }
            if (this.mob.m_20184_().m_82553_() > 0.5) {
                HullbackEntity.this.mouthTarget = 1.0f;
            }
        }

        protected Vec3 m_7037_() {
            Vec3 target = Vec3.f_82478_;
            target = this.mob.m_217043_().m_188501_() < 0.7f ? this.findPositionInFront() : BehaviorUtils.m_147444_((PathfinderMob)this.mob, (int)10, (int)10);
            return target == null ? this.mob.m_20182_() : target;
        }

        private Vec3 findPositionInFront() {
            Vec3 lookAngle = this.mob.m_20154_();
            Vec3 mobPos = this.mob.m_20182_();
            for (int i = 0; i < 10; ++i) {
                float angle = this.mob.m_217043_().m_188501_() * 45.0f * 2.0f - 45.0f;
                Vec3 direction = lookAngle.m_82524_((float)Math.toRadians(angle));
                float distance = 10.0f;
                Vec3 targetPos = mobPos.m_82549_(direction.m_82490_((double)distance));
                if (!this.isSwimmablePos((PathfinderMob)this.mob, targetPos = targetPos.m_82520_(0.0, (double)(this.mob.m_217043_().m_188501_() * 10.0f * 2.0f - 10.0f), 0.0))) continue;
                return targetPos;
            }
            return BehaviorUtils.m_147444_((PathfinderMob)this.mob, (int)10, (int)10);
        }

        private boolean isSwimmablePos(PathfinderMob entity, Vec3 targetPos) {
            return entity.m_9236_().m_8055_(BlockPos.m_274446_((Position)targetPos)).m_60647_((BlockGetter)entity.m_9236_(), BlockPos.m_274446_((Position)targetPos), PathComputationType.WATER);
        }
    }

    public class HullbackApproachPlayerGoal
    extends Goal {
        private static final float APPROACH_DISTANCE = 8.0f;
        private static final float SIDE_OFFSET = 5.0f;
        private static final float ROTATION_SPEED = 0.8f;
        private static Ingredient TEMPT_SADDLE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42450_});
        private static Ingredient TEMPT_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42574_});
        private static Ingredient TEMPT_AXES = Ingredient.m_204132_((TagKey)ItemTags.f_271207_);
        private final HullbackEntity hullback;
        private final float speedModifier;
        private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
        private final TargetingConditions targetingConditions;
        private Player targetPlayer;
        private int repositionCooldown;
        private boolean approachFromRight;
        private Vec3 targetPosition;

        public HullbackApproachPlayerGoal(HullbackEntity hullback, float speedModifier) {
            this.hullback = hullback;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.repositionCooldown = 200 + hullback.m_217043_().m_188503_(200);
            this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
        }

        private boolean shouldFollow(LivingEntity entity) {
            if (HullbackEntity.this.isTamed() && !HullbackEntity.this.m_6254_()) {
                return TEMPT_SADDLE.test(entity.m_21205_()) || TEMPT_SADDLE.test(entity.m_21206_()) || TEMPT_ITEMS.test(entity.m_21205_()) || TEMPT_ITEMS.test(entity.m_21206_()) || TEMPT_AXES.test(entity.m_21205_()) || TEMPT_AXES.test(entity.m_21206_());
            }
            return TEMPT_ITEMS.test(entity.m_21205_()) || TEMPT_ITEMS.test(entity.m_21206_()) || TEMPT_AXES.test(entity.m_21205_()) || TEMPT_AXES.test(entity.m_21206_());
        }

        public boolean m_8036_() {
            if (this.hullback.hasAnchorDown()) {
                return false;
            }
            this.targetPlayer = this.hullback.m_9236_().m_45949_(this.targetingConditions, (LivingEntity)this.hullback, 30.0, 50.0, 30.0);
            if (this.targetPlayer == null) {
                return false;
            }
            return !this.targetPlayer.m_20159_() || !this.targetPlayer.m_20202_().m_7306_((Entity)this.hullback) && (!this.targetPlayer.m_20202_().m_20159_() || !this.targetPlayer.m_20202_().m_20202_().m_7306_((Entity)this.hullback));
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            Vec3 toPlayer = this.targetPlayer.m_20182_().m_82546_(this.hullback.m_20182_());
            Vec3 whaleRight = Vec3.m_82498_((float)0.0f, (float)(this.hullback.m_146908_() + 90.0f));
            this.approachFromRight = toPlayer.m_82526_(whaleRight) > 0.0;
            this.hullback.m_6710_((LivingEntity)this.targetPlayer);
            Vec3 playerLook = this.targetPlayer.m_20154_();
            Vec3 perpendicular = new Vec3(-playerLook.f_82481_, 0.0, playerLook.f_82479_).m_82541_();
            Vec3 sideOffset = perpendicular.m_82490_(this.approachFromRight ? 5.0 : -5.0);
            this.targetPosition = this.targetPlayer.m_20182_().m_82549_(sideOffset).m_82549_(playerLook.m_82490_(-8.0));
            HullbackEntity.this.m_216990_(WBSoundRegistry.HULLBACK_HAPPY.get());
            this.hullback.mouthTarget = 0.2f;
        }

        public void m_8041_() {
            this.targetPlayer = null;
            this.targetPosition = null;
            this.hullback.m_6710_(null);
            this.repositionCooldown = 100 + this.hullback.m_217043_().m_188503_(200);
            this.hullback.m_21573_().m_26573_();
            this.hullback.mouthTarget = 0.0f;
        }

        public void m_8037_() {
            this.hullback.mouthTarget = 0.6f;
            if (this.targetPlayer == null) {
                return;
            }
            if (this.hullback.f_19797_ % 200 == 0) {
                Vec3 playerLook = this.targetPlayer.m_20154_();
                Vec3 perpendicular = new Vec3(-playerLook.f_82481_, 0.0, playerLook.f_82479_).m_82541_();
                Vec3 sideOffset = perpendicular.m_82490_(this.approachFromRight ? 5.0 : -5.0);
                this.targetPosition = this.targetPlayer.m_20182_().m_82549_(sideOffset).m_82549_(playerLook.m_82490_(-8.0));
                this.hullback.m_21573_().m_26519_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, (double)this.speedModifier);
                Vec3 toPlayer = this.targetPlayer.m_20182_().m_82546_(this.hullback.m_20182_());
                float desiredYaw = (float)Math.toDegrees(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_)) - 90.0f;
                float sideYawOffset = this.approachFromRight ? -90.0f : 90.0f;
                float targetYaw = desiredYaw + sideYawOffset;
                this.hullback.m_146922_(Mth.m_14189_((float)0.1f, (float)this.hullback.m_146908_(), (float)targetYaw));
                this.hullback.f_20883_ = this.hullback.m_146908_();
            }
        }
    }

    public class HullbackArmorPlayerGoal
    extends Goal {
        private static final float APPROACH_DISTANCE = 8.0f;
        private static final float SIDE_OFFSET = 5.0f;
        private static final float ROTATION_SPEED = 0.8f;
        private static Ingredient TEMPT_PLANKS = Ingredient.m_204132_(WBTagRegistry.HULLBACK_EQUIPPABLE);
        private static Ingredient TEMPT_WIDGETS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)WBItemRegistry.SAIL.get(), (ItemLike)WBItemRegistry.ANCHOR.get(), (ItemLike)WBItemRegistry.MAST.get(), (ItemLike)WBItemRegistry.HELM.get(), (ItemLike)WBItemRegistry.CANNON.get()});
        private final HullbackEntity hullback;
        private final float speedModifier;
        private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
        private final TargetingConditions targetingConditions;
        private Player targetPlayer;
        private int repositionCooldown;
        private boolean approachFromRight;
        private Vec3 targetPosition;

        public HullbackArmorPlayerGoal(HullbackEntity hullback, float speedModifier) {
            this.hullback = hullback;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.repositionCooldown = 200 + hullback.m_217043_().m_188503_(200);
            this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
        }

        private boolean shouldFollow(LivingEntity entity) {
            if (HullbackEntity.this.m_6254_()) {
                if ((double)HullbackEntity.this.getArmorProgress() >= 0.5 && HullbackEntity.this.getArmorProgress() < 1.0f) {
                    return TEMPT_PLANKS.test(entity.m_21205_()) || TEMPT_PLANKS.test(entity.m_21206_()) || TEMPT_WIDGETS.test(entity.m_21205_()) || TEMPT_WIDGETS.test(entity.m_21206_());
                }
                if (HullbackEntity.this.getArmorProgress() == 1.0f) {
                    return TEMPT_WIDGETS.test(entity.m_21205_()) || TEMPT_WIDGETS.test(entity.m_21206_());
                }
                return TEMPT_PLANKS.test(entity.m_21205_()) || TEMPT_PLANKS.test(entity.m_21206_());
            }
            return false;
        }

        public boolean m_8036_() {
            if (!HullbackEntity.this.isTamed()) {
                return false;
            }
            if (this.hullback.hasAnchorDown()) {
                return false;
            }
            this.targetPlayer = this.hullback.m_9236_().m_45949_(this.targetingConditions, (LivingEntity)this.hullback, 30.0, 50.0, 30.0);
            if (this.targetPlayer == null) {
                return false;
            }
            return !this.targetPlayer.m_20159_() || !this.targetPlayer.m_20202_().m_7306_((Entity)this.hullback) && (!this.targetPlayer.m_20202_().m_20159_() || !this.targetPlayer.m_20202_().m_20202_().m_7306_((Entity)this.hullback));
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            Vec3 toPlayer = this.targetPlayer.m_20182_().m_82546_(this.hullback.m_20182_());
            Vec3 whaleRight = Vec3.m_82498_((float)0.0f, (float)(this.hullback.m_146908_() + 90.0f));
            this.approachFromRight = toPlayer.m_82526_(whaleRight) > 0.0;
            this.hullback.m_6710_((LivingEntity)this.targetPlayer);
            Vec3 playerLook = this.targetPlayer.m_20154_();
            Vec3 perpendicular = new Vec3(-playerLook.f_82481_, 0.0, playerLook.f_82479_).m_82541_();
            Vec3 sideOffset = perpendicular.m_82490_(this.approachFromRight ? 5.0 : -5.0);
            this.targetPosition = this.targetPlayer.m_20182_().m_82549_(sideOffset).m_82549_(playerLook.m_82490_(-8.0));
            HullbackEntity.this.m_216990_(WBSoundRegistry.HULLBACK_HAPPY.get());
            this.hullback.mouthTarget = 0.1f;
        }

        public void m_8041_() {
            this.targetPlayer = null;
            this.targetPosition = null;
            this.hullback.m_6710_(null);
            this.repositionCooldown = 100 + this.hullback.m_217043_().m_188503_(200);
            this.hullback.m_21573_().m_26573_();
            this.hullback.mouthTarget = 0.0f;
        }

        public void m_8037_() {
            if (this.targetPlayer == null) {
                return;
            }
            this.hullback.mouthTarget = 0.6f;
            if (this.hullback.f_19797_ % 200 == 0) {
                Vec3 playerLook = this.targetPlayer.m_20154_();
                Vec3 perpendicular = new Vec3(-playerLook.f_82481_, 0.0, playerLook.f_82479_).m_82541_();
                Vec3 sideOffset = perpendicular.m_82490_(this.approachFromRight ? 5.0 : -5.0);
                this.targetPosition = this.targetPlayer.m_20182_().m_82549_(sideOffset).m_82549_(playerLook.m_82490_(-8.0));
                this.hullback.m_21573_().m_26519_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, (double)this.speedModifier);
                Vec3 toPlayer = this.targetPlayer.m_20182_().m_82546_(this.hullback.m_20182_());
                float desiredYaw = (float)Math.toDegrees(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_)) - 90.0f;
                float sideYawOffset = this.approachFromRight ? -90.0f : 90.0f;
                float targetYaw = desiredYaw + sideYawOffset;
                this.hullback.m_146922_(Mth.m_14189_((float)0.1f, (float)this.hullback.m_146908_(), (float)targetYaw));
                this.hullback.f_20883_ = this.hullback.m_146908_();
            }
        }
    }

    class HullbackBodyRotationControl
    extends BodyRotationControl {
        public HullbackBodyRotationControl(HullbackEntity hullBack) {
            super((Mob)hullBack);
        }

        public void m_8121_() {
            HullbackEntity.this.m_5618_(HullbackEntity.this.m_146908_());
        }
    }
}

