/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.server.entities;

import com.fruityspikes.whaleborne.server.entities.HullbackEntity;
import com.fruityspikes.whaleborne.server.items.WhaleEquipment;
import com.fruityspikes.whaleborne.server.registries.WBTagRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SaddleItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class HullbackPartEntity
extends PartEntity<HullbackEntity> {
    public final HullbackEntity parent;
    public final String name;
    private final EntityDimensions size;

    public HullbackPartEntity(HullbackEntity parent, String name, float width, float height) {
        super((Entity)parent);
        this.size = EntityDimensions.m_20395_((float)width, (float)height);
        this.m_6210_();
        this.parent = parent;
        this.name = name;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public EntityDimensions getSize() {
        return this.size;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        boolean topClicked = vec.f_82480_ > (double)(this.size.f_20378_ * 0.6f);
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem.m_41720_() instanceof DebugStickItem) {
            return this.parent.interactDebug(player, hand);
        }
        if (heldItem.m_41720_() instanceof ShearsItem || heldItem.m_41720_() instanceof AxeItem) {
            return this.parent.interactClean(player, hand, this, topClicked);
        }
        if (heldItem.m_41720_() instanceof SaddleItem || heldItem.m_204117_(WBTagRegistry.HULLBACK_EQUIPPABLE)) {
            return this.parent.interactArmor(player, hand, this, topClicked);
        }
        if (heldItem.m_41619_()) {
            if (this.name == "tail") {
                return this.parent.m_6096_(player, hand);
            }
            if (this.name == "fluke") {
                return this.parent.interactRide(player, hand, 6, null);
            }
            if (topClicked) {
                if (this.name == "body") {
                    Vec3 localClick = new Vec3(vec.f_82479_, 0.0, vec.f_82481_);
                    float inverseYaw = this.m_146908_() * ((float)Math.PI / 180);
                    localClick = localClick.m_82496_(0.0f).m_82524_(inverseYaw);
                    double angle = Math.atan2(localClick.f_82481_, localClick.f_82479_) + Math.PI;
                    int quadrant = (int)(angle / 1.5707963267948966) % 4;
                    switch (quadrant) {
                        case 0: {
                            return this.parent.interactRide(player, hand, 5, null);
                        }
                        case 1: {
                            return this.parent.interactRide(player, hand, 4, null);
                        }
                        case 2: {
                            return this.parent.interactRide(player, hand, 2, null);
                        }
                    }
                    return this.parent.interactRide(player, hand, 3, null);
                }
                if (this.name == "nose") {
                    return this.parent.interactRide(player, hand, 0, null);
                }
                if (this.name == "head") {
                    return this.parent.interactRide(player, hand, 1, null);
                }
            }
            return this.parent.m_6096_(player, hand);
        }
        if (heldItem.m_41720_() instanceof WhaleEquipment || heldItem.m_41720_() instanceof SpawnEggItem) {
            EntityType<?> entity;
            Item item = heldItem.m_41720_();
            if (item instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                entity = spawnEggItem.m_43228_(null);
            } else {
                item = heldItem.m_41720_();
                if (item instanceof WhaleEquipment) {
                    WhaleEquipment whaleEquipment = (WhaleEquipment)item;
                    entity = whaleEquipment.getEntity();
                } else {
                    entity = EntityType.f_20570_;
                }
            }
            if (this.name == "tail") {
                return this.parent.m_6096_(player, hand);
            }
            if (this.name == "fluke") {
                return this.parent.interactRide(player, hand, 6, entity);
            }
            if (topClicked) {
                if (this.name == "body") {
                    Vec3 localClick = new Vec3(vec.f_82479_, 0.0, vec.f_82481_);
                    float inverseYaw = this.m_146908_() * ((float)Math.PI / 180);
                    localClick = localClick.m_82496_(0.0f).m_82524_(inverseYaw);
                    double angle = Math.atan2(localClick.f_82481_, localClick.f_82479_) + Math.PI;
                    int quadrant = (int)(angle / 1.5707963267948966) % 4;
                    switch (quadrant) {
                        case 0: {
                            return this.parent.interactRide(player, hand, 5, entity);
                        }
                        case 1: {
                            return this.parent.interactRide(player, hand, 4, entity);
                        }
                        case 2: {
                            return this.parent.interactRide(player, hand, 2, entity);
                        }
                    }
                    return this.parent.interactRide(player, hand, 3, entity);
                }
                if (this.name == "nose") {
                    return this.parent.interactRide(player, hand, 0, entity);
                }
                if (this.name == "head") {
                    return this.parent.interactRide(player, hand, 1, entity);
                }
            }
            return this.parent.m_6096_(player, hand);
        }
        return this.parent.m_6096_(player, hand);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.parent.m_142340_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.m_6673_(source) ? false : this.parent.m_6469_(source, amount);
    }

    public boolean m_7306_(Entity entity) {
        return this == entity || this.parent == entity;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.size;
    }
}

