/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne;

import com.fruityspikes.whaleborne.Config;
import com.fruityspikes.whaleborne.client.menus.CannonScreen;
import com.fruityspikes.whaleborne.client.menus.HullbackScreen;
import com.fruityspikes.whaleborne.client.models.AnchorHeadModel;
import com.fruityspikes.whaleborne.client.models.AnchorModel;
import com.fruityspikes.whaleborne.client.models.CannonModel;
import com.fruityspikes.whaleborne.client.models.HelmModel;
import com.fruityspikes.whaleborne.client.models.HullbackArmorModel;
import com.fruityspikes.whaleborne.client.models.HullbackModel;
import com.fruityspikes.whaleborne.client.models.MastModel;
import com.fruityspikes.whaleborne.client.models.SailModel;
import com.fruityspikes.whaleborne.client.renderers.AnchorHeadRenderer;
import com.fruityspikes.whaleborne.client.renderers.AnchorRenderer;
import com.fruityspikes.whaleborne.client.renderers.CannonRenderer;
import com.fruityspikes.whaleborne.client.renderers.HelmRenderer;
import com.fruityspikes.whaleborne.client.renderers.HullbackRenderer;
import com.fruityspikes.whaleborne.client.renderers.MastRenderer;
import com.fruityspikes.whaleborne.client.renderers.NothingRenderer;
import com.fruityspikes.whaleborne.client.renderers.SailRenderer;
import com.fruityspikes.whaleborne.network.WhaleborneNetwork;
import com.fruityspikes.whaleborne.server.entities.AnchorEntity;
import com.fruityspikes.whaleborne.server.entities.HelmEntity;
import com.fruityspikes.whaleborne.server.entities.HullbackEntity;
import com.fruityspikes.whaleborne.server.particles.WBSmokeProvider;
import com.fruityspikes.whaleborne.server.registries.WBBlockRegistry;
import com.fruityspikes.whaleborne.server.registries.WBCreativeTabsRegistry;
import com.fruityspikes.whaleborne.server.registries.WBEntityModelLayers;
import com.fruityspikes.whaleborne.server.registries.WBEntityRegistry;
import com.fruityspikes.whaleborne.server.registries.WBItemRegistry;
import com.fruityspikes.whaleborne.server.registries.WBLootModifierRegistry;
import com.fruityspikes.whaleborne.server.registries.WBMenuRegistry;
import com.fruityspikes.whaleborne.server.registries.WBParticleRegistry;
import com.fruityspikes.whaleborne.server.registries.WBSoundRegistry;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="whaleborne")
public class Whaleborne {
    public static final String MODID = "whaleborne";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation ANCHOR_GUI = new ResourceLocation("whaleborne", "textures/gui/anchor.png");

    public Whaleborne() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        WBEntityRegistry.ENTITY_TYPES.register(modEventBus);
        WBBlockRegistry.BLOCKS.register(modEventBus);
        WBItemRegistry.ITEMS.register(modEventBus);
        WBMenuRegistry.MENUS.register(modEventBus);
        WBSoundRegistry.SOUND_EVENTS.register(modEventBus);
        WBLootModifierRegistry.LOOT_MODIFIER_SERIALIZERS.register(modEventBus);
        WBParticleRegistry.PARTICLE_TYPES.register(modEventBus);
        WBCreativeTabsRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        WhaleborneNetwork.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="whaleborne", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("whaleborne_anchor_overlay", (gui, poseStack, partialTick, width, height) -> {
                Entity patt5647$temp;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player.m_20202_() instanceof HelmEntity && (patt5647$temp = player.m_20201_()) instanceof HullbackEntity) {
                    HullbackEntity hullback = (HullbackEntity)patt5647$temp;
                    for (Entity passenger : hullback.m_20197_()) {
                        if (!(passenger instanceof AnchorEntity)) continue;
                        int j = width / 2 - 12;
                        int k = height - 28 - 13;
                        poseStack.m_280168_().m_85836_();
                        poseStack.m_280398_(ANCHOR_GUI, j, k, 0, 0.0f, hullback.hasAnchorDown() ? 24.0f : 0.0f, 24, 24, 24, 48);
                        poseStack.m_280168_().m_85849_();
                        break;
                    }
                }
            });
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)WBMenuRegistry.CANNON_MENU.get()), CannonScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)WBMenuRegistry.HULLBACK_MENU.get()), HullbackScreen::new);
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(WBEntityModelLayers.HULLBACK, HullbackModel::createBodyLayer);
            event.registerLayerDefinition(WBEntityModelLayers.HULLBACK_ARMOR, HullbackArmorModel::createBodyLayer);
            event.registerLayerDefinition(WBEntityModelLayers.SAIL, SailModel::createBodyLayer);
            event.registerLayerDefinition(WBEntityModelLayers.HELM, HelmModel::createBodyLayer);
            event.registerLayerDefinition(WBEntityModelLayers.MAST, MastModel::createBodyLayer);
            event.registerLayerDefinition(WBEntityModelLayers.CANNON, CannonModel::createBodyLayer);
            event.registerLayerDefinition(WBEntityModelLayers.ANCHOR, AnchorModel::createBodyLayer);
            event.registerLayerDefinition(WBEntityModelLayers.ANCHOR_HEAD, AnchorHeadModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)WBEntityRegistry.HULLBACK.get(), HullbackRenderer::new);
            event.registerEntityRenderer((EntityType)WBEntityRegistry.SAIL.get(), SailRenderer::new);
            event.registerEntityRenderer((EntityType)WBEntityRegistry.MAST.get(), MastRenderer::new);
            event.registerEntityRenderer((EntityType)WBEntityRegistry.CANNON.get(), CannonRenderer::new);
            event.registerEntityRenderer((EntityType)WBEntityRegistry.HELM.get(), HelmRenderer::new);
            event.registerEntityRenderer((EntityType)WBEntityRegistry.ANCHOR.get(), AnchorRenderer::new);
            event.registerEntityRenderer((EntityType)WBEntityRegistry.ANCHOR_HEAD.get(), AnchorHeadRenderer::new);
            event.registerEntityRenderer((EntityType)WBEntityRegistry.HULLBACK_PLATFORM.get(), NothingRenderer::new);
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)WBParticleRegistry.SMOKE.get(), WBSmokeProvider::new);
        }
    }
}

