/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.client.menus;

import com.fruityspikes.whaleborne.server.entities.HullbackEntity;
import com.fruityspikes.whaleborne.server.registries.WBMenuRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;

public class HullbackMenu
extends AbstractContainerMenu {
    private final Container hullbackContainer;
    public final HullbackEntity hullback;

    public static HullbackMenu fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        int entityId = data.readInt();
        Level level = inv.f_35978_.m_9236_();
        Entity entity = level.m_6815_(entityId);
        if (entity instanceof HullbackEntity) {
            HullbackEntity hullback = (HullbackEntity)entity;
            return new HullbackMenu(windowId, inv, hullback);
        }
        throw new IllegalStateException("Invalid hullback entity");
    }

    public HullbackMenu(int windowId, Inventory playerInventory, final HullbackEntity hullback) {
        super((MenuType)WBMenuRegistry.HULLBACK_MENU.get(), windowId);
        if (hullback.getInventory() == null) {
            System.out.println("Hullback inventory is null!");
        }
        this.hullback = hullback;
        this.hullbackContainer = hullback.getInventory();
        this.hullbackContainer.m_5856_(playerInventory.f_35978_);
        this.m_38897_(new Slot(this.hullbackContainer, 0, 152, 18){

            public boolean m_5857_(ItemStack stack) {
                return true;
            }
        });
        this.m_38897_(new Slot(this.hullbackContainer, 1, 152, 36){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == Items.f_42450_;
            }

            public boolean m_8010_(Player player) {
                return hullback.getArmorProgress() == 0.0f;
            }
        });
        this.m_38897_(new Slot(this.hullbackContainer, 2, 152, 54){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return player.m_7500_();
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 2 ? !this.m_38903_(itemstack1, 2, 38, true) : (itemstack1.m_41720_() == Items.f_42450_ ? !this.m_38903_(itemstack1, 1, 2, true) : !this.m_38903_(itemstack1, 0, 1, false))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.hullbackContainer.m_5785_(player);
    }

    public float getHealth() {
        return this.hullback.m_21223_();
    }

    public float getMaxHealth() {
        return this.hullback.m_21233_();
    }

    public float getArmorProgress() {
        return this.hullback.getArmorProgress();
    }

    public float getSpeedModifier() {
        AttributeInstance inst = this.hullback.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        if (inst != null) {
            if (inst.m_22111_(HullbackEntity.getSailSpeedModifierUuid()) != null) {
                return (float)inst.m_22111_(HullbackEntity.getSailSpeedModifierUuid()).m_22218_();
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public String getName() {
        return this.hullback.m_5446_().getString();
    }

    public boolean isVehicleAlive() {
        return this.hullback.m_6084_();
    }
}

