/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.client.models;

import com.fruityspikes.whaleborne.server.entities.HullbackEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class HullbackModel<T extends HullbackEntity>
extends EntityModel<T> {
    private final ModelPart head;
    private final ModelPart lip;
    private final ModelPart jaw_2;
    private final ModelPart jaw_1;
    private final ModelPart jaw_0;
    private final ModelPart left_eye;
    private final ModelPart left_upper_eyelid;
    private final ModelPart left_pupil;
    private final ModelPart left_lower_eyelid;
    private final ModelPart right_eye;
    private final ModelPart right_upper_eyelid;
    private final ModelPart right_pupil;
    private final ModelPart right_lower_eyelid;
    private final ModelPart body;
    private final ModelPart left_fin;
    private final ModelPart right_fin;
    private final ModelPart tail;
    private final ModelPart fluke;
    private HullbackEntity entity;
    private float a;

    public HullbackModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.lip = this.head.m_171324_("lip");
        this.jaw_2 = this.head.m_171324_("jaw_2");
        this.jaw_1 = this.head.m_171324_("jaw_1");
        this.jaw_0 = this.head.m_171324_("jaw_0");
        this.left_eye = this.head.m_171324_("left_eye");
        this.left_upper_eyelid = this.left_eye.m_171324_("left_upper_eyelid");
        this.left_pupil = this.left_eye.m_171324_("left_pupil");
        this.left_lower_eyelid = this.left_eye.m_171324_("left_lower_eyelid");
        this.right_eye = this.head.m_171324_("right_eye");
        this.right_upper_eyelid = this.right_eye.m_171324_("right_upper_eyelid");
        this.right_pupil = this.right_eye.m_171324_("right_pupil");
        this.right_lower_eyelid = this.right_eye.m_171324_("right_lower_eyelid");
        this.body = root.m_171324_("body");
        this.left_fin = this.body.m_171324_("left_fin");
        this.right_fin = this.body.m_171324_("right_fin");
        this.tail = root.m_171324_("tail");
        this.fluke = root.m_171324_("fluke");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-40.0f, -40.0f, 0.0f, 80.0f, 80.0f, 130.0f, new CubeDeformation(0.0f)).m_171514_(0, 210).m_171488_(-38.0f, -39.0f, 2.0f, 76.0f, 78.0f, 126.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition lip = head.m_171599_("lip", CubeListBuilder.m_171558_().m_171514_(420, 100).m_171488_(-40.0f, -10.0f, -25.0f, 80.0f, 20.0f, 50.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)25.0f));
        PartDefinition jaw_2 = head.m_171599_("jaw_2", CubeListBuilder.m_171558_().m_171514_(420, 0).m_171488_(-40.0f, -30.0f, -45.0f, 80.0f, 10.0f, 90.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)30.0f, (float)45.0f));
        PartDefinition jaw_1 = head.m_171599_("jaw_1", CubeListBuilder.m_171558_().m_171514_(0, 414).m_171488_(-40.0f, -20.0f, -45.0f, 80.0f, 10.0f, 90.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)30.0f, (float)45.0f));
        PartDefinition jaw_0 = head.m_171599_("jaw_0", CubeListBuilder.m_171558_().m_171514_(404, 390).m_171488_(-40.0f, -10.0f, -45.0f, 80.0f, 10.0f, 90.0f, new CubeDeformation(-0.001f)), PartPose.m_171419_((float)0.0f, (float)30.0f, (float)45.0f));
        PartDefinition left_eye = head.m_171599_("left_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)40.0f, (float)17.0f, (float)110.0f));
        PartDefinition left_upper_eyelid = left_eye.m_171599_("left_upper_eyelid", CubeListBuilder.m_171558_().m_171514_(340, 424).m_171488_(-1.28f, -3.75f, -5.0f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(340, 414).m_171480_().m_171488_(-1.28f, 1.25f, -5.0f, 5.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.3f, (float)-3.25f, (float)0.0f));
        PartDefinition left_pupil = left_eye.m_171599_("left_pupil", CubeListBuilder.m_171558_().m_171514_(420, 200).m_171488_(-0.09f, -2.5f, -2.5f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.1f, (float)0.5f, (float)-0.5f));
        PartDefinition left_lower_eyelid = left_eye.m_171599_("left_lower_eyelid", CubeListBuilder.m_171558_().m_171514_(360, 424).m_171488_(-1.28f, -1.25f, -5.0f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(370, 414).m_171480_().m_171488_(-1.28f, -1.25f, -5.0f, 5.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.3f, (float)4.25f, (float)0.0f));
        PartDefinition right_eye = head.m_171599_("right_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-40.0f, (float)18.0f, (float)109.0f));
        PartDefinition right_upper_eyelid = right_eye.m_171599_("right_upper_eyelid", CubeListBuilder.m_171558_().m_171514_(340, 424).m_171488_(1.28f, -3.75f, -5.0f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(340, 414).m_171488_(-3.72f, 1.25f, -5.0f, 5.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.3f, (float)-4.25f, (float)1.0f));
        PartDefinition right_pupil = right_eye.m_171599_("right_pupil", CubeListBuilder.m_171558_().m_171514_(420, 200).m_171488_(0.09f, -2.5f, -2.5f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.1f, (float)-0.5f, (float)0.5f));
        PartDefinition right_lower_eyelid = right_eye.m_171599_("right_lower_eyelid", CubeListBuilder.m_171558_().m_171514_(360, 424).m_171488_(1.28f, -1.25f, -5.0f, 0.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(370, 414).m_171488_(-3.72f, -1.25f, -5.0f, 5.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.3f, (float)3.25f, (float)1.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(404, 210).m_171488_(-40.0f, -40.0f, 0.0f, 80.0f, 80.0f, 100.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_fin = body.m_171599_("left_fin", CubeListBuilder.m_171558_().m_171514_(0, 564).m_171480_().m_171488_(0.0f, -5.0f, -20.0f, 60.0f, 10.0f, 40.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)40.0f, (float)35.0f, (float)30.0f));
        PartDefinition right_fin = body.m_171599_("right_fin", CubeListBuilder.m_171558_().m_171514_(0, 564).m_171488_(-60.0f, -5.0f, -20.0f, 60.0f, 10.0f, 40.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-40.0f, (float)35.0f, (float)30.0f));
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(340, 490).m_171488_(-20.0f, -20.0f, 0.0f, 40.0f, 40.0f, 80.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition fluke = partdefinition.m_171599_("fluke", CubeListBuilder.m_171558_().m_171514_(0, 514).m_171488_(-40.0f, -5.0f, 0.0f, 80.0f, 10.0f, 40.0f, new CubeDeformation(0.0f)).m_171514_(420, 170).m_171488_(10.0f, -5.0f, 40.0f, 30.0f, 10.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(240, 514).m_171488_(-40.0f, -5.0f, 40.0f, 30.0f, 10.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)1024, (int)1024);
    }

    public void prepareMobModel(HullbackEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.entity = entity;
        this.a = partialTick;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float leftEyeYaw = ((HullbackEntity)((Object)entity)).getLeftEyeYaw();
        float rightEyeYaw = ((HullbackEntity)((Object)entity)).getRightEyeYaw();
        float eyePitch = ((HullbackEntity)((Object)entity)).getEyePitch();
        float swimCycle = (float)((double)((float)Math.sin(ageInTicks * 0.08f)) * entity.m_20184_().m_82553_());
        this.body.m_233569_();
        this.lip.m_233569_();
        this.tail.m_233569_();
        this.fluke.m_233569_();
        this.left_lower_eyelid.m_233569_();
        this.right_lower_eyelid.m_233569_();
        this.left_upper_eyelid.m_233569_();
        this.right_upper_eyelid.m_233569_();
        this.left_pupil.m_233569_();
        this.right_pupil.m_233569_();
        this.lip.f_104201_ = Mth.m_14179_((float)((HullbackEntity)((Object)entity)).getMouthOpenProgress(), (float)this.lip.m_233566_().f_171406_, (float)(this.lip.m_233566_().f_171406_ + 27.0f));
        this.jaw_0.f_104201_ = Math.min(Mth.m_14179_((float)((HullbackEntity)((Object)entity)).getMouthOpenProgress(), (float)this.jaw_0.m_233566_().f_171406_, (float)(this.jaw_0.m_233566_().f_171406_ + 27.0f)), this.jaw_0.m_233566_().f_171406_ + 10.0f);
        this.jaw_1.f_104201_ = Math.min(Mth.m_14179_((float)((HullbackEntity)((Object)entity)).getMouthOpenProgress(), (float)this.jaw_1.m_233566_().f_171406_, (float)(this.jaw_1.m_233566_().f_171406_ + 27.0f)), this.jaw_1.m_233566_().f_171406_ + 20.0f);
        this.jaw_2.f_104201_ = Math.min(Mth.m_14179_((float)((HullbackEntity)((Object)entity)).getMouthOpenProgress(), (float)this.jaw_2.m_233566_().f_171406_, (float)(this.jaw_2.m_233566_().f_171406_ + 27.0f)), this.jaw_2.m_233566_().f_171406_ + 30.0f);
        this.left_lower_eyelid.f_104201_ = Mth.m_14179_((float)((HullbackEntity)((Object)entity)).getMouthOpenProgress(), (float)this.left_lower_eyelid.m_233566_().f_171406_, (float)(this.left_lower_eyelid.m_233566_().f_171406_ - 2.25f));
        this.right_lower_eyelid.f_104201_ = Mth.m_14179_((float)((HullbackEntity)((Object)entity)).getMouthOpenProgress(), (float)this.right_lower_eyelid.m_233566_().f_171406_, (float)(this.right_lower_eyelid.m_233566_().f_171406_ - 2.25f));
        this.left_upper_eyelid.f_104201_ = Mth.m_14179_((float)((HullbackEntity)((Object)entity)).getMouthOpenProgress(), (float)this.left_upper_eyelid.m_233566_().f_171406_, (float)(this.left_upper_eyelid.m_233566_().f_171406_ + 2.25f));
        this.right_upper_eyelid.f_104201_ = Mth.m_14179_((float)((HullbackEntity)((Object)entity)).getMouthOpenProgress(), (float)this.right_upper_eyelid.m_233566_().f_171406_, (float)(this.right_upper_eyelid.m_233566_().f_171406_ + 2.25f));
        float perpendicularYaw = netHeadYaw + 90.0f;
        float normalized = perpendicularYaw % 180.0f / 180.0f;
        this.left_pupil.f_104202_ = Mth.m_14179_((float)Mth.m_14036_((float)normalized, (float)0.0f, (float)1.0f), (float)(this.left_pupil.m_233566_().f_171407_ - 2.0f), (float)(this.left_pupil.m_233566_().f_171407_ + 2.25f));
        this.right_pupil.f_104202_ = Mth.m_14179_((float)Mth.m_14036_((float)normalized, (float)0.0f, (float)1.0f), (float)(this.right_pupil.m_233566_().f_171407_ - 2.0f), (float)(this.right_pupil.m_233566_().f_171407_ + 2.25f));
        this.left_fin.f_104205_ = -swimCycle;
        this.right_fin.f_104205_ = swimCycle;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    public ModelPart getHead() {
        return this.head;
    }

    public ModelPart getBody() {
        return this.body;
    }

    public ModelPart getTail() {
        return this.tail;
    }

    public ModelPart getFluke() {
        return this.fluke;
    }
}

