/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.network;

import com.fruityspikes.whaleborne.server.entities.CannonEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class CannonFirePacket {
    private final int entityId;
    private final int power;

    public CannonFirePacket(int entityId, int power) {
        this.entityId = entityId;
        this.power = power;
    }

    public static void encode(CannonFirePacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId).writeInt(msg.power);
    }

    public static CannonFirePacket decode(FriendlyByteBuf buffer) {
        return new CannonFirePacket(buffer.readInt(), buffer.readInt());
    }

    public static void handle(CannonFirePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            CannonEntity cannon;
            Entity entity;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null && (entity = sender.m_9236_().m_6815_(msg.entityId)) instanceof CannonEntity && (cannon = (CannonEntity)entity).getFirstPassenger() == sender) {
                cannon.fireCannon(msg.power);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

