/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.network;

import com.fruityspikes.whaleborne.network.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class HullbackHurtPacket {
    private final int entityId;
    private final ItemStack armorItem;
    private final ItemStack crownItem;
    private final byte flags;

    public HullbackHurtPacket(int entityId, ItemStack armorItem, ItemStack crownItem, byte flags) {
        this.entityId = entityId;
        this.armorItem = armorItem;
        this.crownItem = crownItem;
        this.flags = flags;
    }

    public static void encode(HullbackHurtPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId);
        buffer.m_130055_(msg.armorItem);
        buffer.m_130055_(msg.crownItem);
        buffer.writeByte((int)msg.flags);
    }

    public static HullbackHurtPacket decode(FriendlyByteBuf buffer) {
        return new HullbackHurtPacket(buffer.readInt(), buffer.m_130267_(), buffer.m_130267_(), buffer.readByte());
    }

    public static void handle(HullbackHurtPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                ClientPacketHandler.handleHullbackHurtSync(msg);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ItemStack getArmorItem() {
        return this.armorItem;
    }

    public ItemStack getCrownItem() {
        return this.crownItem;
    }

    public byte getFlags() {
        return this.flags;
    }
}

