/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.network;

import com.fruityspikes.whaleborne.server.entities.HullbackEntity;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SyncHullbackDirtPacket {
    private final int entityId;
    private final CompoundTag dirtData;
    private final int arrayType;
    private final boolean isBottom;

    public SyncHullbackDirtPacket(int entityId, BlockState[][] dirtArray, int arrayType, boolean isBottom) {
        this.entityId = entityId;
        this.arrayType = arrayType;
        this.isBottom = isBottom;
        this.dirtData = SyncHullbackDirtPacket.serializeDirtArray(dirtArray);
    }

    public static SyncHullbackDirtPacket decode(final FriendlyByteBuf buf) {
        return new SyncHullbackDirtPacket(buf.readInt(), null, buf.readByte(), buf.readBoolean()){
            private final CompoundTag dirtData;
            {
                super(entityId, dirtArray, arrayType, isBottom);
                this.dirtData = buf.m_130260_();
            }

            @Override
            public CompoundTag getDirtData() {
                return this.dirtData;
            }
        };
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeByte(this.arrayType);
        buf.writeBoolean(this.isBottom);
        buf.m_130079_(this.dirtData);
    }

    public static void handle(SyncHullbackDirtPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient() && (entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.getEntityId())) instanceof HullbackEntity) {
                HullbackEntity hullback = (HullbackEntity)entity;
                BlockState[][] dirtArray = SyncHullbackDirtPacket.deserializeDirtArray(packet.getDirtData());
                if (dirtArray != null) {
                    switch (packet.getArrayType()) {
                        case 0: {
                            hullback.headDirt = dirtArray;
                            break;
                        }
                        case 1: {
                            hullback.headTopDirt = dirtArray;
                            break;
                        }
                        case 2: {
                            hullback.bodyDirt = dirtArray;
                            break;
                        }
                        case 3: {
                            hullback.bodyTopDirt = dirtArray;
                            break;
                        }
                        case 4: {
                            hullback.tailDirt = dirtArray;
                            break;
                        }
                        case 5: {
                            hullback.flukeDirt = dirtArray;
                        }
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static CompoundTag serializeDirtArray(BlockState[][] array) {
        CompoundTag tag = new CompoundTag();
        if (array == null || array.length == 0) {
            tag.m_128405_("width", 0);
            tag.m_128405_("height", 0);
            return tag;
        }
        tag.m_128405_("width", array.length);
        tag.m_128405_("height", array[0].length);
        for (int x = 0; x < array.length; ++x) {
            ListTag column = new ListTag();
            if (array[x] != null) {
                for (int y = 0; y < array[x].length; ++y) {
                    column.add((Object)NbtUtils.m_129202_((BlockState)(array[x][y] != null ? array[x][y] : Blocks.f_50016_.m_49966_())));
                }
            }
            tag.m_128365_("x" + x, (Tag)column);
        }
        return tag;
    }

    public static BlockState[][] deserializeDirtArray(@Nullable CompoundTag tag) {
        if (tag == null || !tag.m_128441_("width") || !tag.m_128441_("height")) {
            return new BlockState[0][0];
        }
        int width = tag.m_128451_("width");
        int height = tag.m_128451_("height");
        BlockState[][] array = new BlockState[width][height];
        for (int x = 0; x < width; ++x) {
            String key = "x" + x;
            if (!tag.m_128441_(key)) continue;
            ListTag column = tag.m_128437_(key, 10);
            for (int y = 0; y < Math.min(column.size(), height); ++y) {
                array[x][y] = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)column.m_128728_(y));
            }
        }
        return array;
    }

    public CompoundTag getDirtData() {
        return this.dirtData;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getArrayType() {
        return this.arrayType;
    }

    public boolean isBottom() {
        return this.isBottom;
    }
}

