/*
 * Decompiled with CFR 0.152.
 */
package com.fruityspikes.whaleborne.server.entities;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;

public abstract class WhaleWidgetEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(WhaleWidgetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(WhaleWidgetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(WhaleWidgetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected Item item;

    public WhaleWidgetEntity(EntityType<?> entityType, Level level, Item dropItem) {
        super(entityType, level);
        this.item = dropItem;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void setDamage(float damageTaken) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int hurtTime) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)hurtTime);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtDir(int hurtDirection) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)hurtDirection);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.f_19797_ > 100 && !this.m_20159_()) {
            this.destroy(null);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.item.m_7968_();
    }

    public boolean m_5829_() {
        return false;
    }

    public void m_6053_(float yaw) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    protected void destroy(DamageSource damageSource) {
        this.m_19998_((ItemLike)this.getDropItem());
        this.m_6074_();
    }

    public Item getDropItem() {
        return this.item;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            boolean flag;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, source.m_7639_());
            boolean bl = flag = source.m_7639_() instanceof Player && ((Player)source.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                if (!flag && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.destroy(source);
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return super.m_6096_(player, hand);
    }

    public boolean m_142391_() {
        return true;
    }

    public boolean m_20086_(CompoundTag compound) {
        return super.m_20086_(compound);
    }
}

