/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fortnicraft.init;

import java.util.Map;
import net.mcreator.fortnicraft.FortnicraftMod;
import net.mcreator.fortnicraft.init.FortnicraftModScreens;
import net.mcreator.fortnicraft.network.MenuStateUpdateMessage;
import net.mcreator.fortnicraft.world.inventory.AmmoGuiMenu;
import net.mcreator.fortnicraft.world.inventory.RareChestGuiMenu;
import net.mcreator.fortnicraft.world.inventory.TreasureChestGuiMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FortnicraftModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"fortnicraft");
    public static final RegistryObject<MenuType<TreasureChestGuiMenu>> TREASURE_CHEST_GUI = REGISTRY.register("treasure_chest_gui", () -> IForgeMenuType.create(TreasureChestGuiMenu::new));
    public static final RegistryObject<MenuType<RareChestGuiMenu>> RARE_CHEST_GUI = REGISTRY.register("rare_chest_gui", () -> IForgeMenuType.create(RareChestGuiMenu::new));
    public static final RegistryObject<MenuType<AmmoGuiMenu>> AMMO_GUI = REGISTRY.register("ammo_gui", () -> IForgeMenuType.create(AmmoGuiMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FortnicraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof FortnicraftModScreens.ScreenAccessor) {
                    FortnicraftModScreens.ScreenAccessor accessor = (FortnicraftModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                FortnicraftMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

