/*
 * Decompiled with CFR 0.152.
 */
package me.alexandru302.cwsmtractorbeamfix.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.alexandru302.cwsmtractorbeamfix.CWSMTractorBeamFix;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import nonamecrackers2.witherstormmod.api.common.entity.WitherStormBase;
import nonamecrackers2.witherstormmod.client.init.WitherStormModClientCapabilities;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import traben.entity_model_features.utils.EMFEntity;

public class TractorBeamRenderHelper {
    private static final float defBMFX = 6.942067E8f;
    private static final Map<UUID, Map<String, Float>> headAnimationVariables = new HashMap<UUID, Map<String, Float>>();

    public static void updateAllWitherStormRotations() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        level.getCapability(WitherStormModClientCapabilities.DISTANT_RENDERER).ifPresent(distantRenderer -> {
            for (WitherStormEntity entity : distantRenderer.getKnown()) {
                TractorBeamRenderHelper.updateEntityHeadVariables((Entity)entity);
            }
        });
        for (Entity entity : level.m_104735_()) {
            TractorBeamRenderHelper.updateEntityHeadVariables(entity);
        }
    }

    private static void updateEntityHeadVariables(Entity entity) {
        if (!(entity instanceof EMFEntity)) {
            return;
        }
        EMFEntity emfEntity = (EMFEntity)entity;
        String type = emfEntity.emf$getTypeString();
        if (!type.contains("wither_storm")) {
            return;
        }
        Object2FloatOpenHashMap map = emfEntity.emf$getVariableMap();
        if (map == null || map.isEmpty()) {
            return;
        }
        HashMap<CallSite, Float> headVars = new HashMap<CallSite, Float>(8);
        for (int i = 0; i <= 2; ++i) {
            headVars.put((CallSite)((Object)("var.bmfxhead" + i + "rx")), map.getOrDefault("var.bmfxhead" + i + "rx", Float.valueOf(6.942067E8f)));
            headVars.put((CallSite)((Object)("var.bmfxhead" + i + "ry")), map.getOrDefault("var.bmfxhead" + i + "ry", Float.valueOf(6.942067E8f)));
            headVars.put((CallSite)((Object)("var.bmfxhead" + i + "rz")), map.getOrDefault("var.bmfxhead" + i + "rz", Float.valueOf(6.942067E8f)));
            headVars.put((CallSite)((Object)("var.bmfxhead" + i + "uprz")), map.getOrDefault("var.bmfxhead" + i + "uprz", Float.valueOf(6.942067E8f)));
            headVars.put((CallSite)((Object)("var.bmfxhead" + i + "tx")), map.getOrDefault("var.bmfxhead" + i + "tx", Float.valueOf(6.942067E8f)));
            headVars.put((CallSite)((Object)("var.bmfxhead" + i + "ty")), map.getOrDefault("var.bmfxhead" + i + "ty", Float.valueOf(6.942067E8f)));
            headVars.put((CallSite)((Object)("var.bmfxhead" + i + "tz")), map.getOrDefault("var.bmfxhead" + i + "tz", Float.valueOf(6.942067E8f)));
        }
        headAnimationVariables.put(emfEntity.etf$getUuid(), headVars);
    }

    public static Map<String, Float> getHeadAnimationVars(UUID uuid) {
        return headAnimationVariables.getOrDefault(uuid, Map.of());
    }

    public static <T extends LivingEntity> void renderTractorBeam(T entity, PoseStack stack, MultiBufferSource buffer, int packedLightIn, float r, float g, float b, float a, float partialTicks, double tractorBeamCutoff, float endFadeAlpha, ModelPart head, float tractorBeamXOffset, float tractorBeamYOffset, float tractorBeamZOffset, float pivotOffsetX, float pivotOffsetY, float pivotOffsetZ, float scale, float tractorBeamDistance, float tractorBeamStartSize, float tractorBeamEndSize, Integer headIndex, boolean isHeadEntity) {
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_(-Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_)));
        if (entity instanceof WitherStormBase && entity.m_20089_() != Pose.SLEEPING) {
            float xBodyRot = Mth.m_14189_((float)partialTicks, (float)((WitherStormBase)entity).getXBodyRotO(), (float)((WitherStormBase)entity).getXBodyRot());
            stack.m_252781_(Axis.f_252529_.m_252977_(-xBodyRot));
        }
        Map<String, Float> animVars = TractorBeamRenderHelper.getHeadAnimationVars(entity.m_20148_());
        if (CWSMTractorBeamFix.canBeamFix()) {
            if (isHeadEntity) {
                float uprz;
                float rx;
                float ry;
                float rz = animVars.getOrDefault("var.bmfxhead0rz", Float.valueOf(6.942067E8f)).floatValue();
                if (TractorBeamRenderHelper.anyDefault(6.942067E8f, rz, ry = animVars.getOrDefault("var.bmfxhead0ry", Float.valueOf(6.942067E8f)).floatValue(), rx = animVars.getOrDefault("var.bmfxhead0rx", Float.valueOf(6.942067E8f)).floatValue(), uprz = animVars.getOrDefault("var.bmfxhead0uprz", Float.valueOf(6.942067E8f)).floatValue())) {
                    stack.m_252880_((head.f_104200_ + tractorBeamXOffset) / 8.0f * scale, -((head.f_104201_ - tractorBeamYOffset) / 8.0f) * scale, -((head.f_104202_ - tractorBeamZOffset) / 8.0f) * scale);
                    stack.m_252781_(Axis.f_252403_.m_252961_(-head.f_104205_));
                    stack.m_252781_(Axis.f_252436_.m_252961_(-head.f_104204_ - (float)Math.toRadians(90.0)));
                    stack.m_252781_(Axis.f_252403_.m_252961_(-head.f_104203_));
                } else {
                    stack.m_252880_((head.f_104200_ + tractorBeamXOffset) / 8.0f * scale, -((head.f_104201_ - tractorBeamYOffset) / 8.0f) * scale, -((head.f_104202_ - tractorBeamZOffset) / 8.0f) * scale);
                    stack.m_252781_(Axis.f_252403_.m_252961_(-head.f_104205_));
                    stack.m_252781_(Axis.f_252436_.m_252961_(-head.f_104204_ - (float)Math.toRadians(90.0)));
                    stack.m_252781_(Axis.f_252403_.m_252961_(-head.f_104203_));
                    stack.m_252781_(Axis.f_252529_.m_252961_(-rz));
                    stack.m_252781_(Axis.f_252436_.m_252961_(-ry));
                    stack.m_252781_(Axis.f_252403_.m_252961_(-rx));
                    stack.m_252781_(Axis.f_252529_.m_252961_(-uprz));
                }
            } else {
                float uprz;
                float rx;
                float ry;
                float rz;
                float tz;
                float ty;
                float tx;
                WitherStormEntity storm;
                int indix;
                int n = indix = headIndex != null ? headIndex : 1;
                if (entity instanceof WitherStormEntity && (storm = (WitherStormEntity)entity).getPhase() < 4) {
                    indix = 0;
                }
                if (TractorBeamRenderHelper.anyDefault(6.942067E8f, tx = animVars.getOrDefault("var.bmfxhead" + indix + "tx", Float.valueOf(6.942067E8f)).floatValue(), ty = animVars.getOrDefault("var.bmfxhead" + indix + "ty", Float.valueOf(6.942067E8f)).floatValue(), tz = animVars.getOrDefault("var.bmfxhead" + indix + "tz", Float.valueOf(6.942067E8f)).floatValue(), rz = animVars.getOrDefault("var.bmfxhead" + indix + "rz", Float.valueOf(6.942067E8f)).floatValue(), ry = animVars.getOrDefault("var.bmfxhead" + indix + "ry", Float.valueOf(6.942067E8f)).floatValue(), rx = animVars.getOrDefault("var.bmfxhead" + indix + "rx", Float.valueOf(6.942067E8f)).floatValue(), uprz = animVars.getOrDefault("var.bmfxhead" + indix + "uprz", Float.valueOf(6.942067E8f)).floatValue())) {
                    stack.m_252880_((head.f_104200_ + tractorBeamXOffset) / 8.0f * scale, -((head.f_104201_ - tractorBeamYOffset) / 8.0f) * scale, -((head.f_104202_ - tractorBeamZOffset) / 8.0f) * scale);
                    stack.m_252781_(Axis.f_252403_.m_252961_(-head.f_104205_));
                    stack.m_252781_(Axis.f_252436_.m_252961_(-head.f_104204_ - (float)Math.toRadians(90.0)));
                    stack.m_252781_(Axis.f_252403_.m_252961_(-head.f_104203_));
                } else {
                    stack.m_252880_((tx + tractorBeamXOffset) / 8.0f * scale, -((ty - tractorBeamYOffset) / 8.0f * scale), -((tz - tractorBeamZOffset) / 8.0f * scale));
                    stack.m_252781_(Axis.f_252436_.m_252961_((float)Math.toRadians(90.0)));
                    stack.m_252781_(Axis.f_252529_.m_252961_(-rz));
                    stack.m_252781_(Axis.f_252436_.m_252961_(-ry));
                    stack.m_252781_(Axis.f_252403_.m_252961_(-rx));
                    stack.m_252781_(Axis.f_252529_.m_252961_(-uprz));
                }
            }
        } else {
            stack.m_252880_((head.f_104200_ + tractorBeamXOffset) / 8.0f * scale, -((head.f_104201_ - tractorBeamYOffset) / 8.0f) * scale, -((head.f_104202_ - tractorBeamZOffset) / 8.0f) * scale);
            stack.m_252781_(Axis.f_252403_.m_252961_(-head.f_104205_));
            stack.m_252781_(Axis.f_252436_.m_252961_(-head.f_104204_ - (float)Math.toRadians(90.0)));
            stack.m_252781_(Axis.f_252403_.m_252961_(-head.f_104203_));
        }
        stack.m_85841_(scale, scale, scale);
        stack.m_252880_(pivotOffsetX / 8.0f * scale, pivotOffsetY / 8.0f * scale, pivotOffsetZ / 8.0f * scale);
        PoseStack.Pose entry = stack.m_85850_();
        float distance = tractorBeamCutoff != -1.0 ? (float)tractorBeamCutoff : tractorBeamDistance;
        float distanceScale = tractorBeamEndSize / tractorBeamDistance;
        float endSize = distanceScale * distance;
        TractorBeamRenderHelper.vertexBuilder(buffer.m_6299_(RenderType.m_110502_()), entry.m_252922_(), entry.m_252943_(), tractorBeamStartSize, r, g, b, a, distance, endSize, endFadeAlpha, packedLightIn);
        stack.m_85849_();
    }

    private static boolean anyDefault(float def, float ... values) {
        for (float v : values) {
            if (v != def) continue;
            return true;
        }
        return false;
    }

    public static void vertexBuilder(VertexConsumer builder, Matrix4f matrix4f, Matrix3f matrix3f, float tractorBeamStartSize, float r, float g, float b, float a, float distance, float endSize, float endFadeAlpha, int packedLightIn) {
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, -endSize, endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, endSize, endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, endSize, -endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, -endSize, -endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, endSize, -endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, endSize, endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, -endSize, endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, -endSize, -endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, -endSize, -endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, endSize, -endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, endSize, endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, -endSize, endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, endSize, endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f + tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, endSize, -endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, -endSize, -endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f - tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f - tractorBeamStartSize, 0.0f + tractorBeamStartSize).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, -distance, -endSize, endSize).m_85950_(r, g, b, endFadeAlpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
    }
}

