/*
 * Decompiled with CFR 0.152.
 */
package me.alexandru302.cwsmtractorbeamfix.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import me.alexandru302.cwsmtractorbeamfix.client.util.TractorBeamRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.witherstormmod.client.renderer.entity.AbstractWitherStormRenderer;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.AbstractWitherStormModel;
import nonamecrackers2.witherstormmod.client.renderer.entity.model.witherstorm.HeadModel;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractWitherStormRenderer.class})
public abstract class AbstractWitherStormRendererMixin<T extends WitherStormEntity, M extends AbstractWitherStormModel<T>> {
    @Shadow
    public abstract M getModel();

    @Redirect(method={"renderTractorBeams"}, at=@At(value="INVOKE", target="Lnonamecrackers2/witherstormmod/client/renderer/entity/model/witherstorm/HeadModel;renderTractorBeam(Lnet/minecraft/world/entity/LivingEntity;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IFFFFFDF)V"), remap=false)
    private void redirectRenderTractorBeam(HeadModel<T> head, LivingEntity entity, PoseStack stack, MultiBufferSource buffer, int packedLight, float r, float g, float b, float alpha, float partialTicks, double cutoff, float extra) {
        int headIndex = this.cwsmtractorbeamfix$getHeadIndex(head);
        if (headIndex == -1) {
            return;
        }
        TractorBeamRenderer renderer = (TractorBeamRenderer)head;
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double distance = cameraPos.m_82554_(entity.m_20182_());
        float renderDistance = (float)((Integer)mc.f_91066_.m_231984_().m_231551_()).intValue() / 16.0f;
        float distLerp = AbstractWitherStormRenderer.getDistanceLerp((double)distance, (float)renderDistance);
        float endFadeAlpha = 0.5f * (1.0f - distLerp);
        switch (headIndex) {
            case 0: {
                renderer.cwsmtractorbeamfix$renderBeam((WitherStormEntity)entity, stack, buffer, packedLight, r, g, b, 0.5f, partialTicks, cutoff, endFadeAlpha, 1);
                break;
            }
            case 1: {
                renderer.cwsmtractorbeamfix$renderBeam((WitherStormEntity)entity, stack, buffer, packedLight, r, g, b, 0.5f, partialTicks, cutoff, endFadeAlpha, 2);
                break;
            }
            case 2: {
                renderer.cwsmtractorbeamfix$renderBeam((WitherStormEntity)entity, stack, buffer, packedLight, r, g, b, 0.5f, partialTicks, cutoff, endFadeAlpha, 0);
            }
        }
    }

    @Unique
    private int cwsmtractorbeamfix$getHeadIndex(HeadModel<T> head) {
        for (Int2ObjectMap.Entry entry : ((AbstractWitherStormModel)this.getModel()).heads.int2ObjectEntrySet()) {
            if (entry.getValue() != head) continue;
            return entry.getIntKey();
        }
        return -1;
    }
}

