/*
 * Decompiled with CFR 0.152.
 */
package com.kevo.svcmuteaddon.client;

import com.kevo.svcmuteaddon.client.ClientMuteState;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(modid="svcmuteaddon", value={Dist.CLIENT})
public class HudOverlay {
    private static final ResourceLocation MUTED_ICON = ResourceLocation.fromNamespaceAndPath((String)"svcmuteaddon", (String)"textures/gui/mic_muted.png");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderGui(RenderGuiEvent.Post event) {
        if (!ClientMuteState.isMuted()) {
            return;
        }
        GuiGraphics g = event.getGuiGraphics();
        Minecraft mc = Minecraft.getInstance();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        float scale = 1.5f;
        int newSize = (int)(16.0f * scale);
        int drawX = (screenWidth - newSize) / 2;
        int drawY = screenHeight - 50;
        RenderSystem.enableBlend();
        g.pose().pushPose();
        g.pose().translate((float)drawX, (float)drawY, 0.0f);
        g.pose().scale(scale, scale, 1.0f);
        g.blit(MUTED_ICON, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        g.pose().popPose();
        RenderSystem.disableBlend();
    }
}

