/*
 * Decompiled with CFR 0.152.
 */
package com.kevo.svcmuteaddon.mod;

import com.kevo.svcmuteaddon.mod.VcModeration;
import com.kevo.svcmuteaddon.net.Net;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class VcCommands {
    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"vcmod").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lockdown").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"on").executes(ctx -> VcCommands.setLock((CommandSourceStack)ctx.getSource(), true)))).then(Commands.literal((String)"off").executes(ctx -> VcCommands.setLock((CommandSourceStack)ctx.getSource(), false))))).then(((LiteralArgumentBuilder)Commands.literal((String)"mute").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> VcCommands.mutePlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"unmute").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> VcCommands.unmutePlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player")))))).then(Commands.literal((String)"list").executes(ctx -> VcCommands.listState((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"mutegroup").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            VcModeration.muteGroup(StringArgumentType.getString((CommandContext)ctx, (String)"group"));
            VcCommands.msg((CommandSourceStack)ctx.getSource(), "Group muted.");
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"unmutegroup").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            VcModeration.unmuteGroup(StringArgumentType.getString((CommandContext)ctx, (String)"group"));
            VcCommands.msg((CommandSourceStack)ctx.getSource(), "Group unmuted.");
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"allow").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> VcCommands.allowPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), true))))).then(Commands.literal((String)"group").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            VcModeration.allowGroup(StringArgumentType.getString((CommandContext)ctx, (String)"group"));
            VcCommands.msg((CommandSourceStack)ctx.getSource(), "Group allowed to speak.");
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"disallow").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> VcCommands.allowPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), false))))).then(Commands.literal((String)"group").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            VcModeration.disallowGroup(StringArgumentType.getString((CommandContext)ctx, (String)"group"));
            VcCommands.msg((CommandSourceStack)ctx.getSource(), "Group removed from allowed list.");
            return 1;
        })))));
    }

    private static int setLock(CommandSourceStack src, boolean on) {
        VcModeration.setLockdown(on);
        VcCommands.msg(src, on ? "Lockdown ENABLED: only allowed players can speak." : "Lockdown DISABLED.");
        return 1;
    }

    private static int mutePlayer(CommandSourceStack src, String name) {
        UUID u = VcCommands.resolveUuid(src, name);
        if (u == null) {
            VcCommands.msg(src, "Could not resolve UUID for " + name);
            return 0;
        }
        VcModeration.mutePlayer(u);
        ServerPlayer sp = src.getServer().getPlayerList().getPlayer(u);
        if (sp != null) {
            sp.sendSystemMessage((Component)Component.literal((String)"[VCMod] You have been muted."));
            Net.sendMuteStatus(sp, true);
        }
        VcCommands.msg(src, "Muted player: " + name);
        return 1;
    }

    private static int unmutePlayer(CommandSourceStack src, String name) {
        UUID u = VcCommands.resolveUuid(src, name);
        if (u == null) {
            VcCommands.msg(src, "Could not resolve UUID for " + name);
            return 0;
        }
        VcModeration.unmutePlayer(u);
        ServerPlayer sp = src.getServer().getPlayerList().getPlayer(u);
        if (sp != null) {
            sp.sendSystemMessage((Component)Component.literal((String)"[VCMod] You have been unmuted."));
            Net.sendMuteStatus(sp, false);
        }
        VcCommands.msg(src, "Unmuted player: " + name);
        return 1;
    }

    private static int allowPlayer(CommandSourceStack src, String name, boolean add) {
        UUID u = VcCommands.resolveUuid(src, name);
        if (u == null) {
            VcCommands.msg(src, "Could not resolve UUID for " + name);
            return 0;
        }
        if (add) {
            VcModeration.allowPlayer(u);
            VcCommands.msg(src, "Player allowed to speak: " + name);
        } else {
            VcModeration.disallowPlayer(u);
            VcCommands.msg(src, "Player removed from allowed list: " + name);
        }
        return 1;
    }

    private static UUID resolveUuid(CommandSourceStack src, String name) {
        MinecraftServer srv = src.getServer();
        GameProfile prof = srv.getProfileCache().get(name).orElse(null);
        return prof == null ? null : prof.getId();
    }

    private static int listState(CommandSourceStack src) {
        Set<UUID> mutedUuids = VcModeration.getMutedPlayers();
        Set<String> mutedGroups = VcModeration.getMutedGroups();
        Set<UUID> allowedUuids = VcModeration.getAllowedPlayers();
        Set<String> allowedGroups = VcModeration.getAllowedGroups();
        VcCommands.msg(src, "Lockdown: " + (VcModeration.isLockdown() ? "ON" : "OFF"));
        Function<UUID, String> fmt = uuid -> {
            ServerPlayer sp = src.getServer().getPlayerList().getPlayer(uuid);
            if (sp != null) {
                return sp.getScoreboardName();
            }
            GameProfile prof = src.getServer().getProfileCache().get(uuid).orElse(null);
            return prof != null ? prof.getName() + " (" + uuid.toString().substring(0, 8) + ")" : uuid.toString().substring(0, 8);
        };
        VcCommands.msg(src, "Muted players: " + (mutedUuids.isEmpty() ? "-" : String.join((CharSequence)", ", mutedUuids.stream().map(fmt).toList())));
        VcCommands.msg(src, "Muted groups: " + (mutedGroups.isEmpty() ? "-" : String.join((CharSequence)", ", mutedGroups)));
        VcCommands.msg(src, "Allowed players: " + (allowedUuids.isEmpty() ? "-" : String.join((CharSequence)", ", allowedUuids.stream().map(fmt).toList())));
        VcCommands.msg(src, "Allowed groups: " + (allowedGroups.isEmpty() ? "-" : String.join((CharSequence)", ", allowedGroups)));
        return 1;
    }

    private static void msg(CommandSourceStack src, String m) {
        src.sendSuccess(() -> Component.literal((String)("[VCMod] " + m)), true);
    }
}

