/*
 * Decompiled with CFR 0.152.
 */
package com.kevo.svcmuteaddon.voice;

import com.kevo.svcmuteaddon.mod.VcModeration;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStoppedEvent;
import java.util.UUID;

@ForgeVoicechatPlugin
public class VcVoicePlugin
implements VoicechatPlugin {
    public static volatile VoicechatServerApi VC_API;

    public String getPluginId() {
        return "svcmuteaddon";
    }

    public void initialize(VoicechatApi api) {
        System.out.println("[SVCMuteAddon] initialize() \u2013 Voicechat API inicializada");
    }

    public void registerEvents(EventRegistration reg) {
        System.out.println("[SVCMuteAddon] registerEvents()");
        reg.registerEvent(VoicechatServerStartedEvent.class, e -> {
            VC_API = e.getVoicechat();
            System.out.println("[SVCMuteAddon] VoicechatServerStarted");
        });
        reg.registerEvent(VoicechatServerStoppedEvent.class, e -> {
            VC_API = null;
            System.out.println("[SVCMuteAddon] VoicechatServerStopped");
        });
        reg.registerEvent(MicrophonePacketEvent.class, e -> {
            VoicechatConnection conn = e.getSenderConnection();
            if (conn == null || conn.getPlayer() == null) {
                System.out.println("[SVCMuteAddon] MicPkt sin conexi\u00f3n/jugador");
                return;
            }
            UUID senderUuid = conn.getPlayer().getUuid();
            String groupName = conn.getGroup() == null ? null : conn.getGroup().getName();
            System.out.println("[SVCMuteAddon] MicPkt de " + String.valueOf(senderUuid) + " en " + (groupName == null ? "(proximidad)" : groupName) + " \u2013 cancellable=" + e.isCancellable());
            if (!e.isCancellable()) {
                return;
            }
            if (VcModeration.shouldMute(senderUuid, groupName)) {
                System.out.println("[SVCMuteAddon] >>> CANCELADO paquete de " + String.valueOf(senderUuid));
                e.cancel();
            }
        });
    }
}

