/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferrinember.simpleblockphysics.mixin;

import io.github.ferrinember.simpleblockphysics.Config;
import io.github.ferrinember.simpleblockphysics.utils.TickHandler;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingEntityMixin
extends Entity {
    @Shadow
    private BlockState f_31946_;

    @Shadow
    public abstract BlockState m_31980_();

    public FallingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/FallingBlockEntity;onGround()Z")}, cancellable=true)
    public void addTickCheck(CallbackInfo ci) {
        if (this.m_20096_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), this.m_31980_().m_60827_().m_56775_(), SoundSource.BLOCKS, Config.blockBreakVolume.floatValue(), 1.0f);
            if ((double)TickHandler.getSupportStrength(this.m_31980_(), this.m_20183_(), this.m_9236_()) * 0.1 - 1.0 + 2.0 * Config.fallingBlockBreakFactor >= this.m_9236_().m_213780_().m_188500_()) {
                this.m_9236_().m_7654_().m_129880_(this.m_9236_().m_46472_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_31980_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 50, 0.0, 0.05, 0.0, 0.1);
                this.m_142535_(this.f_19789_, Config.dmgMax.intValue(), this.m_269291_().m_269564_((Entity)this));
                if (Config.fallingBlockItemDropChance >= this.m_9236_().m_213780_().m_188500_()) {
                    this.m_31980_().m_287290_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81461_, (Object)this.m_31980_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42384_))).forEach(arg_0 -> ((FallingEntityMixin)this).m_19983_(arg_0));
                }
                this.m_146870_();
                ci.cancel();
            } else {
                ArrayList<Direction> validShiftDirList = new ArrayList<Direction>();
                for (int i = 1; i <= 4; ++i) {
                    BlockPos sidePos = this.m_20183_().m_175288_(this.m_146904_()).m_121945_(Direction.m_122407_((int)i));
                    BlockPos belowSidePos = this.m_20183_().m_175288_(this.m_146904_() - 1).m_121945_(Direction.m_122407_((int)i));
                    if (!this.m_9236_().m_8055_(sidePos).m_60742_((BlockGetter)this.m_9236_(), sidePos, CollisionContext.m_82750_((Entity)this)).m_83281_() || !this.m_9236_().m_8055_(belowSidePos).m_60742_((BlockGetter)this.m_9236_(), belowSidePos, CollisionContext.m_82750_((Entity)this)).m_83281_()) continue;
                    validShiftDirList.add(Direction.m_122407_((int)i));
                }
                if (!validShiftDirList.isEmpty()) {
                    Direction fallDir = (Direction)validShiftDirList.get(this.m_9236_().m_213780_().m_216332_(0, validShiftDirList.size() - 1));
                    FallingBlockEntity newFallingBlockEntity = FallingBlockEntity.m_201971_((Level)this.m_9236_(), (BlockPos)this.m_20183_().m_121945_(fallDir), (BlockState)this.m_31980_());
                    newFallingBlockEntity.m_149656_((float)Config.dmgDist.intValue(), Config.dmgMax.intValue());
                    newFallingBlockEntity.f_31943_ = false;
                    this.m_142535_(this.f_19789_, Config.dmgMax.intValue(), this.m_269291_().m_269564_((Entity)this));
                    this.m_146870_();
                    ci.cancel();
                }
            }
        }
    }
}

