/*
 * Decompiled with CFR 0.152.
 */
package io.github.ferrinember.simpleblockphysics.utils;

import io.github.ferrinember.simpleblockphysics.Config;
import io.github.ferrinember.simpleblockphysics.utils.PosLevelKey;
import io.github.ferrinember.simpleblockphysics.utils.SupportChecker;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class TickHandler {
    public static LinkedHashMap<PosLevelKey, Integer> checkMap = new LinkedHashMap();
    public static LinkedHashMap<PosLevelKey, Integer> farCheckMap = new LinkedHashMap();
    public static LinkedHashMap<PosLevelKey, Integer> weightMap = new LinkedHashMap();
    public static Integer breakCount = 0;
    public static Integer weightCheckCount = 0;

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START) && event.side.equals((Object)LogicalSide.SERVER)) {
            Integer checkGen;
            Level checkLevel;
            BlockPos checkBlock;
            Map.Entry<PosLevelKey, Integer> checkVal;
            breakCount = 0;
            boolean delay = false;
            if (checkMap.isEmpty() && weightMap.isEmpty() && !farCheckMap.isEmpty()) {
                checkVal = farCheckMap.entrySet().iterator().next();
                farCheckMap.remove(checkVal.getKey());
                checkBlock = checkVal.getKey().getPos();
                checkLevel = checkVal.getKey().getLevel();
                checkGen = checkVal.getValue();
                if (checkLevel.m_46749_(checkBlock)) {
                    this.checkBreak(checkBlock, checkLevel, checkGen);
                } else {
                    farCheckMap.put(checkVal.getKey(), checkVal.getValue());
                }
            } else {
                while (!delay && !checkMap.isEmpty()) {
                    if (breakCount >= Config.maxBreakPerTick) {
                        delay = true;
                    }
                    checkVal = checkMap.entrySet().iterator().next();
                    checkMap.remove(checkVal.getKey());
                    checkBlock = checkVal.getKey().getPos();
                    checkLevel = checkVal.getKey().getLevel();
                    checkGen = checkVal.getValue();
                    if (checkLevel.m_46749_(checkBlock) && checkLevel.m_46745_(checkBlock).m_287138_().equals((Object)FullChunkStatus.ENTITY_TICKING)) {
                        this.checkBreak(checkBlock, checkLevel, checkGen);
                        continue;
                    }
                    farCheckMap.put(checkVal.getKey(), checkVal.getValue());
                }
            }
            weightCheckCount = 0;
            delay = false;
            while (!delay && !weightMap.isEmpty()) {
                if (weightCheckCount >= 20) {
                    delay = true;
                }
                checkVal = weightMap.entrySet().iterator().next();
                weightMap.remove(checkVal.getKey());
                checkBlock = checkVal.getKey().getPos();
                checkLevel = checkVal.getKey().getLevel();
                checkGen = checkVal.getValue();
                this.checkWeight(checkBlock, checkLevel, checkGen);
                Integer n = weightCheckCount;
                weightCheckCount = weightCheckCount + 1;
            }
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        if (!event.level.m_5776_() && event.level.m_7654_() != null && event.level.m_46468_() % 20L == 1L) {
            for (ServerPlayer player : event.level.m_7654_().m_6846_().m_11314_()) {
                BlockPos blockPos = player.m_20097_();
                boolean indusBlock = Config.indestructibleBlocks.contains(event.level.m_8055_(blockPos).m_60734_());
                if (Config.invertIndestructibleBlocks.booleanValue()) {
                    boolean bl = indusBlock = !indusBlock;
                }
                if (!event.level.m_46472_().equals((Object)player.m_9236_().m_46472_()) || player.f_8941_.m_9290_().equals((Object)GameType.SPECTATOR) || !SupportChecker.IsSupport(event.level.m_8055_(blockPos), blockPos, event.level) || indusBlock || checkMap.containsKey(blockPos) || !Config.allowedDimensions.contains(event.level.m_46472_())) continue;
                if (event.level.m_213780_().m_188500_() < 0.05) {
                    weightMap.put(new PosLevelKey(blockPos, event.level), 1);
                    continue;
                }
                checkMap.put(new PosLevelKey(blockPos, event.level), 1);
            }
        }
    }

    public void checkBreak(BlockPos blockPos, Level level, Integer generation) {
        HashSet<BlockPos> supportSet = new HashSet<BlockPos>();
        HashSet<Object> newlyAddedSet = new HashSet<Object>();
        HashSet<BlockPos> freshSet = new HashSet<BlockPos>();
        newlyAddedSet.add(blockPos);
        for (int i = 1; i <= TickHandler.getSupportStrength(level.m_8055_(blockPos), blockPos, level); ++i) {
            for (BlockPos blockPos2 : newlyAddedSet) {
                for (BlockPos adjCurrentPos : BlockPos.m_121940_((BlockPos)blockPos2.m_7918_(-1, -1, -1), (BlockPos)blockPos2.m_7918_(1, 1, 1))) {
                    boolean isSupport = SupportChecker.IsSupport(level.m_8055_(adjCurrentPos), adjCurrentPos, level) || Config.buoyancyEnabled != false && level.m_8055_(adjCurrentPos).m_60819_().m_76170_() || level.m_8055_(blockPos).m_60713_(Blocks.f_50080_) && level.m_8055_(adjCurrentPos).m_60819_().m_164512_((Fluid)Fluids.f_76195_) || level.m_8055_(blockPos).m_204336_(BlockTags.f_13047_) && level.m_8055_(adjCurrentPos).m_60819_().m_164512_((Fluid)Fluids.f_76193_);
                    if (!isSupport || supportSet.contains(adjCurrentPos) || adjCurrentPos.m_123333_((Vec3i)blockPos2) != 1 || adjCurrentPos.equals((Object)blockPos)) continue;
                    if (adjCurrentPos.m_123342_() < blockPos.m_123342_()) {
                        boolean indusBlock = Config.indestructibleBlocks.contains(level.m_8055_(adjCurrentPos).m_60734_());
                        if (Config.invertIndestructibleBlocks.booleanValue()) {
                            boolean bl = indusBlock = !indusBlock;
                        }
                        if (!indusBlock && generation <= Config.supportSearchIter) {
                            checkMap.put(new PosLevelKey(adjCurrentPos.m_7949_(), level), generation + 1);
                        }
                        return;
                    }
                    supportSet.add(adjCurrentPos.m_7949_());
                    freshSet.add(adjCurrentPos.m_7949_());
                }
            }
            newlyAddedSet.clear();
            newlyAddedSet.addAll(freshSet);
            freshSet.clear();
        }
        TickHandler.breakBlock(blockPos, level);
    }

    public void checkWeight(BlockPos blockPos, Level level, Integer weight) {
        HashSet<BlockPos> supportSet = new HashSet<BlockPos>();
        HashSet<Object> newlyAddedSet = new HashSet<Object>();
        HashSet<BlockPos> freshSet = new HashSet<BlockPos>();
        newlyAddedSet.add(blockPos);
        for (int i = 1; i <= TickHandler.getSupportStrength(level.m_8055_(blockPos), blockPos, level); ++i) {
            for (BlockPos blockPos2 : newlyAddedSet) {
                for (BlockPos adjCurrentPos : BlockPos.m_121940_((BlockPos)blockPos2.m_7918_(-1, -1, -1), (BlockPos)blockPos2.m_7918_(1, 1, 1))) {
                    if (!(SupportChecker.IsSupport(level.m_8055_(adjCurrentPos), adjCurrentPos, level) || Config.buoyancyEnabled != false && level.m_8055_(adjCurrentPos).m_60819_().m_76170_() || level.m_8055_(blockPos).m_60713_(Blocks.f_50080_) && level.m_8055_(adjCurrentPos).m_60819_().m_164512_((Fluid)Fluids.f_76195_)) && (!level.m_8055_(blockPos).m_204336_(BlockTags.f_13047_) || !level.m_8055_(adjCurrentPos).m_60819_().m_164512_((Fluid)Fluids.f_76193_)) || supportSet.contains(adjCurrentPos) || adjCurrentPos.m_123333_((Vec3i)blockPos2) != 1 || adjCurrentPos.equals((Object)blockPos)) continue;
                    int n = 1;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!SupportChecker.IsSupport(level.m_8055_(adjCurrentPos.m_121945_(direction)), adjCurrentPos.m_121945_(direction), level)) continue;
                        ++n;
                    }
                    boolean indusBlock = Config.indestructibleBlocks.contains(level.m_8055_(adjCurrentPos).m_60734_());
                    if (Config.invertIndestructibleBlocks.booleanValue()) {
                        boolean bl = indusBlock = !indusBlock;
                    }
                    if (!indusBlock && n * 3 + 3 * TickHandler.getSupportStrength(level.m_8055_(adjCurrentPos), adjCurrentPos, level) <= weight + i) continue;
                    if (adjCurrentPos.m_123342_() < blockPos.m_123342_()) {
                        if (!indusBlock && weight + i <= Config.weightSearchIter && !TickHandler.atGround(adjCurrentPos, level)) {
                            weightMap.put(new PosLevelKey(adjCurrentPos.m_7949_(), level), weight + i);
                        }
                        return;
                    }
                    supportSet.add(adjCurrentPos.m_7949_());
                    freshSet.add(adjCurrentPos.m_7949_());
                }
            }
            newlyAddedSet.clear();
            newlyAddedSet.addAll(freshSet);
            freshSet.clear();
        }
        TickHandler.breakBlock(blockPos, level);
    }

    public static void breakBlock(BlockPos blockPos, Level level) {
        Integer n = breakCount;
        breakCount = breakCount + 1;
        if (Config.removeBlocksInsteadOfFall.booleanValue()) {
            level.m_46961_(blockPos, Config.fallingBlockItemDropChance > level.m_213780_().m_188500_());
        } else {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)blockPos, (BlockState)level.m_8055_(blockPos));
            fallingBlockEntity.m_149656_((float)Config.dmgDist.intValue(), Math.min(TickHandler.getSupportStrength(fallingBlockEntity.m_31980_(), blockPos, level), Config.dmgMax));
            fallingBlockEntity.f_31943_ = false;
        }
    }

    public static boolean atGround(BlockPos blockPos, Level level) {
        for (BlockPos adjCurrentPos : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-4, 0, -4), (BlockPos)blockPos.m_7918_(4, 0, 4))) {
            if (SupportChecker.IsSupport(level.m_8055_(adjCurrentPos), adjCurrentPos, level)) continue;
            return false;
        }
        return true;
    }

    public static int getSupportStrength(BlockState blockState, BlockPos blockPos, Level level) {
        AtomicInteger strength = new AtomicInteger(-1);
        if (!blockState.m_60808_((BlockGetter)level, blockPos).equals(Shapes.m_83144_())) {
            strength.set(3);
        }
        blockState.m_204343_().forEach(blockTagKey -> {
            if (Config.overwrittenTagMap.containsKey(blockTagKey)) {
                strength.set(Config.overwrittenTagMap.get(blockTagKey));
            }
        });
        if (Config.overwrittenBlockMap.containsKey(blockState.m_60734_())) {
            strength.set(Config.overwrittenBlockMap.get(blockState.m_60734_()));
        }
        if (strength.get() == -1) {
            float hardness = blockState.m_60734_().m_155943_();
            if (hardness > 7.0f || hardness < 0.0f) {
                hardness = 7.0f;
            }
            return Math.round((float)(Math.log10(hardness + 1.0f) * ((double)(Config.supportLengthMax - Config.supportLengthMin) / 0.903089987) + (double)Config.supportLengthMin.intValue()));
        }
        return strength.get();
    }
}

