/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class KickAll
extends SubCommand {
    final QueueMain main;

    public KickAll(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "kickall";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.kickall";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return;
        }
        if (args.length < 1) {
            sender.sendMessage(this.getMessages().getComponent("commands.kickall.usage", new String[0]));
            return;
        }
        QueueServer server = this.main.getQueueManager().findServer(args[0]);
        ArrayList<QueuePlayer> kickPlayers = new ArrayList<QueuePlayer>(server.getQueueHolder().getAllPlayers());
        for (QueuePlayer player : kickPlayers) {
            player.getQueueServer().removePlayer(player);
        }
        sender.sendMessage(this.getMessages().getComponent("commands.kickall.success", "SERVER:" + args[0], "NUM:" + kickPlayers.size(), "s:" + (kickPlayers.size() == 1 ? "" : "s")));
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return this.filterCompletion((List<String>)this.main.getQueueManager().getServerNames(), args[0]);
        }
        return Collections.emptyList();
    }
}

